(use-modules (aiscm core) (aiscm magick))
(define (sqr c) (real-part (* c (conj c))))
(define h 240)
(define w 320)
(define idx (indices h w))
(define f (/ 2 h))
(define x (* f (- (% idx w) (/ (* 2 w) 3))))
(define y (* f (- (/ idx w) (/ h 2))))
(define img (fill <ubyte> (list h w) 0))
(define c (+ x (* 0+i y)))
(define z c)
(for-each
  (lambda (i)
    (let* [(m (lt (sqr z) 4))
           (zm (mask z m))
           (cm (mask c m))]
      (set! img (where m (+ img 1) img))
      (set! z (where m (unmask (+ (* zm zm) cm) m) 8))))
  (iota 255))
(write-image img "mandelbrot.png")
