# $Id: edit.tcl,v 1.8 1998/10/07 21:59:57 cthulhu Exp $

proc rangeInitCommand {arg} {
    source "[xxl_library]/globalvars.tcl"

    set globalState2 $arg
    if {$currentRange != ""} {
        CopyToPasteBuffer $activeSheet \
                [lindex $currentRange 0] [lindex $currentRange 1] \
                [lindex $currentRange 2] [lindex $currentRange 3] 
	if { [string compare $arg copyData] == 0} {
	    HelpMessage "Select copy destination and press paste" -1 1
	} else {
	    HelpMessage "Select move destination and press enter" -1 1
	}
	set activeCellCol [lindex $currentRange 0]
	set activeCellRow [lindex $currentRange 1]
        unhighlightCurrentRange [canvasFromSheet $activeSheet]
 	unhighlightColSelection
	unhighlightRowSelection
	highlightActiveCell
    } else {
        CopyToPasteBuffer $activeSheet $activeCellCol $activeCellRow
	if { [string compare $arg copyData] == 0} {
	    HelpMessage "Select copy destination and press paste" -1 1
	} else {
	    HelpMessage "Select move destination and press enter" -1 1
	}
    }

}

proc killCommand {} {
    source "[xxl_library]/globalvars.tcl"

    if {$cols_selected != ""} {
	DeleteRowOrColumn $activeSheet [lindex $cols_selected 0] \
	    [expr abs([expr [lindex $cols_selected 0] - \
			   [lindex $cols_selected 1]])+1] \
	    c 1

	unhighlightColSelection
    } elseif {$rows_selected != ""} {
	DeleteRowOrColumn $activeSheet [lindex $rows_selected 0] \
	    [expr abs([expr [lindex $rows_selected 0] - \
			   [lindex $rows_selected 1]])+1] \
	    r 1

	unhighlightRowSelection
    } elseif {$currentRange != ""} {
        set s "RangeKill $activeSheet $currentRange"
        eval $s
        unhighlightCurrentRange [canvasFromSheet $activeSheet]
    } else {
        RangeKill $activeSheet $activeCellCol $activeCellRow
    }
    set rows_selected {}
    set cols_seleted {}
    set currentRange ""
    nextCell
}


proc copyExec {} {
    source "[xxl_library]/globalvars.tcl"

    if {$currentRange != ""} {
         Paste $activeSheet \
                [lindex $currentRange 0] [lindex $currentRange 1] \
                [lindex $currentRange 2] [lindex $currentRange 3] 0 0
	set activeCellCol [lindex $currentRange 0]
	set activeCellRow [lindex $currentRange 1]
        unhighlightCurrentRange [canvasFromSheet $activeSheet]
 	unhighlightColSelection
	unhighlightRowSelection
	highlightActiveCell
    } else {
        Paste $activeSheet $activeCellCol $activeCellRow 0 0
    }
    set globalState2 normal
    HelpMessage Ready
    highlightActiveCell
}

proc moveExec {} {
    source "[xxl_library]/globalvars.tcl"

    RangeMove $activeSheet $activeCellCol $activeCellRow        
    HelpMessage Ready
}

proc editCopy {} {

}


# $Log: edit.tcl,v $
# Revision 1.8  1998/10/07 21:59:57  cthulhu
# Merged Paste and PasteSpecial.
# User interface changes to make it more intuitive when cutting/pasting.
#
# Revision 1.7  1998/10/06 19:29:23  cthulhu
# Added HelpMessage calls to copyExec and moveExec.
#
# Revision 1.6  1998/10/01 22:03:15  cthulhu
# Fixed move plus helpmessage.
#
# Revision 1.5  1998/08/06 21:08:29  aml
# Released alpha version of Abacus.
#
# Revision 1.4  1997/01/07 01:07:39  aml
# Error propagation for formulas fixed.
# Edit operations in place.
#
# Revision 1.3  1996/03/07  20:32:54  aml
# Created print range ability.
# Set in gray non-working menus.
# Created RangeKill command.
# Created round function and macros for single argument functions.
#
# Revision 1.2  1996/02/13  21:55:17  aml
# Fixed problems with change to elf.
# RangeCopy created. Works !
# Pressed mouse leaving canvas will cause scroll. Works, but needs to
# keep moving.
#
# Revision 1.1  1996/02/13  20:05:05  aml
# Initial revision
#