<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" version="1.0">

  <xsl:output method="html" indent="yes"/>

  <!-- template rule matching source root element -->
  <xsl:template match="/">
    <html> <head> 
    <title>Java AVK for the Enterprise Report Tool </title>
    <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
    <LINK href="./appVerification.css" rel="stylesheet" type="text/css"> 
    </LINK>
    </meta>
    </head>

    <xsl:apply-templates select="report"/>
    </html>
  </xsl:template>

  <xsl:template match="report">
     <body bgcolor="#FFFFFF" background="./Lt_BluePaperTexture.gif">
     <form method="post" action="">
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
           <tr bgcolor="7171A5">
             <td width="100%"> 
                <div class="page-title-text" align="left">Java AVK for the Enterprise - Runtime Deployment Descriptor Translation Summary </div>
             </td>
           </tr>
        </table>
     <br>

      <table class="back-table" border="0" cellspacing="0" cellpadding="0" width="100%">
        <tr> 
        <td> 
      <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
          <tr class="header-row">
            <td width="45%">
              <div class="table-header-text" align="left">Orignal Files </div>
            </td>
            <td WIDTH="55%">
              <div class="table-header-text" align="left">Translated File </div>
            </td>
          </tr>
          <tr height="1">
            <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
         </tr>

	 <xsl:for-each select="inputfile">
          <tr>
            <td width="24%">
              <div class="table-normal-text" align="left"><xsl:value-of select="normalize-space(@path)"/></div>
            </td>

	    <xsl:choose>
	    <xsl:when test="file-status = 'UNCHANGED'">
                <td width="100%">
	        <div class="table-normal-text">No need to translate file </div>
	      </td>
	    </xsl:when>
	    <xsl:otherwise>
	      <xsl:choose>
	      <xsl:when test="file-status= 'FULLY_MIGRATED'">
		<xsl:for-each select="stage">
		<xsl:if test="stage-status = 'FULLY_MIGRATED'">
		<xsl:for-each select="message-list/message">
                <td width="100%">
	        <div class="table-normal-text"> <xsl:value-of select="substring-after(@body,'generated file(s) are') "/> </div>
	       </td>
		</xsl:for-each>
		</xsl:if>
	       </xsl:for-each>
	     </xsl:when>
	     <xsl:otherwise>
                <td width="100%">
	        <div class="table-normal-text">No need to translate file </div>
	      </td>
	     </xsl:otherwise>
	     </xsl:choose>
	   </xsl:otherwise>
	  </xsl:choose>
          </tr>
          <tr height="1">
            <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
          </tr>
	  </xsl:for-each>

	</table>
	</td>
	</tr>
	</table>
        </br> 

     </form>
     </body>
  </xsl:template>

<xsl:template/>
</xsl:stylesheet>