<%-- 
/*
* Copyright 2005 Sun Microsystems, Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* - Redistributions of source code must retain the above copyright
*   notice, this list of conditions and the following disclaimer.
*
* - Redistribution in binary form must reproduce the above copyright
*   notice, this list of conditions and the following disclaimer in
*   the documentation and/or other materials provided with the
*   distribution.
*
* Neither the name of Sun Microsystems, Inc. or the names of
* contributors may be used to endorse or promote products derived
* from this software without specific prior written permission.
*
* This software is provided "AS IS," without a warranty of any
* kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
* WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
* EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
* SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN
* OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR
* FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
* PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
* LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE,
* EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*
* You acknowledge that Software is not designed, licensed or intended
* for use in the design, construction, operation or maintenance of
* any nuclear facility.
*/
--%>
<%@ taglib prefix="sql" uri="http://java.sun.com/jsp/jstl/sql" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %> 
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>

<%@page contentType="text/html"%>

<sql:setDataSource dataSource="jdbc/CatalogDB"/>

<sql:query var="packages"> 
 select distinct p.packageid, p.name, p.imageuri, p.description, c.name as catname from  package p, category c  where p.catid=?  and c.catid = ? and p.locale = ?
 <sql:param>${param.CATEGORY_ID}</sql:param>
 <sql:param>${param.CATEGORY_ID}</sql:param>
 <sql:param>en_US</sql:param>
</sql:query>

 <table border="0"  width="100%" height="100%" cellpadding="0" cellspacing="0">
<tr>
  <td align="center"><h1>${packages.rows[0].catname}</h1></td>
</tr>
<tr><td height="12"><image src="images/spacer.gif" height="12" alt=""></td></tr>
 <c:forEach var="package" begin="0" items="${packages.rows}">
 <tr>
   <td> &nbsp;&nbsp;
      <image src="images/${package.imageuri}" alt="${package.name} Image">
   </td>
   <td>
      <c:url value="/adventure.screen" var="viewPackageURL">
       <c:param name="PACKAGE_ID" value="${fn:trim(package.packageid)}"/>
      </c:url>
      <br>
      <a href="${viewPackageURL}">
       <h2>${package.name}</h2>
      </a>
     <br><br>${package.description}
   </td>
  </tr>
 </c:forEach>
  <tr><td height="12"><image src="images/spacer.gif" height="12" alt=""></td></tr>
</table>

