/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.xslt.model;

import org.netbeans.modules.xml.xam.dom.ComponentFactory;


/**
 * Factory for Xsl components.
 * 
 * @author ads
 *
 */
public interface XslComponentFactory extends ComponentFactory<XslComponent> {
    
    /**
     * @return instantiated "apply-templates" component. 
     */
    ApplyTemplates createApplyTemplates();
    
    /**
     * @return instantiated "attribute" component.
     */
    Attribute createAttribute();
    
    /**
     * @return instantiated "attribute-set" component.
     */
    AttributeSet createAttributeSet();
    
    /**
     * @return instantiated "call-template" component.
     */
    CallTemplate createCallTemplate();
    
    /**
     * @return instantiated "choose" component.
     */
    Choose createChoose();
    
    /**
     * @return instantiated "copy" component.
     */
    Copy createCopy();
    
    /**
     * @return instantiated "copy-of"  component.
     */
    CopyOf createCopyOf();
    
    /**
     * @return instantiated "document"  component.
     */
    Document createDocument();
    
    /**
     * @return instantiated "element" component.
     */
    Element createElement();
    
    /**
     * @return instantiated "for-each" component.
     */
    ForEach createForEach();
    
    /**
     * @return instantiated "if" component.
     */
    If createIf();
    
    /**
     * @return instantiated "import" component.
     */
    Import createImport();
    
    /**
     * @return instantiated "include" component.
     */
    Include createInclude();
    
    /**
     * @return instantiated "key" component.
     */
    Key createKey();
    
    /**
     * @return instantiated non-xslt element result compoenent.
     */
    LiteralResultElement createLiteralResultElement( String name , 
            String namespaceUri);
    
    /**
     * @return instantiated "namespace"  component.
     */
    Namespace createNamespace();
    
    /**
     * @return instantiated "number" component.
     */
    Number createNumber();
    
    /**
     * @return instantiated "otherwise" component.
     */
    Otherwise createOtherwise();
    
    /**
     * @return instantiated "output" component.
     */
    Output createOutput();
    
    /**
     * @return instantiated "param" component.
     */
    Param createParam();
    
    /**
     * @return instantiated "sequence"  component.
     */
    Sequence createSequence();
    
    /**
     * @return instantiated "sort" component.
     */
    Sort createSort();
    
    /**
     * @return instantiated "stylesheet" component.
     */
    Stylesheet createStylesheet();
    
    /**
     * @return instantiated "template" component.
     */
    Template createTemplate();
    
    /**
     * @return instantiated "text" component.
     */
    Text createText();
    
    /**
     * @return instantiated "value-of" component.
     */
    ValueOf createValueOf();
    
    /**
     * @return instantiated "variable" component.
     */
    Variable createVariable();
    
    /**
     * @return instantiated "when" component.
     */
    When createWhen();
    
}
