/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.j2ee.websphere6.util;

/**
 * The central debugging utility for the plugin. The plugin whould forward all
 * the debugging information to this tool, which will output it to System.out
 * if the debug has been enabled
 *
 * @author Kirill Sorokin
 */
public class WSDebug {

    /**
     * The name of the system property that should be present in order to
     * enable the debugging output for the plugin
     */
    private static final String PROPERTY = "j2eeplugins.websphere6.debug";

    /**
     * The prefix that should be inserted before any messages that are output
     * by this class
     */
    private static final String PREFIX = "j2eeplugins.websphere6 --- ";
    
    /**
     * Indicated whether the debug is enabled. At initialization we check for 
     * the presence of the "j2eeplugins.websphere6.debug" property and if it is 
     * present we consider the debug for the plugin enabled.
     */
    private static boolean isEnabled = System.
            getProperty(PROPERTY) != null;                             // NOI18N
    
    /**
     * Tells whether the debug for the plugin is enabled
     */
    public static boolean isEnabled() {
        return isEnabled;
    }
    
    /**
     * Outputs the given message to the System.out with the fixed prefix
     *
     * @param message the message to be output
     */
    public static void notify(String message) {
        System.out.println(PREFIX + message);   // NOI18N
    }
    
    /**
     * Outputs the given message to the System.out with the fixed prefix and the
     * class name
     * 
     * @param clazz the class from which the message originated
     * @param message the message to be output
     */
    public static void notify(Class clazz, String message) {
        System.out.println("j2eeplugins.websphere6 --- [" +            // NOI18N
                clazz.getName() + "]: " + message);                    // NOI18N
    }
    
    /**
     * Outputs the given exception to the System.out
     * 
     * @param exception the exception
     */
    public static void notify(Exception exception) {
        exception.printStackTrace(System.out);
    }
    
    /**
     * Outputs the supplied pack of objects to the System.out
     * 
     * @param objects an array of objects that need to be output
     */
    public static void notify(Object[] objects) {
        System.out.println(PREFIX + objects);
        for (int i = 0; i < objects.length; i++) {
            System.out.println(PREFIX + objects[i]);
        }
    }
    
    /**
     * Prints the current stack to the System.out
     */
    public static void printStack() {
        // get the stack trace
        StackTraceElement[] stack = new Exception().getStackTrace();
        
        // for each stack element output import to the System.out
        for (int i = 3; i < stack.length; i++) {
            System.out.println(PREFIX +         // NOI18N
                    stack[i]); 
        }
    }
    
}
