/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.j2ee.websphere6.config;

import java.io.File;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.OriginalCMPMapping;
//Dileep -- import org.netbeans.modules.j2ee.deployment.plugins.api.ConfigurationSupport;

/**
 * ConfigurationSupport implementation.
 *
 * @author dlipin
 */
public class ConfigurationSupportImpl {
//Dileep --- public class ConfigurationSupportImpl extends ConfigurationSupport {
    
    public void setMappingInfo(DeploymentConfiguration config, OriginalCMPMapping[] mappings) {
    }
    
    public void ensureResourceDefined(DeploymentConfiguration config, DDBean bean) {
    }
    
    public String getWebContextRoot(DeploymentConfiguration config, DeployableObject deplObj)
    throws ConfigurationException {
        
        if (config.getDeployableObject().getType() != ModuleType.WAR) {
            throw new ConfigurationException("This operation is supported only by the WAR modules"); // NOI18N
        }
        
        if (!(config instanceof WarDeploymentConfiguration)) {
            throw new IllegalArgumentException("Wrong DeploymentConfiguration instance " + config.getClass().getName()); // NOI18N
        }
        return ((WarDeploymentConfiguration)config).getContextPath();
        
        
    }
    
    public void setWebContextRoot(DeploymentConfiguration config, DeployableObject deplObj, String contextRoot)
    throws ConfigurationException {
        if (config.getDeployableObject().getType() != ModuleType.WAR) {
            throw new ConfigurationException("This operation is supported only by the WAR modules."); // NOI18N
        }
        
        if (!(config instanceof WarDeploymentConfiguration)) {
            throw new IllegalArgumentException("Wrong DeploymentConfiguration instance " + config.getClass().getName()); // NOI18N
        }
        ((WarDeploymentConfiguration)config).setContextPath(contextRoot);
        
    }
    
    public void initConfiguration(DeploymentConfiguration config, File[] files,
            File resourceDir, boolean keepUpdated) throws ConfigurationException {
        
        
        //if (files == null || files.length != 1) {
        //    throw new IllegalArgumentException("Invalid value of the files argument."); // NOI18N
        //}
        if (config==null) {
            return;
        }
        if (!(config instanceof WSDeploymentConfiguration)) {
            throw new IllegalArgumentException("Wrong DeploymentConfiguration instance " + config.getClass().getName()); // NOI18N
        }
        
        ModuleType type = config.getDeployableObject().getType();
        if (type == ModuleType.WAR) {
            ((WarDeploymentConfiguration)config).init(files);
        } else if (type == ModuleType.EAR) {
            ((EarDeploymentConfiguration)config).init(files);
        } else if (type == ModuleType.EJB) {
            ((EjbDeploymentConfiguration)config).init(files);
        } else {
            assert true : "Unsupported module type: " + type.toString(); // NOI18N
        }
    }
    
    public void disposeConfiguration(DeploymentConfiguration config) {
        
        if (!(config instanceof WSDeploymentConfiguration)) {
            throw new IllegalArgumentException("Wrong DeploymentConfiguration instance " + config.getClass().getName()); // NOI18N
        }
        
    }
    
    public void updateResourceDir(DeploymentConfiguration config, File resourceDir) {
        // no op
    }
}

