/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.j2ee.websphere6;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.enterprise.deploy.model.*;
import javax.enterprise.deploy.shared.*;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.*;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider.ConfigSupport;
import java.util.*;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.*;
//Dileep - Start
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeApplicationProvider;
//Dileep - End

/**
 * Wrapper for the j2eeserver's implementation of DeployableObject. This
 * class extends WSDeployableObject and all the altered logic goes in there,
 * thus here we only delegate the calls to the j2eeserver's object
 *
 * @author Dmitry Lipin
 * @author Kirill Sorokin
 * @author Stepan Herold
 *
 */
public class WSJ2eeApplicationObject extends WSDeployableObject
        implements J2eeApplicationObject {
    
    /**
     * Handle for the j2eeserver's implementation
     */
    private DeployableObject j2eeApplicationObject;
    
    /**
     * Creates a new instance of WSJ2eeApplicationObject.
     *
     * @param DeployableObject the j2eeserver's implementation
     */
    public WSJ2eeApplicationObject(
            DeployableObject deployableObject) {
        // call the WSdeployableObject's constructor
        super(deployableObject);
        j2eeApplicationObject=deployableObject;
    }
    
    private Map<String, DeployableObject> buildChildMap() {
        Map<String, DeployableObject> childMap = new HashMap<String, DeployableObject>();
        
        //Dileep J2eeAppProvider j2eeAppProvider = null;
        //Dileep - Start
        J2eeApplicationProvider j2eeAppProvider = null;
        //Dileep - End
        
        try {
            Method method = deployableObject.getClass().
                    getMethod("getProvider", new Class[0]);            // NOI18N
            //Dileep - Start
            /* 
                j2eeAppProvider = (J2eeAppProvider) method.
                    invoke(deployableObject, new Object[0]);

             */ 
                j2eeAppProvider = (J2eeApplicationProvider) method.
                    invoke(deployableObject, new Object[0]);
            //Dileep - End
            
        }  catch (IllegalAccessException e) {
            Logger.getLogger("global").log(Level.WARNING, null, e);
        } catch (NoSuchMethodException e) {
            Logger.getLogger("global").log(Level.WARNING, null, e);
        } catch (InvocationTargetException e) {
            Logger.getLogger("global").log(Level.WARNING, null, e);
        }
        
        J2eeModuleProvider[] moduleProviders = j2eeAppProvider.getChildModuleProviders();
        
        DDBeanRoot ddBeanRoot = deployableObject.getDDBeanRoot();
        
        if (ddBeanRoot != null) {
            ArrayList<String> childUris = new ArrayList<String>();
            childUris.addAll(Arrays.asList(ddBeanRoot.getText("/application/module/connector")));   // NOI18N
            childUris.addAll(Arrays.asList(ddBeanRoot.getText("/application/module/ejb")));         // NOI18N
            childUris.addAll(Arrays.asList(ddBeanRoot.getText("/application/module/java")));        // NOI18N
            childUris.addAll(Arrays.asList(ddBeanRoot.getText("/application/module/web/web-uri"))); // NOI18N
            for (String uri : childUris) {
                J2eeModuleProvider moduleProvider = j2eeAppProvider.getChildModuleProvider(uri);
                
                DeployableObject dObj=null;
                try {
                    ConfigSupport cs = moduleProvider.getConfigSupport();
                    
                    Method method = cs.getClass().
                            getMethod("getDeployableObject", new Class[] {String.class});            // NOI18N
                    
                    dObj = (DeployableObject) method.
                            invoke(cs, new Object[] {null});
                    
                }  catch (IllegalAccessException e) {
                    Logger.getLogger("global").log(Level.WARNING, null, e);
                } catch (NoSuchMethodException e) {
                    Logger.getLogger("global").log(Level.WARNING, null, e);
                } catch (InvocationTargetException e) {
                    Logger.getLogger("global").log(Level.WARNING, null, e);
                }
                childMap.put(uri, dObj);
            }
        }
        
        return childMap;
    }
    
    
    /**
     * Delegates the call to the j2eeserver's implementation, returning the
     * result if necessary.
     */
    public DeployableObject[] getDeployableObjects() {
        Map<String, DeployableObject> childMap = buildChildMap();
        
        return (DeployableObject[]) childMap.values().toArray(new DeployableObject[childMap.size()]);
    }
    
    /**
     * Delegates the call to the j2eeserver's implementation, returning the
     * result if necessary.
     */
    public DeployableObject getDeployableObject(String uri) {
        Map<String, DeployableObject> childMap = buildChildMap();
        
        return (DeployableObject) childMap.get(uri);
    }
    
    /**
     * Delegates the call to the j2eeserver's implementation, returning the
     * result if necessary.
     */
    public DeployableObject[] getDeployableObjects(ModuleType moduleType) {
        Map<String, DeployableObject> childMap = buildChildMap();
        
        ArrayList<DeployableObject> result = new ArrayList<DeployableObject>();
        for (String uri : childMap.keySet()) {
            DeployableObject deplObj = childMap.get(uri);
            if (moduleType.equals(deplObj.getType())) {
                result.add(deplObj);
            }
        }
        return (DeployableObject[]) result.toArray(new DeployableObject[result.size()]);
    }
    
    /**
     * Delegates the call to the j2eeserver's implementation, returning the
     * result if necessary.
     */
    public String[] getText(ModuleType moduleType, String xpath) {
        DeployableObject[] deployableObjects = getDeployableObjects(moduleType);
        ArrayList<String> result = new ArrayList<String>();
        for (DeployableObject deplObj : deployableObjects) {
            result.addAll(Arrays.asList(deplObj.getText(xpath)));
        }
        return (String[]) result.toArray(new String[result.size()]);
    }
    
    /**
     * Delegates the call to the j2eeserver's implementation, returning the
     * result if necessary.
     */
    public DDBean[] getChildBean(ModuleType moduleType, String xpath) {
        DeployableObject[] deployableObjects = getDeployableObjects(moduleType);
        ArrayList<DDBean> result = new ArrayList<DDBean>();
        for (DeployableObject deplObj : deployableObjects) {
            result.addAll(Arrays.asList(deplObj.getChildBean(xpath)));
        }
        return (DDBean[]) result.toArray(new DDBean[result.size()]);
    }
    
    /**
     * Delegates the call to the j2eeserver's implementation, returning the
     * result if necessary.
     */
    public String[] getModuleUris() {
        Map<String, DeployableObject> childMap = buildChildMap();
        
        return (String[]) childMap.keySet().toArray(new String[childMap.size()]);
    }
    
    public String[] getModuleUris(ModuleType type){
        Map<String, DeployableObject> childMap = buildChildMap();
        
        ArrayList<String> result = new ArrayList<String>();
        for (String uri : childMap.keySet()) {
            if (type.equals(childMap.get(uri).getType())) {
                result.add(uri);
            }
        }
        return (String[]) result.toArray(new String[result.size()]);
    }
    
    
    /**
     * Delegates the call to the j2eeserver's implementation, returning the
     * result if necessary.
     */
    public void addXpathListener(ModuleType moduleType, String xpath,
            XpathListener xpl) {
        for (DeployableObject deplObj : getDeployableObjects(moduleType)) {
            deplObj.getDDBeanRoot().addXpathListener(xpath, xpl);
        }
    }
    
    /**
     * Delegates the call to the j2eeserver's implementation, returning the
     * result if necessary.
     */
    public void removeXpathListener(ModuleType moduleType, String xpath,
            XpathListener xpl) {
        for (DeployableObject deplObj : getDeployableObjects(moduleType)) {
            deplObj.getDDBeanRoot().removeXpathListener(xpath, xpl);
        }
    }
    
}
