/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.languages.ruby;

import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.CharInput;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.modules.editor.NbEditorDocument;
import org.openide.ErrorManager;
import java.util.Iterator;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;


public class Ruby {
    
    private static String MIME_TYPE = "text/x-ruby";
        
    public static void performDeleteCurrentMethod (ASTNode node, JTextComponent comp) {
        NbEditorDocument doc = (NbEditorDocument)comp.getDocument();
        int position = comp.getCaretPosition();
        ASTPath path = node.findPath(position);
        ASTNode methodNode = null;
        for (Iterator iter = path.listIterator(); iter.hasNext(); ) {
            Object obj = iter.next();
            if (!(obj instanceof ASTNode))
                break;
            ASTNode n = (ASTNode) obj;
            if ("Method_Def".equals(n.getNT())) { // NOI18N
                methodNode = n;
            } // if
        } // for
        if (methodNode != null) {
            try {
                doc.remove(methodNode.getOffset(), methodNode.getLength());
            } catch (BadLocationException e) {
                ErrorManager.getDefault().notify(e);
            }
        }
    }
     
    public static boolean enabledDeleteCurrentMethod (ASTNode node, JTextComponent comp) {
        NbEditorDocument doc = (NbEditorDocument)comp.getDocument();
        int position = comp.getCaretPosition();
        ASTPath path = node.findPath(position);
        if (path == null) {
            return false;
        }
        for (Iterator iter = path.listIterator(); iter.hasNext(); ) {
            Object obj = iter.next();
            if (!(obj instanceof ASTNode))
                return false;
            ASTNode n = (ASTNode) obj;
            if ("Method_Def".equals(n.getNT())) { // NOI18N
                return true;
            } // if
        } // for
        return false;
    }
    
    public static Object[] analyzeDelimitedInput (CharInput input, String mimeType) {
        int startIndex = input.getIndex();
        input.read(); // "%" character
        char inputType = input.read();
        char delimiter;
        if (inputType == 'Q' || inputType == 'q' || inputType == 'r' || inputType == 'x' || 
                inputType == 'W' || inputType == 'w') {
            delimiter = input.read();
        } else {
            delimiter = inputType;
            inputType = 'Q';
        }
        char endDelimiter;
        switch (delimiter) {
            case '{':
                endDelimiter = '}';
                break;
            case '<':
                endDelimiter = '>';
                break;
            case '(':
                endDelimiter = ')';
                break;
            case '[':
                endDelimiter = ']';
                break;
            default:
                endDelimiter = delimiter;
        }
        boolean nested = delimiter != endDelimiter;
        int level = 1;
        if (input.eof()) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        while (!input.eof()) {
            char c = input.read();
            if (nested && c == delimiter) {
                level++;
            }
            if (c == endDelimiter) {
                level--;
                if (level == 0) {
                    // String str = buf.toString();
                    String str = delimiterToType(inputType);
                    // input.getString(startIndex, input.getIndex()); // [PENDING] input.getString() not implemented
                    return new Object[] {
                        ASTToken.create (
                            MIME_TYPE,
                            delimiterToType (inputType),
                            input.getString (startIndex, input.getIndex ()),
                            0
                        ),
                        new Integer (-1)// [PENDING] set proper constant for DEFAULT_STATE
                    };
                }
            }
            buf.append(c);
        }
        return new Object[] {null, new Integer (-1)}; // [PENDING] set proper constant for DEFAULT_STATE
    }
    
    private static String delimiterToType(char delimiter) {
        String type = null;
        switch (delimiter) {
            case 'Q':
            case 'W': // [PENDING] array elements
                type = "double_quoted_string";
                break;
            case 'q':
            case 'w': // [PENDING] array elements
                type = "single_quoted_string";
                break;
            case 'r':
                type = "regular_expression";
                break;
            case 'x':
                type = "shell_command";
                break;
        }
        return type;
    }
    
}
