/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.php.project.customizer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.lang.annotation.Retention;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.Utils;
import org.netbeans.modules.php.rt.WebServerRegistry;
import org.netbeans.modules.php.rt.spi.providers.Host;
import org.netbeans.modules.php.rt.spi.providers.ProjectConfigProvider;
import org.netbeans.modules.php.rt.spi.providers.ProjectCustomizerComponent;
import org.netbeans.modules.php.rt.spi.providers.WebServerProvider;
import org.openide.util.NbBundle;


/**
 * @author  ads
 */
public class CustomizerHost extends JPanel implements ProjectCustomizerComponent.CustomizerChangeListener {

    private static final long serialVersionUID = 6233510568797205953L;

    private static final String MSG_NO_HOSTS = "MSG_NoHostFound"; // NOI18N
    private static final String MSG_ABSENT_HOST = "MSG_HostIsAbsent"; // NOI18N

    public CustomizerHost(PhpProjectProperties properties) {

        myProperties = properties;

        initComponents();

        load();
    }

    private void load() {

        String hostId = getProperties().getProperty(WebServerProvider.HOST_ID);
        WebServerProvider provider = Utils.getProvider(getProperties().getProject());

        configureHostsPanel();
        loadProjectProps();
        setServerSpecificPanel();
        loadServerSpecificProps();

        applyHostSelectionVisibility();
    }

    private void applyHostSelectionVisibility() {
        if (getProperties().getProperty(PhpProjectProperties.STATUS_DISABLE_HOST_SELECTION) != null) {
            setHostSelectionDisabled();
            // do not return here to show additional messages.
            // e.g. about specified but removed host
        } else {
            myUseHost.setSelected(true);
        }

        if (getProperties().getProperty(PhpProjectProperties.STATUS_USE_NO_HOST) != null) {
            myUseHost.setSelected(false);
            setHostSelectionVisible(false);
            return;
        }

        if (getProperties().getProperty(PhpProjectProperties.STATUS_ABSENT_HOST) != null ) {
            String hostId = getProperties().getProperty(WebServerProvider.HOST_ID);
            String msg = NbBundle.getMessage(CustomizerHost.class, MSG_ABSENT_HOST, hostId);
            setErrorMessage(msg);
            return;
        }
    }

    private void configureHostsPanel() {
        Collection<Host> collection = WebServerRegistry.getInstance().getHosts();
        if (collection.size() > 0) {
            myHostName.setModel(new DefaultComboBoxModel(collection.toArray(new Host[collection.size()])));
        } else {
            getProperties().setProperty(PhpProjectProperties.STATUS_DISABLE_HOST_SELECTION, "");
        }
    }

    private void loadProjectProps() {
        String hostId = getProperties().getProperty(WebServerProvider.HOST_ID);
        WebServerProvider provider = Utils.getProvider(getProperties().getProject());
        Host host = null;
        if (hostId != null && provider != null) {
            host = provider.findHost(hostId);
            if (myHostName.getItemCount() > 0) {
                myHostName.setSelectedItem(host);
            }
            if (host == null) {
                getProperties().setProperty(PhpProjectProperties.STATUS_ABSENT_HOST, "");
            }
        } else {
            getProperties().setProperty(PhpProjectProperties.STATUS_USE_NO_HOST, "");
        }
    }

    private void setServerSpecificPanel() {
        /*
         * Set web server specific UI config.
         */
        Host host = (Host) myHostName.getSelectedItem();
        if (host != null) {
            configureProviderPanel(host.getProvider().getProjectConfigProvider());
        }
    }

    void loadServerSpecificProps() {
        if (myProviderPanel != null) {
            if (myProviderPanel instanceof ProjectCustomizerComponent) {
                // if host is not specified for project, it will be selected
                String hostId = getProperties().getProperty(WebServerProvider.HOST_ID);
                if (hostId == null) {
                    Host selectedHost = (Host) myHostName.getSelectedItem();
                    if (selectedHost != null) {
                        hostId = selectedHost.getId();
                        getProperties().setProperty(WebServerProvider.HOST_ID, hostId);
                    }
                }
                ProjectCustomizerComponent customizer = (ProjectCustomizerComponent) myProviderPanel;
                customizer.read(getProperties().getProperties());
            }
        }
    }

    void storeServerSpecificProps() {
        if (myProviderPanel != null) {
            if (myProviderPanel instanceof ProjectCustomizerComponent) {
                ProjectCustomizerComponent customizer = (ProjectCustomizerComponent) myProviderPanel;
                customizer.store(getProperties().getProperties());
            }
        }
    }

    /*
     * implementation of from ProjectCustomizerComponent.CustomizerChangeListener.propertyChanged(ProjectCustomizerComponent)
     */
    public void propertyChanged(ProjectCustomizerComponent customizer) {
        storeServerSpecificProps();
    }

    /*
     * implementation of from ProjectCustomizerComponent.CustomizerChangeListener.errorAppeared(String)
     */
    public void errorAppeared(String msg) {
        setErrorMessage(msg);
    }

    /**
     *
     * @parameter ProjectConfigProvider that will provide customizer panel.
     * If == null, empty JPanel() will be placed.
     *
     */
    private void configureProviderPanel(ProjectConfigProvider configProvider) {
        if (myProviderPanel != null) {
            myProviderPanelContainer.remove(myProviderPanel);
        }

        JPanel providerPanel = configProvider.getCustomizerPanel(getProject());
        myProviderPanelContainer.add(BorderLayout.NORTH, providerPanel);
        myProviderPanel = providerPanel;

        myProviderPanelContainer.validate();
        validate();

        if (myProviderPanel instanceof ProjectCustomizerComponent) {
            ((ProjectCustomizerComponent) myProviderPanel).addCustomizerListener(this);
        }
    }


    private void useHostSelectionChanged() {
        boolean enable = myUseHost.isSelected();
        setHostSelectionVisible(enable);
        if (enable) {
            Host hostSelection = (Host) myHostName.getSelectedItem();
            if (hostSelection != null) {
                getProperties().remove(PhpProjectProperties.STATUS_USE_NO_HOST);
            }
        } else {
            getProperties().setProperty(PhpProjectProperties.STATUS_USE_NO_HOST, "");
        }
    }

    private void hostSelectionChanged() {
        String hostId = getProperties().getProperty(WebServerProvider.HOST_ID);
        Host hostSelection = (Host) myHostName.getSelectedItem();
        if (hostSelection != null) {
            if (!hostSelection.getId().equals(hostId)) {
                getProperties().setProperty(WebServerProvider.HOST_ID, hostSelection.getId());
                setServerSpecificPanel();
                loadServerSpecificProps();
            }
            setMessage("");
        }
    }


    private void setHostSelectionVisible(boolean aFlag) {
        myHostName.setVisible(aFlag);
        myHostNameLabel.setVisible(aFlag);
        if (myProviderPanel != null) {
            myProviderPanel.setVisible(aFlag);
        }
    }

    private void setHostSelectionDisabled() {
        myUseHost.setSelected(false);
        myUseHost.setEnabled(false);
        setHostSelectionVisible(false);
        String msg = NbBundle.getMessage(CustomizerHost.class, MSG_NO_HOSTS);
        setMessage(msg);
    }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        myHostsPanel = new javax.swing.JPanel();
        myHostNameLabel = new javax.swing.JLabel();
        myHostName = new javax.swing.JComboBox();
        myUseHost = new javax.swing.JCheckBox();
        myProviderPanelContainer = new javax.swing.JPanel();
        myProviderPanel = new javax.swing.JPanel();
        myMessageContainer = new javax.swing.JPanel();
        myMessagePanel = new javax.swing.JTextPane();
        spacerPanel = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        myHostNameLabel.setLabelFor(myHostName);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("org/netbeans/modules/php/project/customizer/Bundle"); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(myHostNameLabel, bundle.getString("LBL_CstmzHostName")); // NOI18N

        myHostName.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                myHostNameActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(myUseHost, org.openide.util.NbBundle.getMessage(CustomizerHost.class, "LBL_UseHost")); // NOI18N
        myUseHost.setActionCommand(org.openide.util.NbBundle.getMessage(CustomizerHost.class, "CustomizerHost.myUseHost.actionCommand")); // NOI18N
        myUseHost.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        myUseHost.setMargin(new java.awt.Insets(0, 0, 0, 0));
        myUseHost.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                myUseHostActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout myHostsPanelLayout = new org.jdesktop.layout.GroupLayout(myHostsPanel);
        myHostsPanel.setLayout(myHostsPanelLayout);
        myHostsPanelLayout.setHorizontalGroup(
            myHostsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, myHostsPanelLayout.createSequentialGroup()
                .add(2, 2, 2)
                .add(myHostNameLabel)
                .add(18, 18, 18)
                .add(myHostName, 0, 381, Short.MAX_VALUE)
                .addContainerGap())
            .add(myHostsPanelLayout.createSequentialGroup()
                .add(myUseHost, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 447, Short.MAX_VALUE)
                .add(20, 20, 20))
        );
        myHostsPanelLayout.setVerticalGroup(
            myHostsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(myHostsPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(myUseHost)
                .add(11, 11, 11)
                .add(myHostsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(myHostName, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(myHostNameLabel))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        myHostNameLabel.getAccessibleContext().setAccessibleName(bundle.getString("A11_CstmzHostName")); // NOI18N
        myHostName.getAccessibleContext().setAccessibleDescription(bundle.getString("A11_CstmzHosts")); // NOI18N
        myUseHost.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(CustomizerHost.class, "A11_UseHostLbl")); // NOI18N

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        add(myHostsPanel, gridBagConstraints);

        myProviderPanelContainer.setLayout(new java.awt.BorderLayout());

        org.jdesktop.layout.GroupLayout myProviderPanelLayout = new org.jdesktop.layout.GroupLayout(myProviderPanel);
        myProviderPanel.setLayout(myProviderPanelLayout);
        myProviderPanelLayout.setHorizontalGroup(
            myProviderPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 0, Short.MAX_VALUE)
        );
        myProviderPanelLayout.setVerticalGroup(
            myProviderPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 0, Short.MAX_VALUE)
        );

        myProviderPanelContainer.add(myProviderPanel, java.awt.BorderLayout.CENTER);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        add(myProviderPanelContainer, gridBagConstraints);

        myMessagePanel.setEditable(false);
        myMessagePanel.setText(org.openide.util.NbBundle.getMessage(CustomizerHost.class, "CustomizerHost.myMessagePanel.text")); // NOI18N
        myMessagePanel.setFocusable(false);
        myMessagePanel.setMinimumSize(new java.awt.Dimension(6, 10));
        myMessagePanel.setOpaque(false);
        myMessagePanel.setPreferredSize(new java.awt.Dimension(0, 0));

        org.jdesktop.layout.GroupLayout myMessageContainerLayout = new org.jdesktop.layout.GroupLayout(myMessageContainer);
        myMessageContainer.setLayout(myMessageContainerLayout);
        myMessageContainerLayout.setHorizontalGroup(
            myMessageContainerLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(myMessagePanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 467, Short.MAX_VALUE)
        );
        myMessageContainerLayout.setVerticalGroup(
            myMessageContainerLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(myMessageContainerLayout.createSequentialGroup()
                .add(myMessagePanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 22, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        add(myMessageContainer, gridBagConstraints);

        org.jdesktop.layout.GroupLayout spacerPanelLayout = new org.jdesktop.layout.GroupLayout(spacerPanel);
        spacerPanel.setLayout(spacerPanelLayout);
        spacerPanelLayout.setHorizontalGroup(
            spacerPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 467, Short.MAX_VALUE)
        );
        spacerPanelLayout.setVerticalGroup(
            spacerPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 202, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(spacerPanel, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void myHostNameActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_myHostNameActionPerformed
        hostSelectionChanged();
    }//GEN-LAST:event_myHostNameActionPerformed

    private void myUseHostActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_myUseHostActionPerformed
        useHostSelectionChanged();
    }//GEN-LAST:event_myUseHostActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox myHostName;
    private javax.swing.JLabel myHostNameLabel;
    private javax.swing.JPanel myHostsPanel;
    private javax.swing.JPanel myMessageContainer;
    private javax.swing.JTextPane myMessagePanel;
    private javax.swing.JPanel myProviderPanel;
    private javax.swing.JPanel myProviderPanelContainer;
    private javax.swing.JCheckBox myUseHost;
    private javax.swing.JPanel spacerPanel;
    // End of variables declaration//GEN-END:variables

    public void setMessage(String msg) {
        myMessagePanel.setText(msg);
        myMessagePanel.setForeground(Color.BLACK);
    }

    public void setErrorMessage(String msg) {
        myMessagePanel.setText(msg);
        myMessagePanel.setForeground(Color.RED);
    }

    private PhpProjectProperties getProperties() {
        return myProperties;
    }

    private PhpProject getProject() {
        return getProperties().getProject();
    }

    private PhpProjectProperties myProperties;
}
