/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */ 

/*
 * TestMIDlet.java
 *
 * Created on January 16, 2007, 11:30 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.netbeans.microedition.testme;

import javax.microedition.lcdui.Display;
import javax.microedition.midlet.MIDlet;

/**
 *
 * @author breh
 */
public abstract class TestMIDlet extends MIDlet {
    private final Logger  _logger;
    private final int     _testNum;
    private final boolean _isAsynchronous;
    private final String  _testName;
    
    private Display      _display;   
    private StatusScreen _statusScreen;
    private TestResults  _testResults;
    private volatile int _testIndex = 0;
    
    /**
     * Creates a new instance of TestMIDlet
     */
    public TestMIDlet(String testName, int testNum, boolean isAsynchronous) {
        _logger         = new Logger(this);
        _isAsynchronous = isAsynchronous;
        _testName       = testName;
        _testNum        = testNum;
    }

    public TestMIDlet(String testName, int testNum) {
        this(testName, testNum, false);
    }
    
    // API
    
     // tests need to implement this
    protected abstract void runTest(int testNumber) throws Throwable;
    
    protected void setUp() {
    }

    protected void tearDown() {        
    }
    
    public synchronized final void log(int priority, String message, Throwable t) {
        getLogger().log(priority,message,t);
    }
        
    public void log(String message, Throwable t) {
        log(Logger.INFO,message,t);
    }
    
    public void log(String message) {
        log(Logger.INFO, message, null);
    }
    
    
    protected final void assertTrue(boolean bool, String message) {
        if (! bool) {
            throw new AssertionException("assertTrue failed: "+message);
        }        
    }        
    
    protected final void fail(String message) {        
        throw new AssertionException(message);
    }

    protected final Display getDisplay() {
        if (_display == null) {
            _display = Display.getDisplay(this);
        }
        return _display;
    }       
    
    // API ends
    
    private boolean internalSetUp() {
        try {
            setUp();
            return true;
        } catch (Throwable t) {
            System.out.println("Problem during setup");
            t.printStackTrace();
        }
        return false;
    }
    
    
    private void internalTearDown() {
        try {
            tearDown();
        } catch (Throwable t) {
            System.out.println("Problem during teardown");
            t.printStackTrace();
        }
        getDisplay().callSerially(new Runnable() {
            public void run() {
                getDisplay().setCurrent(getStatusScreen());;
            }
        }); 
    }
    

    final String getTestName() {
        return _testName;
    }
    
    
    private synchronized StatusScreen getStatusScreen() {
        if (_statusScreen == null) {
            _statusScreen = new StatusScreen(this);
        }
        return _statusScreen;
    }
        
    final protected Logger getLogger() {
        return _logger;
    }
     
    final void runTests() {  
        getLogger().clearMemoryLog();
        getStatusScreen().setStatus("Starting tests.");
        
        if (_isAsynchronous) {
            _testIndex = 1;
            startAsynchronousTest();
        } else {
            for (int i=1; i <= _testNum; i++) {
                try {
                    getStatusScreen().setStatus("Running test "+i);
                    internalSetUp();
                    runTest(i);
                    _testResults.addPass();
                    getStatusScreen().setStatus("Test "+i+" passed");
                } catch (Throwable t) {
                    _testResults.addFailure(t.getMessage());
                    getStatusScreen().setStatus("!!! Test "+i+" failed: "+t.getMessage());
                    if ( ! (t instanceof AssertionException)) {
                        t.printStackTrace();
                    }
                } finally {
                    internalTearDown();
                }
            }
            getStatusScreen().setStatus("Tests finished.");
            getDisplay().callSerially(new Runnable() {
                public void run() {
                    getDisplay().setCurrent(getStatusScreen());
                }
            });
        }
    }
        
    private void startAsynchronousTest() {
        getDisplay().callSerially( new Runnable() {
            public void run() {
                getStatusScreen().setStatus("Running test " + _testIndex);
                
                if (internalSetUp()) {
                    try {
                        runTest(_testIndex);
                    } catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                } else {
                    _testResults.addFailure( "Setup for test " + _testIndex + " failed!");
                    getStatusScreen().setStatus("Tests finished.");
                    getDisplay().setCurrent(getStatusScreen());
                }
            }
        });
    }

    protected void asynchronousTestCompleted(final boolean passed, final String errMsg) {
        getDisplay().callSerially( new Runnable() {
            public void run() {
                if (passed) {
                    _testResults.addPass();
                    getStatusScreen().setStatus("Test " + _testIndex + " passed");                
                } else {
                    _testResults.addFailure(errMsg);
                    getStatusScreen().setStatus("!!! Test " + _testIndex +" failed: " + errMsg);
                }
                internalTearDown();
                if ( ++_testIndex <= _testNum) {
                    startAsynchronousTest();
                } else {
                    getStatusScreen().setStatus("Tests finished.");
                    getDisplay().setCurrent(getStatusScreen());
                }
            }            
        });
    }
    
    final void exit() {
        getDisplay().setCurrent(null);
        destroyApp(true);
        notifyDestroyed();
    }
    
    
    // MIDlet implementation    
    protected void startApp() {
        this._testResults = new TestResults(getStatusScreen());
        getDisplay().setCurrent(getStatusScreen());
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean b) {
    }
    
    

    
    
}
