/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */ 


/*
 * StatusScreen.java
 *
 * Created on January 16, 2007, 11:25 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.netbeans.microedition.testme;

import java.util.Date;
import java.util.Enumeration;
import javax.microedition.lcdui.Choice;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Spacer;
import javax.microedition.lcdui.StringItem;

/**
 * Status scren for use by the testing framework
 * @author breh
 */
class StatusScreen extends Form implements CommandListener {
        
    
   
    
    private TestMIDlet testMIDlet;
    
    private static final int LAYOUT = Item.LAYOUT_NEWLINE_AFTER;
    
    private List logList = new List("Log: ",Choice.IMPLICIT);
    private Form logEntryDetail = new Form("Log Entry detail");
    
    private StringItem totalSI = new StringItem("Tests run:","0");
    private StringItem passSI = new StringItem("Passed:","0");
    private StringItem failureSI = new StringItem("Failed: ","0");
    private StringItem statusSI = new StringItem("Status: ","idle");
    
    private StringItem prioritySI = new StringItem("Priority: ","");
    private StringItem timestampSI = new StringItem("Timestamp: ","");
    private StringItem messageSI = new StringItem("Message: ","");
    private StringItem throwableSI = new StringItem("Throwable: ","");
    
    
    private Command runTestsCommand = new Command("Run Tests",Command.OK,0);
    private Command viewLogCommand = new Command("View Log",Command.SCREEN, 0);
    private Command exitCommand = new Command("Exit",Command.EXIT,0);
    private Command backCommand = new Command("Back",Command.BACK,0);
    //private Command detailsCommand = new Command("Details", Command.ITEM, 0);
    
    /** Creates a new instance of StatusScreen */
    public StatusScreen(TestMIDlet testMIDlet) {
        super("Tests status screen");
        this.testMIDlet = testMIDlet;        
        this.setTitle("Testing: "+testMIDlet.getTestName());
        totalSI.setLayout(LAYOUT);
        passSI.setLayout(LAYOUT);
        failureSI.setLayout(LAYOUT);
        statusSI.setLayout(LAYOUT);
        this.append(totalSI);
        this.append(passSI);
        this.append(failureSI);        
        this.append(new Spacer(this.getWidth(),2));
        this.append(statusSI);
        
        this.addCommand(runTestsCommand);
        this.addCommand(exitCommand);
        this.addCommand(viewLogCommand);
        
        testMIDlet.getLogger().addCommands(this);
        
        this.setCommandListener(this);
        
        logList.addCommand(backCommand);
        logList.setFitPolicy(List.TEXT_WRAP_ON);
        logList.setCommandListener(this);
        //logList.setSelectCommand(detailsCommand);
        
        prioritySI.setLayout(LAYOUT);
        timestampSI.setLayout(LAYOUT);
        messageSI.setLayout(LAYOUT);
        throwableSI.setLayout(LAYOUT);
        logEntryDetail.append(prioritySI);
        logEntryDetail.append(timestampSI);
        logEntryDetail.append(messageSI);
        logEntryDetail.append(throwableSI);
        logEntryDetail.addCommand(backCommand);
        logEntryDetail.setCommandListener(this);
    }

    
    
    public void setStatus(String statusMessage) {
        testMIDlet.log(statusMessage);
        this.statusSI.setText(statusMessage);
    }
    
    void refresh(TestResults results) {
        if (results == null) throw new IllegalArgumentException("results cannot be null");
        totalSI.setText(""+results.getTotal());
        passSI.setText(""+results.getPass());
        failureSI.setText(""+results.getFailure());
    }
    
        
    
    private void viewLog() {
        logList.deleteAll();
        //Form detailsForm = new Form("Log entry details:");
        Enumeration e = testMIDlet.getLogger().getLogEntries();
        while (e.hasMoreElements()) {
            Logger.LogEntry entry = (Logger.LogEntry)e.nextElement();            
            logList.append(entry.getMessage(), null);
        }
        testMIDlet.getDisplay().setCurrent(logList);
    }
        
    private void viewLogEntryDetail(int index) {
        Logger.LogEntry entry = testMIDlet.getLogger().getLogEntry(index);
        if (entry != null) {
            prioritySI.setText(entry.getPriorityAsString());
            timestampSI.setText(new Date(entry.getTimestamp()).toString());
            messageSI.setText(entry.getMessage());
            throwableSI.setText( ((entry.getThrowable() == null) ? null : entry.getThrowable().getMessage()) );
        } else {
            prioritySI.setText(null);
            timestampSI.setText(null);
            messageSI.setText(null);
            throwableSI.setText(null);
        }
        testMIDlet.getDisplay().setCurrent(logEntryDetail);
    }
    
    public void commandAction(Command command, Displayable displayable) {
        // let logger handle its own commands ...
        if ( !testMIDlet.getLogger().handleCommand(command)) {
            // ... or proceed otherwise
            if (displayable == this) {
                if (command == runTestsCommand) {
                    testMIDlet.runTests();
                } else if (command == exitCommand) {
                    testMIDlet.exit();
                } else if (command == viewLogCommand) {
                    viewLog();
                }
            } else if (displayable == logList) {
                if (command == backCommand) {
                    testMIDlet.getDisplay().setCurrent(this);
                    logList.deleteAll();
                } else if (command == logList.SELECT_COMMAND) {
                    // view details
                    viewLogEntryDetail(logList.getSelectedIndex());
                }
            } else if (displayable == logEntryDetail) {
                if (command == backCommand) {
                    testMIDlet.getDisplay().setCurrent(logList);
                }
            }
        }
    }
    
}
