/*
 * StacktraceAction.java
 *
 * Created on 20 April 2007, 13:22
 */

package org.netbeans.modules.exceptions.web.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionForward;
import org.netbeans.modules.exceptions.entity.Exceptions;
import org.netbeans.modules.exceptions.entity.Line;
import org.netbeans.modules.exceptions.entity.Stacktrace;
import org.netbeans.modules.exceptions.utils.PersistenceUtils;
/**
 *
 * @author honza
 * @version
 */

public class StacktraceAction extends Action {
    
    /* forward name="success" path="" */
    private final static String ERROR = "success";
    private final static String STACKTRACE_QUERY = "stacktrace";
    
    /**
     * This is the action called from the Struts framework.
     * @param mapping The ActionMapping used to select this instance.
     * @param form The optional ActionForm bean for this request.
     * @param request The HTTP Request we are processing.
     * @param response The HTTP Response we are processing.
     * @throws java.lang.Exception
     * @return
     */
    public ActionForward execute(ActionMapping mapping, ActionForm  form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        Integer id = null;
        try {
            id = new Integer(request.getParameter("id"));
        } catch (NumberFormatException e) {
        }
        if (id == null) {
            return mapping.findForward(ERROR);
        }
        Exceptions exceptions = (Exceptions) PersistenceUtils.getInstance().getEntity(Exceptions.class, id);
        request.setAttribute("exceptions", exceptions);
        ArrayList lineNum = new ArrayList();
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String name = (String) en.nextElement();
            if (name.matches("[0-9]*")) {
                try {
                    Integer i = Integer.parseInt(name);
                    lineNum.add(i);
                } catch(NumberFormatException e) {
                }
            }
        }
        request.setAttribute("lines", lineNum);
        
        HashSet methodIds = new HashSet();
        
        for (Iterator<Line> it = exceptions.getStacktrace().getLineCollection().iterator(); it.hasNext();) {
            Line l = it.next();
            if (lineNum.contains(l.getLinePK().getLineOrder())) {
                methodIds.add(l.getMethod().getId());
            }
        }
        
        StringBuffer sb = new StringBuffer();
        for (Iterator it = methodIds.iterator(); it.hasNext();) {
            Object object = it.next();
            sb.append(object);
            if (it.hasNext()) sb.append(", ");
        }

        List list; 
        if (methodIds.size() > 0) {
            list= (List) PersistenceUtils.getInstance()
                .executeNativeQuery("select stacktrace_id from (select distinct stacktrace_id, method_id from line " +
                "where method_id in (" + sb + ")) tmp group by stacktrace_id having count(method_id) = "  +
                methodIds.size());
        } else {
            list = Collections.emptyList();
        }
        
        //            list = (List) PersistenceUtils.lookupInstance()
        //                    .executeQuery("select s from Stacktrace s, Line l where s.id = l.linePK.stacktraceId " +
        //                    "group by l.linePK.stacktraceId " +
        ////                    "having (select count(distinct l.linePK.stacktraceId) from Line ll where ll.linePK.methodId in ("+ sb + ")) = " + methodIds.size(), null);
        //            list = (List) PersistenceUtils.lookupInstance()
        //                    .executeQuery("select s.id, count(s) from Stacktrace s, Line l where s.id = l.linePK.stacktraceId " +
        //                    "group by l.linePK.stacktraceId " +
        //                    "having (select count(distinct l.linePK.stacktraceId) from Line ll where ll.linePK.methodId in ("+ sb + ")) = " + methodIds.size(), null);
        
        // get stacktraces by id -- temporary solution
        HashSet al = new HashSet();
        for (Iterator it = list.iterator(); it.hasNext();) {
            Vector object = (Vector) it.next();
            Stacktrace st = (Stacktrace) PersistenceUtils.getInstance().getEntity(Stacktrace.class, object.firstElement());
            if ((st == null) || (st.getExceptions() == null)) {
                continue;
            }
            if (st.getExceptions().getDuplicateof() != null) {
                al.add(st.getExceptions().getDuplicateof());
            } else {
                al.add(st.getExceptions());
            }
        }
        
        
        request.setAttribute("list", al);
        
        return mapping.findForward(STACKTRACE_QUERY);
        
    }
}
