/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.j2ee.refactoring;

import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.modules.j2ee.refactoring.rename.EjbJarRenameRefactoring;
import org.netbeans.modules.j2ee.refactoring.rename.EntityRenameRefactoring;
import org.netbeans.modules.j2ee.refactoring.rename.JaxWsXmlRenameRefactoring;
import org.netbeans.modules.j2ee.refactoring.rename.PersistenceXmlRenameRefactoring;
import org.netbeans.modules.j2ee.refactoring.rename.SunJaxWsXmlRenameRefactoring;
import org.netbeans.modules.j2ee.refactoring.rename.TldRenameRefactoring;
import org.netbeans.modules.j2ee.refactoring.rename.WebXmlRenameRefactoring;
import org.netbeans.modules.j2ee.refactoring.rename.WebservicesXmlRenameRefactoring;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;


/**
 *
 * @author Martin Grebac
 */
public class J2EERenameRefactoringPlugin implements RefactoringPlugin {
    
    /** This one is important creature - makes sure that cycles between plugins won't appear */
    private static ThreadLocal semafor = new ThreadLocal();
    
    private EjbJarRenameRefactoring ejbJarRenameRefactor;
    private WebXmlRenameRefactoring webXmlRenameRefactor;
    private TldRenameRefactoring tldRenameRefactor;
    private WebservicesXmlRenameRefactoring webservicesXmlRenameRefactor;
    private PersistenceXmlRenameRefactoring persistenceXmlRenameRefactoring = new PersistenceXmlRenameRefactoring();
    private EntityRenameRefactoring entityRenameRefactoring = new EntityRenameRefactoring();
    private JaxWsXmlRenameRefactoring jaxWsXmlRenameRefactoring = new JaxWsXmlRenameRefactoring();
    private SunJaxWsXmlRenameRefactoring sunJaxWsXmlRenameRefactoring = new SunJaxWsXmlRenameRefactoring();
    
    
    private final RenameRefactoring renameRefactoring;
    
    private static ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.renameRefactoring.rename");   // NOI18N
    
    /** Creates a new instance of J2EERenameRefactoringPlugin */
    public J2EERenameRefactoringPlugin(AbstractRefactoring refactoring) {
        this.renameRefactoring = (RenameRefactoring) refactoring;
    }
    
    /** Checks pre-conditions of the renameRefactoring and returns problems.
     * @return Problems found or null (if no problems were identified)
     */
    public Problem preCheck() {
        Problem problem = null;
        if (semafor.get() == null) {
            semafor.set(new Object());
            
            RefObject refO = (RefObject) renameRefactoring.getRefactoredObject();
            err.log("refO: " + refO);
            
            
            Problem webSvcProblem = getWebservicesXmlRenameRefactor().preCheck(refO);
            problem = Utility.addProblemsToEnd(problem, webSvcProblem);

            if (!Utility.isEjb30(refO)){
                Problem ejbJarProblem = getEjbJarRenameRefactor().preCheck(refO);
                problem = Utility.addProblemsToEnd(problem, ejbJarProblem);
            } else if (Utility.hasEjbJar(Utility.getRelevantEjbModules(refO))){
                Problem ejbJarProblem = new Problem(false, NbBundle.getMessage(J2EERenameRefactoringPlugin.class, "TXT_EjbJarRenameWarning"));  //NOI18N
                problem = Utility.addProblemsToEnd(problem, ejbJarProblem);
            }
            
            semafor.set(null);
        }
        return problem;
    }
    
    
    public Problem fastCheckParameters() {
        Problem problem = null;
        if (semafor.get() == null) {
            semafor.set(new Object());
            
            RefObject refO = (RefObject) renameRefactoring.getRefactoredObject();
            err.log("refO: " + refO);
            
            String newName = renameRefactoring.getNewName();
            err.log("newname: " + newName);
            
            if (!Utility.isEjb30(refO)){
                Problem ejbJarProblem = getEjbJarRenameRefactor().fastCheckParameters(refO, newName);
                problem = Utility.addProblemsToEnd(problem, ejbJarProblem);
            }
            
            Problem wsvcProblem = getWebservicesXmlRenameRefactor().fastCheckParameters(refO, newName);
            problem = Utility.addProblemsToEnd(problem, wsvcProblem);
            
            semafor.set(null);
        }
        return problem;
    }
    
    /** Checks parameters of the renameRefactoring.
     * @return Problems found or null (if no problems were identified)
     */
    public Problem checkParameters() {
        Problem problem = null;
        if (semafor.get() == null) {
            semafor.set(new Object());
            
            RefObject refO = (RefObject) renameRefactoring.getRefactoredObject();
            err.log("refO: " + refO);
            
            String newName = renameRefactoring.getNewName();
            err.log("newname: " + newName);
            
            if (!Utility.isEjb30(refO)){
                Problem ejbJarProblem = getEjbJarRenameRefactor().checkParameters(refO,  newName);
                problem = Utility.addProblemsToEnd(problem, ejbJarProblem);
            }
            
            Problem wsvcProblem = getWebservicesXmlRenameRefactor().checkParameters(refO,  newName);
            problem = Utility.addProblemsToEnd(problem, wsvcProblem);
            
            semafor.set(null);
        }
        return problem;
    }
    
    /** Collects renameRefactoring elements for a given renameRefactoring.
     * @param refactoringElements Collection of renameRefactoring elements - the implementation of this method
     * should add renameRefactoring elements to this collections. It should make no assumptions about the collection
     * content.
     * @return Problems found or null (if no problems were identified)
     */
    public Problem prepare(RefactoringElementsBag refactoringElements) {
        Problem problem = null;
        
        if (semafor.get() == null) {
            semafor.set(new Object());
            
            RefObject refO = (RefObject) renameRefactoring.getRefactoredObject();
            err.log("refO: " + refO);
            
            String newName = renameRefactoring.getNewName();
            err.log("newname: " + newName);
            
            Problem webXmlProblem = getWebXmlRenameRefactor().prepare(renameRefactoring, refO, newName, refactoringElements);
            problem = Utility.addProblemsToEnd(problem, webXmlProblem);
            
            Problem tldProblem = getTldRenameRefactor().prepare(renameRefactoring, refO, newName, refactoringElements);
            problem = Utility.addProblemsToEnd(problem, tldProblem);
            
            if (!Utility.isEjb30(refO)){
                Problem ejbJarProblem = getEjbJarRenameRefactor().prepare(renameRefactoring, refO, newName, refactoringElements);
                problem = Utility.addProblemsToEnd(problem, ejbJarProblem);
            }
            
            Problem webservicesProblem = getWebservicesXmlRenameRefactor().prepare(renameRefactoring, refO, newName, refactoringElements);
            problem = Utility.addProblemsToEnd(problem, webservicesProblem);
            
            Problem persistenceXmlProblem = persistenceXmlRenameRefactoring.prepare(renameRefactoring, refO, newName, refactoringElements);
            problem = Utility.addProblemsToEnd(problem, persistenceXmlProblem );
            
            Problem entityRenameProblem = entityRenameRefactoring.prepare(renameRefactoring, refO, newName, refactoringElements);
            problem = Utility.addProblemsToEnd(problem, entityRenameProblem);
            
            Problem jaxXmlProblem = jaxWsXmlRenameRefactoring.prepare(renameRefactoring, refO, newName, refactoringElements);
            problem = Utility.addProblemsToEnd(problem, jaxXmlProblem);
            
            Problem sunJaxXmlProblem = sunJaxWsXmlRenameRefactoring.prepare(renameRefactoring, refO, newName, refactoringElements);
            problem = Utility.addProblemsToEnd(problem, sunJaxXmlProblem);
            
            semafor.set(null);
        }
        
        err.log("Gonna return problem: " + problem);
        return problem;
    }
    
    public void cancelRequest() { }
    
    private EjbJarRenameRefactoring getEjbJarRenameRefactor() {
        if (ejbJarRenameRefactor == null) {
            ejbJarRenameRefactor = new EjbJarRenameRefactoring();
        }
        return ejbJarRenameRefactor;
    }
    
    private WebXmlRenameRefactoring getWebXmlRenameRefactor() {
        if (webXmlRenameRefactor == null) {
            webXmlRenameRefactor = new WebXmlRenameRefactoring();
        }
        return webXmlRenameRefactor;
    }
    
    private TldRenameRefactoring getTldRenameRefactor() {
        if (tldRenameRefactor == null) {
            tldRenameRefactor = new TldRenameRefactoring();
        }
        return tldRenameRefactor;
    }
    
    private WebservicesXmlRenameRefactoring getWebservicesXmlRenameRefactor() {
        if (webservicesXmlRenameRefactor == null) {
            webservicesXmlRenameRefactor = new WebservicesXmlRenameRefactoring();
        }
        return webservicesXmlRenameRefactor;
    }
    
}
