/* *************************************************************************
 *
 *          Copyright (c) 2005, SeeBeyond Technology Corporation,
 *          All Rights Reserved
 *
 *          This program, and all the routines referenced herein,
 *          are the proprietary properties and trade secrets of
 *          SEEBEYOND TECHNOLOGY CORPORATION.
 *
 *          Except as provided for by license agreement, this
 *          program shall not be duplicated, used, or disclosed
 *          without  written consent signed by an officer of
 *          SEEBEYOND TECHNOLOGY CORPORATION.
 *
 ***************************************************************************/
package org.netbeans.modules.workflow.project.anttasks;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;

import org.netbeans.modules.workflow.project.anttasks.wsdl.WSDLOperation;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;


/**
 * @author sgenipudi
 */
public class XformGenerator {

    private WSDLModel mClientWSDLModel = null;
    private File mProjectDir = null;
    private String mProjectName = null;
    private File mBuildDir = null;
    private static boolean mbCommandline = false;
    private boolean mAlways= false;

    public XformGenerator() {
    }

    public static void setCommandlineMode(boolean value) {
        mbCommandline = value;
    }

    public static boolean isCommandlineMode() {
        return mbCommandline;
    }

    public void generate(File projectDir, File buildDir, boolean always) {
        //Get the static WSDL File 
        //Build will copy the static wsdl to build directory 
        //assume the template is already there in the build directory.
        this.mProjectDir = projectDir;
        this.mBuildDir = buildDir;
        this.mAlways = always;
       
        //Scan the project dir and process each workflow files
        //  Load Static Task Client WSDL Template
        //  Set defenition Name/ TargetName space in the defenitions

        // From Workflow file, 
        //  get the Operation
        // From Operation get the WSDL Model
        // From Operation 
        //   get the Input and 
        //           Output messages
        //  For each Input and Output message
        //      Get the part information
        //      Get the schema type for each part
        //      If the schema is File  then get the File information
        //      If this is inline schema then serialize the schema to File 
        //          and store the File Information
        //     Generate XForm based on schema

        //Implementation start:
        // Iterate the source directory and find out each Task Workflow files
        processSourceDir();

    }

    /**
     * Proces the source directory to generate JBI.xml
     * @param sourceDir
     */
    private void processSourceDir() {
        processFileObject(this.mProjectDir);
    }

    /**
     * Process the file object to generate JBI.xml
     * @param file BPEL file location
     */
    private void processFileObject(File file) {
        if (file.isDirectory()) {
            processFolder(file);
        } else {
            processFile(file);
        }
    }

    /**
     * Process the folder to generate JBI.xml
     * @param fileDir  Folder location
     */
    private void processFolder(File fileDir) {
        File[] children = fileDir.listFiles();

        for (int i = 0; i < children.length; i++) {
            processFileObject(children[i]);
        }
    }

    /**
     * Process the file to generate JBI.xml
     * @param file input file
     * @throws Exception 
     */
    protected void processFile(File file) {
        String fileName = file.getName();
        String fileExtension = null;
        int dotIndex = fileName.lastIndexOf('.');
        if (dotIndex != -1) {
            fileExtension = fileName.substring(dotIndex + 1);
        }

        if (fileExtension != null && fileExtension.equalsIgnoreCase("wf")) {
            ArrayList<WSDLOperation> listOfOperations = 
                new ArrayList<WSDLOperation>();
            try {
                Util.generateXForm(file, mBuildDir, mProjectDir, mAlways);
            } catch (RuntimeException e) {
                // TODO Auto-generated catch block
                throw e;
            } catch (Exception e) {
                throw new RuntimeException (e);
            }
        }

    }

 
}
