/* *************************************************************************
 *
 *          Copyright (c) 2005, SeeBeyond Technology Corporation,
 *          All Rights Reserved
 *
 *          This program, and all the routines referenced herein,
 *          are the proprietary properties and trade secrets of
 *          SEEBEYOND TECHNOLOGY CORPORATION.
 *
 *          Except as provided for by license agreement, this
 *          program shall not be duplicated, used, or disclosed
 *          without  written consent signed by an officer of
 *          SEEBEYOND TECHNOLOGY CORPORATION.
 *
 ***************************************************************************/
package org.netbeans.modules.workflow.project.anttasks;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

import javax.xml.namespace.QName;

import org.netbeans.modules.workflow.project.anttasks.wsdl.WSDLMessage;
import org.netbeans.modules.workflow.project.anttasks.wsdl.WSDLOperation;
import org.netbeans.modules.workflow.project.anttasks.wsdl.WSDLPart;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.LocalType;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.RequestResponseOperation;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.BPELComponentFactory;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PartnerLinkType;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Role;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPAddress;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPBinding;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPBody;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPFault;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPMessageBase;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPOperation;
import org.netbeans.modules.xml.xam.Referenceable;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;

/**
 * @author sgenipudi
 */
public class WSDLGenerator {

    private ArrayList mListOfOperations = new ArrayList();
    private WSDLModel mClientWSDLModel = null;
    private File mProjectDir = null;
    private String mProjectName = null;
    private static final String CLIENTWSDL_NS_TEMPLATE_PREFIX = 
        "http://jbi.com.sun/wfse/wsdl/";
    private static final String CLIENTWSDL_NS_TEMPLATE_SUFFIX = "_wf_client";
    private static final String WSDL_EXT = ".wsdl";
    private static final String CLIENTWSDL_DEF_NAME_TEMPLATE_SUFFIX = 
        "WFClient";
    private File mBuildDir = null;
    private static boolean mbCommandline = false;
    private org.netbeans.modules.xml.schema.model.Schema mClientWSDLSchema = 
        null;
    private long mClientWSDLLastSavedTime = 0l;
    private File mClientFile = null;
    private HashMap<String, org.netbeans.modules.xml.wsdl.model.Message> mMapOfOpnToMessage = 
        new HashMap<String, org.netbeans.modules.xml.wsdl.model.Message>();

    public WSDLGenerator() {
    }

    public static void setCommandlineMode(boolean value) {
        mbCommandline = value;
    }

    public static boolean isCommandlineMode() {
        return mbCommandline;
    }

    public void generate(String projectName, File projectDir, File buildDir, 
                         File clientWSDL) {
        //Get the static WSDL File 
        //Build will copy the static wsdl to build directory 
        //assume the template is already there in the build directory.
        this.mProjectDir = projectDir;
        this.mBuildDir = buildDir;
        this.mProjectName = projectName;
        this.mClientWSDLLastSavedTime = clientWSDL.lastModified();
        this.mClientFile = clientWSDL;

        //copy this file to build dir
        mClientWSDLModel = WSDLManager.getInstance().getWSDLModel(clientWSDL);
        initializeClientWSDLModel(projectName);
        //Scan the project dir and process each workflow files
        //  Load Static Task Client WSDL Template
        //  Set defenition Name/ TargetName space in the defenitions

        // From Workflow file, 
        //  get the Operation
        // From Operation get the WSDL Model
        // From Operation 
        //   get the Input and 
        //           Output messages
        //  For each Input and Output message
        //      Get the part information
        //      Get the schema type for each part
        //      If the schema is File  then get the File information
        //      If this is inline schema then serialize the schema to File 
        //          and store the File Information

        //  Proper Datastructure is needed to accomodate this
        //  Operation Class - with 3 members OperationName, 
        //     TaskName , Input and Output Message 
        //  Message Class - With list Of Parts
        //  Each PartClass with 3 members 
        //       PartName 
        //       QName of the ElementType
        //       File location of the schema
        //       Import the Schema File to Gen WSDL and get the QName for it
        //       and store.
        //
        //  Populate the Operation Class for each task and workflow file
        //  Iterate the operations 
        //  For each operation Name
        //    3 operations has to be created.
        //    opn1: Get<TaskName_opnName>Input 
        //      3 messages 
        //       TaskName_opnNameInputMessage1
        //          <part name="taskId" element="ns1:taskIdentifer"/>
        //       TaskName_opnNameOutputMessage1
        //           part is Operation's input message
        //       FaultMessage
        //    opn2: Get<opnName>Output
        //      TaskName_opnNameInputMessage2
        //         <part name="taskId" element="ns1:taskIdentifer"/>
        //      TaskName_opnNameOutputMessage2
        //           part is Operation's output message
        //      FaultMessage
        //    opn3: set<OpnName>Output
        //      TaskName_opnNameInputMessage3 
        //          <part name="taskId" element="ns1:taskIdentifer"/>
        //          part is operation's output message
        //    and for each operation 2 messages and the last one one message
        //     
        //     Create InputMessage1/OutputMessage1
        //     Create Get<opn>Input
        //     Create binding with HTTP://soapbc
        //     Create InputMessage2/OutMsg2
        //     Create Get<opn>Output
        //     Create InputMessg3
        //     Create set<opn>Out 
        //     

        //Implementation start:
        // Iterate the source directory and find out each Task Workflow files
        javax.swing.text.Document doc = null;

        try {
            processSourceDir(); 
            doc = this.mClientWSDLModel.getBaseDocument();
        } catch (Exception ex) {
        	this.mClientWSDLModel.endTransaction();
        	throw new RuntimeException (ex);
        }
        this.mClientWSDLModel.endTransaction();
        //this.mClientFile.setLastModified(this.mClientWSDLLastSavedTime);
        

        //addOperationToClientWSDL(listOfOperations);
        FileWriter writer = null;
        try {
            File clientWSDLFile = 
                new File(this.mBuildDir, this.mProjectName + "_wf_client.wsdl");

            writer = new FileWriter(clientWSDLFile);
            writer.write(doc.getText(0, doc.getLength()));
            writer.flush();
            writer.close();
        } catch (Exception ex) {
            throw new RuntimeException("Error during sync operation of client WSDL");
        } finally {
            try {
                writer.close();
            } catch (Exception e1) {
            }
            writer = null;
        }


    }

    /**
     * Proces the source directory to generate JBI.xml
     * @param sourceDir
     */
    private void processSourceDir() {
        processFileObject(this.mProjectDir);
    }

    /**
     * Process the file object to generate JBI.xml
     * @param file BPEL file location
     */
    private void processFileObject(File file) {
        if (file.isDirectory()) {
            processFolder(file);
        } else {
            processFile(file);
        }
    }

    /**
     * Process the folder to generate JBI.xml
     * @param fileDir  Folder location
     */
    private void processFolder(File fileDir) {
        File[] children = fileDir.listFiles();

        for (int i = 0; i < children.length; i++) {
            processFileObject(children[i]);
        }
    }

    /**
     * Process the file to generate JBI.xml
     * @param file input file
     */
    protected void processFile(File file) {
        String fileName = file.getName();
        String fileExtension = null;
        int dotIndex = fileName.lastIndexOf('.');
        if (dotIndex != -1) {
            fileExtension = fileName.substring(dotIndex + 1);
        }

        if (fileExtension != null && fileExtension.equalsIgnoreCase("wf")) {
            ArrayList<WSDLOperation> listOfOperations = 
                new ArrayList<WSDLOperation>();
            Util.addOperationInfo(file, listOfOperations, 
                                  this.mClientWSDLModel, this.mBuildDir, 
                                  this.mProjectDir);

            for (WSDLOperation wsdlOp: listOfOperations) {
                String operationName = wsdlOp.getOperationName();
                String taskName = wsdlOp.getTaskName();
                String generatedOpnName = "Get" + operationName + "Input";
                //Create new port type
                org.netbeans.modules.xml.wsdl.model.PortType clientWSDLPortType = this.mClientWSDLModel.getFactory().createPortType();
                //clientWSDLPortType.setName(wsdlOp.getPortTypeName().getLocalPart());
                clientWSDLPortType.setName(Util.getTaskSpecificClientPortTypeName(wsdlOp.getTaskName()));
                
                this.mClientWSDLModel.getDefinitions().addPortType(clientWSDLPortType);
                
                
                RequestResponseOperation reqResOpn = 
                    this.mClientWSDLModel.getFactory().createRequestResponseOperation();
                reqResOpn.setName(generatedOpnName);
                org.netbeans.modules.xml.wsdl.model.Input opn1Inp1 = 
                    this.mClientWSDLModel.getFactory().createInput();
                org.netbeans.modules.xml.wsdl.model.Message taskIdMsg = 
                    this.getTaskIdMessage(taskName); //getMessage("TaskIdMsg");

                NamedComponentReference opn1Inp1NCR = 
                    reqResOpn.createReferenceTo(taskIdMsg, 
                                                org.netbeans.modules.xml.wsdl.model.Message.class);
                opn1Inp1.setMessage(opn1Inp1NCR);
                opn1Inp1.setName(operationName + "InputMsg");
                reqResOpn.setInput(opn1Inp1);
                //Output Message
                String msg2Opn1Name = operationName + "InputData";
                org.netbeans.modules.xml.wsdl.model.Output opn1out1 = 
                    this.mClientWSDLModel.getFactory().createOutput();

                Message msg1Opn1 = 
                    this.mClientWSDLModel.getFactory().createMessage();
                msg1Opn1.setName(msg2Opn1Name);

                WSDLMessage inMsg = wsdlOp.getInputWSDLMessage();
                ArrayList<WSDLPart> listOfParts = inMsg.getParts();
                int in = 0;
                for (WSDLPart wsdlPart: listOfParts) {
                    Part msg1Opn1Part1 = 
                        this.mClientWSDLModel.getFactory().createPart();
                    if (in == 0) {
                        msg1Opn1Part1.setName("inputMsg");

                    } else {
                        msg1Opn1Part1.setName("inputMsg" + in);
                    }
                    in++;
                    if (wsdlPart.getElement() != null) {
                        GlobalType msg1Opn1Part1Type1 = 
                            craeteOrGetSchemaTypeInClientWSDL(wsdlPart.getElement());
                        msg1Opn1Part1.setType(msg1Opn1Part1.createSchemaReference(msg1Opn1Part1Type1, 
                                                                                  GlobalType.class));
                        msg1Opn1.addPart(msg1Opn1Part1);
                    } else {
                        if (wsdlPart.isStandardXMLSchemaSimpleTypes()) {
                            GlobalType msg1OpnPart1Type1 = 
                                createGlobalSimpleType(wsdlPart.getQueueName());
                            msg1Opn1Part1.setType(msg1Opn1Part1.createSchemaReference(msg1OpnPart1Type1, 
                                                                                      GlobalType.class));
                            msg1Opn1.addPart(msg1Opn1Part1);
                        } else {
                            GlobalType msg1OpnPart1Type1 = wsdlPart.getType();
                            msg1Opn1Part1.setType(msg1Opn1Part1.createSchemaReference(msg1OpnPart1Type1, 
                                                                                      GlobalType.class));
                            msg1Opn1.addPart(msg1Opn1Part1);
                        }
                    }
                }

                NamedComponentReference msg1Opn1NCR = 
                    reqResOpn.createReferenceTo(msg1Opn1, 
                                                org.netbeans.modules.xml.wsdl.model.Message.class);
                opn1out1.setMessage(msg1Opn1NCR);
                opn1out1.setName(operationName + "OutputMsg");
                reqResOpn.setOutput(opn1out1);

                org.netbeans.modules.xml.wsdl.model.Fault flt = 
                    this.mClientWSDLModel.getFactory().createFault();
                org.netbeans.modules.xml.wsdl.model.Message faultMsg = 
                    getFaultMessage(); //getMessage("OptFaultMsg");
                NamedComponentReference msgFaultNCR = 
                    reqResOpn.createReferenceTo(faultMsg, 
                                                org.netbeans.modules.xml.wsdl.model.Message.class);
                flt.setMessage(msgFaultNCR);
                flt.setName("fault1");
                reqResOpn.addFault(flt);

                this.mClientWSDLModel.getDefinitions().addMessage(msg1Opn1);
                clientWSDLPortType.addOperation(reqResOpn);
                NamedComponentReference ncrPortType = 
                    this.mClientWSDLModel.getDefinitions().createReferenceTo(clientWSDLPortType, 
                                                                             org.netbeans.modules.xml.wsdl.model.PortType.class);

                Binding colBinding = this.mClientWSDLModel.getFactory().createBinding();
                colBinding.setName(taskName);
                colBinding.setType(ncrPortType);
                this.mClientWSDLModel.getDefinitions().addBinding(colBinding);
                BindingInput binIn = 
                    this.mClientWSDLModel.getFactory().createBindingInput();
                BindingOutput binOut = 
                    this.mClientWSDLModel.getFactory().createBindingOutput();

                BindingFault binFault = 
                    this.mClientWSDLModel.getFactory().createBindingFault();
                binFault.setName(flt.getName());

                                BindingOperation bindOp = 
                    this.mClientWSDLModel.getFactory().createBindingOperation();
                bindOp.setOperation(colBinding.createReferenceTo(reqResOpn, 
                                                                 Operation.class));
                bindOp.setBindingInput(binIn);
                bindOp.setBindingOutput(binOut);
                bindOp.addBindingFault(binFault);
                colBinding.addBindingOperation(bindOp);

                SOAPBinding spBnd = this.mClientWSDLModel.getFactory().createSOAPBinding();
                spBnd.setStyle(SOAPBinding.Style.RPC);
                spBnd.setTransportURI("http://schemas.xmlsoap.org/soap/http");
                colBinding.addExtensibilityElement(spBnd);

                SOAPOperation spOpn = 
                    this.mClientWSDLModel.getFactory().createSOAPOperation();
                spOpn.setSoapAction(generatedOpnName);
                bindOp.addExtensibilityElement(spOpn);

                SOAPBody spBdy = 
                    this.mClientWSDLModel.getFactory().createSOAPBody();

                SOAPFault spFault = 
                    this.mClientWSDLModel.getFactory().createSOAPFault();
                spFault.setName("fault1");
                spFault.setUse(SOAPMessageBase.Use.LITERAL);

                spBdy = this.mClientWSDLModel.getFactory().createSOAPBody();
                spBdy.setNamespace(mClientWSDLModel.getDefinitions().getTargetNamespace());

                spBdy.setUse(SOAPMessageBase.Use.LITERAL);
                binIn.addExtensibilityElement(spBdy);
                spBdy = this.mClientWSDLModel.getFactory().createSOAPBody();
                spBdy.setNamespace(mClientWSDLModel.getDefinitions().getTargetNamespace());

                binOut.addExtensibilityElement(spBdy);
                binFault.addExtensibilityElement(spFault);

                //2ND MESSAGE
                generatedOpnName = "Get" + taskName + "Output";
                reqResOpn = 
                        this.mClientWSDLModel.getFactory().createRequestResponseOperation();
                reqResOpn.setName(generatedOpnName);
                opn1Inp1 = this.mClientWSDLModel.getFactory().createInput();
                //------------

                opn1Inp1NCR = 
                        reqResOpn.createReferenceTo(taskIdMsg, org.netbeans.modules.xml.wsdl.model.Message.class);
                opn1Inp1.setMessage(opn1Inp1NCR);
                opn1Inp1.setName(operationName + "InputMsg1");
                reqResOpn.setInput(opn1Inp1);

                msg2Opn1Name = operationName + "OutputData";
                opn1out1 = this.mClientWSDLModel.getFactory().createOutput();

                msg1Opn1 = this.mClientWSDLModel.getFactory().createMessage();
                msg1Opn1.setName(msg2Opn1Name);

                inMsg = wsdlOp.getOutputWSDLMessage();
                listOfParts = inMsg.getParts();
                in = 0;
                for (WSDLPart wsdlPart: listOfParts) {
                    Part msg1Opn1Part1 = 
                        this.mClientWSDLModel.getFactory().createPart();
                    if (in == 0) {
                        msg1Opn1Part1.setName("outputMsg");
                    } else {
                        msg1Opn1Part1.setName("outputMsg" + in);
                    }
                    in++;
                    if (wsdlPart.getElement() != null) {
                        GlobalType msg1Opn1Part1Type1 = 
                            craeteOrGetSchemaTypeInClientWSDL(wsdlPart.getElement());
                        msg1Opn1Part1.setType(msg1Opn1Part1.createSchemaReference(msg1Opn1Part1Type1, 
                                                                                  GlobalType.class));
                        msg1Opn1.addPart(msg1Opn1Part1);
                    } else {
                        if (wsdlPart.isStandardXMLSchemaSimpleTypes()) {
                            GlobalType msg1OpnPart1Type1 = 
                                createGlobalSimpleType(wsdlPart.getQueueName());
                            msg1Opn1Part1.setType(msg1Opn1Part1.createSchemaReference(msg1OpnPart1Type1, 
                                                                                      GlobalType.class));
                            msg1Opn1.addPart(msg1Opn1Part1);
                        } else {
                            GlobalType msg1OpnPart1Type1 = wsdlPart.getType();
                            msg1Opn1Part1.setType(msg1Opn1Part1.createSchemaReference(msg1OpnPart1Type1, 
                                                                                      GlobalType.class));
                            msg1Opn1.addPart(msg1Opn1Part1);
                        }
                    }
                }

                msg1Opn1NCR = 
                        reqResOpn.createReferenceTo(msg1Opn1, org.netbeans.modules.xml.wsdl.model.Message.class);
                opn1out1.setMessage(msg1Opn1NCR);
                opn1out1.setName(operationName + "OutputMsg1");
                reqResOpn.setOutput(opn1out1);

                flt = this.mClientWSDLModel.getFactory().createFault();
                msgFaultNCR = 
                        reqResOpn.createReferenceTo(faultMsg, org.netbeans.modules.xml.wsdl.model.Message.class);
                flt.setMessage(msgFaultNCR);
                flt.setName("fault1");
                reqResOpn.addFault(flt);

                this.mClientWSDLModel.getDefinitions().addMessage(msg1Opn1);
                clientWSDLPortType.addOperation(reqResOpn);

                binIn = 
                        this.mClientWSDLModel.getFactory().createBindingInput();
                binOut = 
                        this.mClientWSDLModel.getFactory().createBindingOutput();

                binFault = 
                        this.mClientWSDLModel.getFactory().createBindingFault();
                binFault.setName(flt.getName());


                bindOp = 
                        this.mClientWSDLModel.getFactory().createBindingOperation();
                bindOp.setOperation(colBinding.createReferenceTo(reqResOpn, 
                                                                 Operation.class));
                bindOp.setBindingInput(binIn);
                bindOp.setBindingOutput(binOut);
                bindOp.addBindingFault(binFault);
                colBinding.addBindingOperation(bindOp);

                spOpn = 
                        this.mClientWSDLModel.getFactory().createSOAPOperation();
                spOpn.setSoapAction(generatedOpnName);
                bindOp.addExtensibilityElement(spOpn);

                spBdy = this.mClientWSDLModel.getFactory().createSOAPBody();

                spFault = this.mClientWSDLModel.getFactory().createSOAPFault();
                spFault.setName("fault1");
                spFault.setUse(SOAPMessageBase.Use.LITERAL);

                spBdy = this.mClientWSDLModel.getFactory().createSOAPBody();
                spBdy.setNamespace(mClientWSDLModel.getDefinitions().getTargetNamespace());

                spBdy.setUse(SOAPMessageBase.Use.LITERAL);
                binIn.addExtensibilityElement(spBdy);
                spBdy = this.mClientWSDLModel.getFactory().createSOAPBody();
                spBdy.setNamespace(mClientWSDLModel.getDefinitions().getTargetNamespace());

                binOut.addExtensibilityElement(spBdy);
                binFault.addExtensibilityElement(spFault);

                //3
                generatedOpnName = "Set" + operationName + "Output";
                reqResOpn = 
                        this.mClientWSDLModel.getFactory().createRequestResponseOperation();

                //OneWayOperation oneWayOpn = this.mClientWSDLModel.getFactory().createOneWayOperation();
                reqResOpn.setName(generatedOpnName);

                opn1Inp1 = this.mClientWSDLModel.getFactory().createInput();

                org.netbeans.modules.xml.wsdl.model.Message inputMsg3 = 
                    this.mClientWSDLModel.getFactory().createMessage();
                org.netbeans.modules.xml.wsdl.model.Part inputMsg3Part1 = 
                    this.mClientWSDLModel.getFactory().createPart();
                NamedComponentReference ncr;
                ncr = getElementOrType(getMessage("TaskIdMsg"), "taskId");
                Referenceable ncrRef = ncr.get();
                if (ncrRef instanceof GlobalElement) {
                    inputMsg3Part1.setElement(ncr);
                } else {
                    inputMsg3Part1.setType(ncr);
                }
                //  inputMsg3Part1.setElement(ncr);
                inputMsg3Part1.setName("taskId");
                inputMsg3.addPart(inputMsg3Part1);


                inputMsg3.setName("Set" + taskName + "OutputData");
                inMsg = wsdlOp.getOutputWSDLMessage();
                listOfParts = inMsg.getParts();
                in = 0;
                for (WSDLPart wsdlPart: listOfParts) {
                    Part msg1Opn1Part1 = 
                        this.mClientWSDLModel.getFactory().createPart();
                    if (in == 0) {
                        msg1Opn1Part1.setName("outputMsg");
                    } else {
                        msg1Opn1Part1.setName("inputMsg" + (in++));
                    }
                    if (wsdlPart.getElement() != null) {
                        GlobalType msg1Opn1Part1Type1 = 
                            craeteOrGetSchemaTypeInClientWSDL(wsdlPart.getElement());
                        msg1Opn1Part1.setType(msg1Opn1Part1.createSchemaReference(msg1Opn1Part1Type1, 
                                                                                  GlobalType.class));
                        inputMsg3.addPart(msg1Opn1Part1);
                    } else {
                        if (wsdlPart.isStandardXMLSchemaSimpleTypes()) {
                            GlobalType msg1OpnPart1Type1 = 
                                createGlobalSimpleType(wsdlPart.getQueueName());
                            msg1Opn1Part1.setType(msg1Opn1Part1.createSchemaReference(msg1OpnPart1Type1, 
                                                                                      GlobalType.class));
                            inputMsg3.addPart(msg1Opn1Part1);
                        } else {
                            GlobalType msg1OpnPart1Type1 = wsdlPart.getType();
                            msg1Opn1Part1.setType(msg1Opn1Part1.createSchemaReference(msg1OpnPart1Type1, 
                                                                                      GlobalType.class));
                            inputMsg3.addPart(msg1Opn1Part1);
                        }
                    }
                }

                ncr = 
reqResOpn.createReferenceTo(inputMsg3, org.netbeans.modules.xml.wsdl.model.Message.class);
                opn1Inp1.setMessage(ncr);
                opn1Inp1.setName(taskName + "InputMsg2");
                reqResOpn.setInput(opn1Inp1);

                //output
                msg2Opn1Name = operationName + "InputData";
                opn1out1 = this.mClientWSDLModel.getFactory().createOutput();

                Message resultCodeMsg = this.getMessage("SetOptOutput_Output");
                opn1out1.setMessage(reqResOpn.createReferenceTo(resultCodeMsg, 
                                                                Message.class));
                opn1out1.setName(taskName + "OutputMsg2");
                reqResOpn.setOutput(opn1out1);
                clientWSDLPortType.addOperation(reqResOpn);
                this.mClientWSDLModel.getDefinitions().addMessage(inputMsg3);
                binIn = 
                        this.mClientWSDLModel.getFactory().createBindingInput();
                binOut = 
                        this.mClientWSDLModel.getFactory().createBindingOutput();

                bindOp = 
                        this.mClientWSDLModel.getFactory().createBindingOperation();

                bindOp.setOperation(colBinding.createReferenceTo(reqResOpn, 
                                                                 Operation.class));
                bindOp.setBindingInput(binIn);
                bindOp.setBindingOutput(binOut);

                colBinding.addBindingOperation(bindOp);
                spOpn = 
                        this.mClientWSDLModel.getFactory().createSOAPOperation();
                spOpn.setSoapAction(generatedOpnName);

                ///
                bindOp.addExtensibilityElement(spOpn);

                spBdy = this.mClientWSDLModel.getFactory().createSOAPBody();
                spBdy.setUse(SOAPMessageBase.Use.LITERAL);
                spBdy.setNamespace(mClientWSDLModel.getDefinitions().getTargetNamespace());
                binIn.addExtensibilityElement(spBdy);


                spBdy = this.mClientWSDLModel.getFactory().createSOAPBody();
                spBdy.setUse(SOAPMessageBase.Use.LITERAL);
                spBdy.setNamespace(mClientWSDLModel.getDefinitions().getTargetNamespace());
                binOut.addExtensibilityElement(spBdy);

                //Add Service , service already defined statically
                Service service = 
                    (Service)this.mClientWSDLModel.getDefinitions().getServices().iterator().next();

                Port port = this.mClientWSDLModel.getFactory().createPort();
                String portName = Util.getTaskSpecificClientEndpointName(mProjectName);
                //port.setName("Task" + mProjectName + "ClientPort");
                port.setName(portName);
                NamedComponentReference ncrBinding = 
                    this.mClientWSDLModel.getDefinitions().createReferenceTo(colBinding, 
                                                                             org.netbeans.modules.xml.wsdl.model.Binding.class);

                port.setBinding(ncrBinding);
                service.addPort(port);
                // port.
                SOAPAddress soapAddrs = 
                    this.mClientWSDLModel.getFactory().createSOAPAddress();
                soapAddrs.setLocation("http://localhost:18181/wfse/" + 
                                      mProjectName + "Client");
                port.addExtensibilityElement(soapAddrs);

                // Add PartnerLink
                org.netbeans.modules.xml.wsdl.model.extensions.bpel.BPELComponentFactory bcf = 
                    new BPELComponentFactory(this.mClientWSDLModel);
                PartnerLinkType plt = 
                    bcf.createPartnerLinkType(this.mClientWSDLModel.getDefinitions());
                plt.setName("Task" + mProjectName + "ClientLT");

                Role role = 
                    bcf.createRole(this.mClientWSDLModel.getDefinitions());
                role.setName("Task" + mProjectName + "Client_Server");
                role.setPortType(ncrPortType);

                plt.setRole1(role);

                this.mClientWSDLModel.getDefinitions().addExtensibilityElement(plt);


            }
        }
    }

    private org.netbeans.modules.xml.wsdl.model.Message getTaskIdMessage(String taskName) {
        org.netbeans.modules.xml.wsdl.model.Message msg = 
            this.mMapOfOpnToMessage.get(taskName);
        if (msg == null) {
            msg = this.mClientWSDLModel.getFactory().createMessage();
            msg.setName(taskName + "TaskId");
            Part part = this.mClientWSDLModel.getFactory().createPart();
            part.setName("taskId");
            GlobalType gst = createGlobalSimpleType("int");
            part.setType(part.createSchemaReference(gst, GlobalType.class));
            msg.addPart(part);
            this.mClientWSDLModel.getDefinitions().addMessage(msg);
            this.mMapOfOpnToMessage.put(taskName, msg);
        }
        return msg;
    }

    private org.netbeans.modules.xml.wsdl.model.Message getMessage(String msgName) {
        org.netbeans.modules.xml.wsdl.model.Message resultMsg = 
            this.mMapOfOpnToMessage.get(msgName);
        if (resultMsg == null) {
            Collection<org.netbeans.modules.xml.wsdl.model.Message> messages = 
                this.mClientWSDLModel.getDefinitions().getMessages();
            for (org.netbeans.modules.xml.wsdl.model.Message msg: messages) {
                if (msg.getName().equals(msgName)) {
                    this.mMapOfOpnToMessage.put(msgName, msg);
                    return msg;
                }
            }
        }
        return null;
    }

    private Message getFaultMessage() {
        org.netbeans.modules.xml.wsdl.model.Message resultMsg = 
            getMessage("OptFaultMsg");
        if (resultMsg == null) {
            resultMsg = this.mClientWSDLModel.getFactory().createMessage();
            resultMsg.setName("OptFaultMsg");
            Part part = this.mClientWSDLModel.getFactory().createPart();
            part.setName("fault");
            GlobalType gst = createGlobalSimpleType("AnyType");
            part.setType(part.createSchemaReference(gst, GlobalType.class));
            resultMsg.addPart(part);
            this.mClientWSDLModel.getDefinitions().addMessage(resultMsg);
            this.mMapOfOpnToMessage.put("fault1", resultMsg);

        }
        return resultMsg;
    }

    private void initializeClientWSDLModel(String projectName) {
        String clientWSDLName = 
            projectName + "_" + CLIENTWSDL_DEF_NAME_TEMPLATE_SUFFIX;
        String clientWSDLNS = 
            this.CLIENTWSDL_NS_TEMPLATE_PREFIX + projectName + 
            this.CLIENTWSDL_NS_TEMPLATE_SUFFIX;
        Definitions clientWSDLDef = this.mClientWSDLModel.getDefinitions();
        
        mClientWSDLModel.startTransaction();
        clientWSDLDef.setName(clientWSDLName);
        clientWSDLDef.setTargetNamespace(clientWSDLNS);


        // QName tnsQNAME = new QName()
        // clientWSDLDef.setAnyAttribute();
        // mClientWSDLModel

    }


    private void addOperationInfo(File workFile) {
        //Get the Operation information
    }

    private NamedComponentReference getElement(Message msg, 
                                               String elementName) {
        Collection<Part> partsColl = msg.getParts();
        Iterator<Part> partsCollItr = partsColl.iterator();
        while (partsCollItr.hasNext()) {
            Part part = partsCollItr.next();
            NamedComponentReference ncr = part.getElement();
            GlobalElement ge = (GlobalElement)ncr.get();
            if (ge.getName().equals(elementName)) {
                return ncr;
            }
        }
        return null;
    }

    private NamedComponentReference getElementOrType(Message msg, 
                                                     String elementName) {
        Collection<Part> partsColl = msg.getParts();
        Iterator<Part> partsCollItr = partsColl.iterator();
        while (partsCollItr.hasNext()) {
            Part part = partsCollItr.next();
            if (part.getName().equals(elementName)) {
                NamedComponentReference ncr = part.getType();
                if (ncr != null) {
                    return ncr;
                } else {
                    ncr = part.getElement();
                    if (ncr != null) {
                        return ncr;
                    }
                }
            }
        }
        return null;
    }

    private GlobalType craeteOrGetSchemaTypeInClientWSDL(GlobalElement ge) {
        GlobalType gt = null;
        NamedComponentReference gtRef = ge.getType();    
        if(gtRef != null) {
            Object type = gtRef.get();
            if(type instanceof GlobalType) {
                gt = (GlobalType) type;
            } 
            
            
            
        } else {
            //this is local type so need to create a global type which extends this?
        	LocalType lt = ge.getInlineType();
        	if(lt != null) {
        		//createComplexSchemaInClientWSDL(lt);
        		throw new UnsupportedOperationException("part with element having inline type not yet supported");
        	}
        }
        
        return gt;
    }
    
    
    
//    private GlobalComplexType createComplexSchemaInClientWSDL(GlobalElement ge) {
//        Types wsdlTypes = this.mClientWSDLModel.getDefinitions().getTypes();
//        Collection<org.netbeans.modules.xml.schema.model.Schema> colSchemas = 
//            wsdlTypes.getSchemas();
//        Iterator<org.netbeans.modules.xml.schema.model.Schema> colSchemasItr = 
//            colSchemas.iterator();
//        org.netbeans.modules.xml.schema.model.Schema matchingSchema = null;
//        org.netbeans.modules.xml.wsdl.model.extensions.xsd.WSDLSchema wsdlSchema = 
//            null;
//        matchingSchema = findWSDLInlineSchema();
//        if (matchingSchema == null) {
//            //Create a schema
//            wsdlSchema = mClientWSDLModel.getFactory().createWSDLSchema();
//            SchemaModel schemaModel = wsdlSchema.getSchemaModel();
//
//            matchingSchema = schemaModel.getSchema();
//            matchingSchema.setTargetNamespace(mClientWSDLModel.getDefinitions().getTargetNamespace());
//            mClientWSDLSchema = matchingSchema;
//
//        }
//
//        GlobalComplexType gcx = null;
//        Collection<GlobalComplexType> cmplTypesColl = 
//            matchingSchema.getComplexTypes();
//        Iterator<GlobalComplexType> cmpTypesItr = cmplTypesColl.iterator();
//        while (cmpTypesItr.hasNext()) {
//            GlobalComplexType gct = cmpTypesItr.next();
//            if (gct.getName().equals(ge.getName() + "CX")) {
//                gcx = gct;
//                break;
//            }
//        }
//        if (gcx == null) {
//            gcx = matchingSchema.getModel().getFactory().createGlobalComplexType();
//            Sequence seq = 
//                matchingSchema.getModel().getFactory().createSequence();
//            LocalElement le = 
//                matchingSchema.getModel().getFactory().createLocalElement();
//            gcx.setName(ge.getName() + "CX");
//            le.setName(ge.getName() + "Element");
//            le.setType(ge.getType());
//
//            seq.appendContent(le);
//            gcx.setDefinition(seq);
//            matchingSchema.addComplexType(gcx);
//
//            if (wsdlSchema != null) {
//                this.mClientWSDLModel.getDefinitions().getTypes().addExtensibilityElement(wsdlSchema);
//            }
//        }
//        return gcx;
//    }

    private org.netbeans.modules.xml.schema.model.Schema findWSDLInlineSchema() {
        org.netbeans.modules.xml.schema.model.Schema schema = null;
        org.netbeans.modules.xml.schema.model.Schema matchingSchema = null;
        org.netbeans.modules.xml.wsdl.model.extensions.xsd.WSDLSchema matchingWSDLSchema = 
            null;

        if (mClientWSDLSchema == null) {
            String wsdlTNS = 
                this.mClientWSDLModel.getDefinitions().getTargetNamespace();
            Iterator<ExtensibilityElement> colSchemasItr = 
                this.mClientWSDLModel.getDefinitions().getTypes().getExtensibilityElements().iterator();
            while (colSchemasItr.hasNext()) {
                ExtensibilityElement exElem = colSchemasItr.next();
                org.netbeans.modules.xml.wsdl.model.extensions.xsd.WSDLSchema wsdlSchema = 
                    null;
                if (exElem instanceof 
                    org.netbeans.modules.xml.wsdl.model.extensions.xsd.WSDLSchema) {
                    wsdlSchema = 
                            (org.netbeans.modules.xml.wsdl.model.extensions.xsd.WSDLSchema)exElem;
                    schema = wsdlSchema.getSchemaModel().getSchema();
                }
                //Find the inline schema defined in client wsdl
                if (schema.getTargetNamespace() != null && 
                    schema.getTargetNamespace().equals(wsdlTNS)) {
                    matchingSchema = schema;
                    matchingWSDLSchema = wsdlSchema;
                    mClientWSDLSchema = matchingSchema;
                    break;
                }
            }

        }
        return mClientWSDLSchema;
    }

    private GlobalType createGlobalSimpleType(String typeName) {
        SchemaModel primitiveModel = 
            SchemaModelFactory.getDefault().getPrimitiveTypesModel();
        Collection<GlobalSimpleType> primitives = 
            primitiveModel.getSchema().getSimpleTypes();
        for (GlobalSimpleType ptype: primitives) {
            if (ptype.getName().equals(typeName)) {
                return ptype;
            }
        }
        return null;
    }

    private GlobalType createGlobalSimpleType(QName simpleTypeQName) {
        String typeName = simpleTypeQName.getLocalPart();
        return createGlobalSimpleType(typeName);
    }
}
