/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.wlm.model.impl;

import org.netbeans.modules.wlm.model.api.TAddress;
import org.netbeans.modules.wlm.model.api.TRecipient;
import org.netbeans.modules.wlm.model.api.WLMComponent;
import org.netbeans.modules.wlm.model.api.WLMModel;
import org.netbeans.modules.wlm.model.api.WLMVisitor;
import org.w3c.dom.Element;

public class RecipientImpl extends WLMComponentBase implements TRecipient {
	
	public RecipientImpl(WLMModel model, Element e) {
		super(model, e);
		// TODO Auto-generated constructor stub
	}

	public RecipientImpl(WLMModel model) {
		this(model, createNewElement(WLMQNames.RECIPIENT.getQName(), model));
	}
	

	public TAddress getAddress() {
		// TODO Auto-generated method stub
		return getChild(TAddress.class);
	}

	public void setAddress(TAddress value) {
		// TODO Auto-generated method stub
		setChild(TAddress.class, ADDRESS_PROPERTY, value, TypeCollection.EMPTY.types());
	}

	public void accept(WLMVisitor visitor) {
		// TODO Auto-generated method stub
		visitor.visitRecipient(this);
	}

	public WLMComponent createChild(Element childEl) {
		// TODO Auto-generated method stub
		// TODO Auto-generated method stub
		WLMComponent child = null;
		if (childEl != null) {
			String localName = childEl.getLocalName();
			if (localName == null || localName.length() == 0) {
				localName = childEl.getTagName();
			}
			if (localName.equals(ADDRESS_PROPERTY)) {
				child = new AddressImpl(getModel(), childEl);
			} 
		}
		return child;
	}

}
