/*
 * TaskDefinitionMultiViewElement.java
 * 
 * Created on May 24, 2007, 3:09:23 PM
 * 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.netbeans.modules.worklist.editor.multiview.timeout;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import org.netbeans.modules.wlm.model.api.TTask;
import org.netbeans.modules.wlm.model.api.TTimeout;
import org.netbeans.modules.wlm.model.api.WLMComponent;
import org.netbeans.modules.wlm.model.api.WLMModel;
import org.netbeans.modules.worklist.dataloader.WorklistDataObject;
import org.netbeans.modules.worklist.editor.multiview.PanelKey;
import org.netbeans.modules.worklist.editor.multiview.TaskSelectionEvent;
import org.netbeans.modules.worklist.editor.multiview.TaskSelectionListener;
import org.netbeans.modules.worklist.editor.multiview.TaskSelectionModel;
import org.netbeans.modules.worklist.editor.view.actions.RemoveAction;
import org.netbeans.modules.worklist.editor.view.nodes.DeadlineOrDurationNode;
import org.netbeans.modules.worklist.editor.view.nodes.TimeoutNode;
import org.netbeans.modules.worklist.node.cookie.WLMComponentCookie;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.ui.SectionContainer;
import org.netbeans.modules.xml.multiview.ui.SectionContainerNode;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.netbeans.modules.xml.validation.ValidateAction;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/**
 *
 * @author radval
 */
public class TimeoutMultiViewElement extends ToolBarMultiViewElement implements java.beans.PropertyChangeListener {

    private WorklistDataObject dObj;
    
    private TimeoutsView view;
    private ToolBarDesignEditor comp;
    private TimeoutPanelFactory factory;
    private javax.swing.Action addAction;
    private boolean needInit=true;
    private int index;
    private TaskSelectionModel taskSelectionModel;
    private TTask selectedTask;
    private List<TTimeout> existingTimeouts = new ArrayList<TTimeout>();
    
    private RequestProcessor.Task repaintingTask;
   
    private static final String HELP_ID_PREFIX=WorklistDataObject.HELP_ID_PREFIX_ASSIGNMENT;
    
    static final String TIMEOUT_PANEL = "Timeout";
    
    
    
    public TimeoutMultiViewElement(final WorklistDataObject dObj, 
                                    int index,
                                    TaskSelectionModel taskSelectionModel) {
        super(dObj);
        this.dObj=dObj;
        this.index=index;
        this.taskSelectionModel = taskSelectionModel;
        
         comp = new ToolBarDesignEditor();
        factory = new TimeoutPanelFactory(comp, dObj);
        addAction = new AddAction(dObj,NbBundle.getMessage(TimeoutMultiViewElement.class,"LBL_addTimeout"));
        setVisualEditor(comp);
        view = new TimeoutsView();
        comp.setContentView(view);
        repaintingTask = RequestProcessor.getDefault().create(new Runnable() {
            public void run() {
                javax.swing.SwingUtilities.invokeLater(new Runnable() {
                    public void run() {
                        repaintView();
                    }
                });
            }
        });
        
        initGUI();
    }

    public SectionView getSectionView() {
        return this.view;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        
    }
    
    private void repaintView() {
        
        Object lastActive = comp.getLastActive();
        if (lastActive!=null) {
            ((SectionView)view).openPanel(lastActive);
        } else {
            TimeoutsView timeoutsView = (TimeoutsView)view;
            Node initialNode = timeoutsView.getTimeoutsNode();
            Children ch = initialNode.getChildren();
            if (ch.getNodesCount()>0) 
                initialNode = ch.getNodes()[0];
            timeoutsView.selectNode(initialNode);
        }
        view.checkValidity();
        //ritdObj.checkParseable();
    }
    
      public void componentShowing() {
        super.componentShowing();
        dObj.setLastOpenView(index);
        if (needInit || !dObj.isDocumentParseable()) {
            repaintView();
            needInit = false;
        }
    }
  
    private void initGUI() {
        dObj.getTaskSelectionModel().addTaskSelectionListner(new TaskSelectionAdapter());
        
        selectedTask = dObj.getTaskSelectionModel().getSelectedTask();
        
        WLMModel model = dObj.getModel();
        if(model != null) {
            model.addComponentListener(new TaskComponentListener());
        }

        JComponent toolbar = comp.getStructureView();
        if(toolbar instanceof JToolBar) {
            JToolBar tBar = (JToolBar) toolbar;
            tBar.add(new ValidateAction(model));
        }    
   }
     
   private void refreshWhenChildAdded() {
         List<TTimeout> timeouts =  selectedTask.getTimeouts();
         if(timeouts != null) {
             Iterator<TTimeout> it =  timeouts.iterator();
             while(it.hasNext()) {
                 TTimeout timeout = it.next();
                 if(!existingTimeouts.contains(timeout)) {
                   SectionContainer timeoutContainer = view.addTimeout(timeout, timeouts.indexOf(timeout));
                   if(timeoutContainer != null) {
                        timeoutContainer.open(); 
                   }
                }
                 
             }
             
             existingTimeouts = timeouts;
         }
         
    }
    
    private void refreshWhenChildRemoved() {
        List<TTimeout> timeouts =  selectedTask.getTimeouts();
         if(timeouts != null) {
             Iterator<TTimeout> it =  existingTimeouts.iterator();
             while(it.hasNext()) {
                 TTimeout escalation = it.next();
                 if(!timeouts.contains(escalation)) {
                   view.removeTimeout(escalation);
                }
                 
             }
             
             existingTimeouts = timeouts;
         }
    }
    
    class TimeoutsView extends SectionView {
        private SectionContainer timeoutsContainer;
        private Node timeoutsNode;
        
            
        TimeoutsView () {
            super(factory);
            
            Children ch = new Children.Array();
            timeoutsNode = new SectionContainerNode(ch);
            //root.setDisplayName("<Servlets>");
            timeoutsNode.setDisplayName(NbBundle.getMessage(TimeoutMultiViewElement.class,"TTL_timeouts"));
            timeoutsNode.setName(HELP_ID_PREFIX+"servletsNode"); //NOI18N

            refreshGUI();
            

            Children servletsChildren = new Children.Array();
            servletsChildren.add(new Node[]{timeoutsNode});
        
            AbstractNode root = new AbstractNode(servletsChildren);
            setRoot(root);
            
        }
        
        Node getTimeoutsNode() {
            return timeoutsNode;
        }
        
        
        public org.netbeans.modules.xml.multiview.Error validateView() {
            org.netbeans.modules.xml.multiview.Error error = null; //getSectionView().getErrorPanel().getError();
//            if (error != null){
//                return error;
//            }
            
            TTask task = taskSelectionModel.getSelectedTask();
            if(task == null) {
                error = new org.netbeans.modules.xml.multiview.Error(org.netbeans.modules.xml.multiview.Error.ERROR_MESSAGE, "Select a task from overview section" , this);
            }
            
            return error;
            //ritreturn SectionValidator.validateServlets(webApp);
        }
        
        private void refreshGUI() {
            TTask task = taskSelectionModel.getSelectedTask();
            if(task != null) {
                
                if(timeoutsNode != null) {
                    timeoutsNode.getChildren().remove(timeoutsNode.getChildren().getNodes());
                }
                
                if(timeoutsContainer != null) {
                    removeSection(timeoutsContainer);
                }
                

                timeoutsContainer = new SectionContainer(this,timeoutsNode,
                    NbBundle.getMessage(TimeoutMultiViewElement.class,"TTL_timeouts"),false);
                timeoutsContainer.setHeaderActions(new javax.swing.Action[]{addAction});
                addSection(timeoutsContainer);

                List<TTimeout> timeouts = task.getTimeouts();
                Node[] nodes = new Node[timeouts.size()];
                
                existingTimeouts = new ArrayList<TTimeout>();
                existingTimeouts.addAll(timeouts);
                
                for (int i=0; i < timeouts.size(); i++) {
                    TTimeout timeout = timeouts.get(i);
                    addTimeout(timeout, i);
                }
                
            }
        }
        
        public SectionContainer addTimeout(TTimeout timeout, int i) {
            SectionContainer timeoutContainer = null;
            if(timeout != null) {
                String displayName = "Timeout ("+ i + ")";
                TimeoutNode timeoutNode = new TimeoutNode(this, timeout, displayName);
                timeoutsNode.getChildren().add(new Node[] {timeoutNode});
                
                timeoutContainer = new SectionContainer(this, timeoutNode, displayName, false);
                RemoveAction removeAction = new RemoveAction(timeout);
                timeoutContainer.setHeaderActions(new javax.swing.Action[]{removeAction});
                timeoutsContainer.addSection(timeoutContainer);



                PanelKey key = new PanelKey(timeout, null);
                DeadlineOrDurationNode deadlineOrDurationNode = new DeadlineOrDurationNode(timeout, "Deadline Or Duration");
                SectionPanel dPanel = new SectionPanel(this, deadlineOrDurationNode, "Deadline Or Duration", key);
                timeoutContainer.addSection(dPanel);
                timeoutsNode.getChildren().add(new Node[] {deadlineOrDurationNode});
                    
            }
            return timeoutContainer;
        }
        
        public void removeTimeout(TTimeout timeout) {
            Node matchingNode = null;
            
            Children children = timeoutsNode.getChildren();
            Node[] nodes = children.getNodes();
            for(int i = 0; i < nodes.length; i++) {
                Node node = nodes[i];
                WLMComponentCookie cookie = node.getLookup().lookup(WLMComponentCookie.class);
                if(cookie != null) {
                    WLMComponent component = cookie.getWLMComponent();
                    if(component != null && component.equals(timeout)) {
                        matchingNode = node;
                        break;    
                    }
                }
            }
            
            if(matchingNode != null) {
                children.remove(new Node[] {matchingNode});
                removeSection(matchingNode);
            }
        }
    }
    
    
    private class AddAction extends javax.swing.AbstractAction {
        
        AddAction(final WorklistDataObject dObj, String actionName) {
            super(actionName);
            char mnem = NbBundle.getMessage(TimeoutMultiViewElement.class,"LBL_addTimeout_mnem").charAt(0);
            putValue(MNEMONIC_KEY,new Integer((int)mnem));
        }
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            TTimeout timeout = dObj.getModel().getFactory().createTimeout(dObj.getModel());
            dObj.getModel().startTransaction();
            selectedTask.addTimeOut(timeout);
            dObj.getModel().endTransaction();
        }
    }
    
    private class TaskSelectionAdapter implements TaskSelectionListener {

        public void taskSelected(TaskSelectionEvent evt) {
            TTask task = evt.getTask();
            selectedTask = task;
            //view.refreshGUI();
            view = new TimeoutsView();
            comp.setContentView(view);
            view.checkValidity();
            
        }
    }
    
     private class TaskComponentListener implements ComponentListener {

        public void valueChanged(ComponentEvent evt) {
            
        }

        public void childrenAdded(ComponentEvent evt) {
            Object source = evt.getSource();
            if(source instanceof TTask) {
                refreshWhenChildAdded();
            }
        }

        public void childrenDeleted(ComponentEvent evt) {
            Object source = evt.getSource();
            if(source instanceof TTask) {
                refreshWhenChildRemoved();
            }
        }
        
    } 
}
