package org.netbeans.modules.worklist.dataloader;

import java.io.IOException;
import java.io.Serializable;
import org.netbeans.modules.wlm.model.api.WLMModel;
import org.netbeans.modules.wlm.model.api.WLMModelFactory;
import org.netbeans.modules.worklist.editor.multiview.TaskSelectionModel;
import org.netbeans.modules.worklist.editor.multiview.assignment.AssignmentMultiViewElement;
import org.netbeans.modules.worklist.editor.multiview.escalation.EscalationMultiViewElement;
import org.netbeans.modules.worklist.editor.multiview.notification.NotificationMultiViewElement;
import org.netbeans.modules.worklist.editor.multiview.overview.OverviewMultiViewElement;
import org.netbeans.modules.worklist.editor.multiview.timeout.TimeoutMultiViewElement;
import org.netbeans.modules.xml.multiview.DesignMultiViewDesc;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.text.DataEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.ErrorManager;
import org.xml.sax.InputSource;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
public class WorklistDataObject extends XmlMultiViewDataObject {
    
    public static final String DD_MULTIVIEW_PREFIX = "dd_multiview"; // NOI18N
    public static final String MULTIVIEW_OVERVIEW = "Overview"; // NOI18N
    public static final String MULTIVIEW_ASSIGNMENT = "Assignment"; // NOI18N
    public static final String MULTIVIEW_ESCALATION = "Escalation"; // NOI18N
    public static final String MULTIVIEW_TIMEOUT = "Timeout"; // NOI18N
    public static final String MULTIVIEW_NOTIFICATION = "Notification"; // NOI18N
    
     /** Property name for documentDTD property */
    public static final String PROP_DOCUMENT_DTD = "documentDTD";   // NOI18N
    public static final String HELP_ID_PREFIX_OVERVIEW="dd_multiview_overview_"; //NOI18N
    public static final String HELP_ID_PREFIX_ASSIGNMENT="worklist_multiview_assignment_"; //NOI18N
    public static final String HELP_ID_PREFIX_FILTERS="dd_multiview_filters_"; //NOI18N
    public static final String HELP_ID_PREFIX_PAGES="dd_multiview_pages_"; //NOI18N
    public static final String HELP_ID_PREFIX_REFERENCES="dd_multiview_references_"; //NOI18N
    public static final String HELP_ID_PREFIX_SECURITY="dd_multiview_security_"; //NOI18N

    private TaskSelectionModel taskSelectionModel;
            
    private WLMModel model;
    
    private WorklistEditorSupport editorSupport;
    
    public WorklistDataObject(FileObject pf, WorklistDataLoader loader) throws DataObjectExistsException, IOException {
        super(pf, loader);
        CookieSet cookies = getCookieSet();
        cookies.add((Node.Cookie) DataEditorSupport.create(this, getPrimaryEntry(), cookies));
        
        //editorSupport = new WorklistEditorSupport(this);
        // editor support defines MIME type understood by EditorKits registry
        //cookies.add(editorSupport);

        // Add check and validate cookies
        InputSource is = DataObjectAdapters.inputSource(this);
        cookies.add(new CheckXMLSupport(is));
        
        taskSelectionModel = new TaskSelectionModel();
        
        
    }
    
    protected Node createNodeDelegate() {
        return new WorklistDataNode(this);
    }
    
    /*public @Override Lookup getLookup() {
        return getCookieSet().getLookup();
    }*/

    protected String getPrefixMark() {
        return "<tasks";
    }
    
     protected DesignMultiViewDesc[] getMultiViewDesc() {
         if(taskSelectionModel == null) {
             taskSelectionModel = new TaskSelectionModel();
         }
         
        return new DesignMultiViewDesc[] {
            new WLMView(this,MULTIVIEW_OVERVIEW),
            new WLMView(this,MULTIVIEW_ASSIGNMENT),
            new WLMView(this,MULTIVIEW_ESCALATION),
            new WLMView(this,MULTIVIEW_TIMEOUT)
            //new WLMView(this,MULTIVIEW_NOTIFICATION),
            //new WLMView(this, MULTIVIEW_SECURITY)
            //new DDView(this,"Security")
        };
    }
     
    private class WLMView extends DesignMultiViewDesc implements Serializable {
        private static final long serialVersionUID = -4224134594154669985L;
        private String name;

        WLMView() {}

        WLMView(WorklistDataObject dObj,String name) {
            super(dObj, name);
            this.name=name;
        }

        public org.netbeans.core.spi.multiview.MultiViewElement createElement() {
            WorklistDataObject dObj = (WorklistDataObject)getDataObject();
            if (name.equals(MULTIVIEW_OVERVIEW)) {
                return new OverviewMultiViewElement(dObj, 0, taskSelectionModel);
            } else if (name.equals(MULTIVIEW_ASSIGNMENT)) {
                return new AssignmentMultiViewElement(dObj,1, taskSelectionModel);
            } else if (name.equals(MULTIVIEW_ESCALATION)) {
                return new EscalationMultiViewElement(dObj,2, taskSelectionModel);
            } else if(name.equals(MULTIVIEW_TIMEOUT)) {
                return new TimeoutMultiViewElement(dObj,3, taskSelectionModel);
            } else if(name.equals(MULTIVIEW_NOTIFICATION)) {
                return new NotificationMultiViewElement(dObj,4, taskSelectionModel);
            } 
            return null; 
        }

        public HelpCtx getHelpCtx() {
            if (name.equals(MULTIVIEW_OVERVIEW)) {
                //return new HelpCtx(HELP_ID_PREFIX_OVERVIEW+"overviewNode"); //NOI18N
            } else if (name.equals(MULTIVIEW_ASSIGNMENT)) {
                return new HelpCtx(HELP_ID_PREFIX_ASSIGNMENT+"assignmentNode"); //NOI18N
            } else if (name.equals(MULTIVIEW_ESCALATION)) {
                //return new HelpCtx(HELP_ID_PREFIX_FILTERS+"filtersNode"); //NOI18N
            } else if(name.equals(MULTIVIEW_TIMEOUT)) {
                //return new HelpCtx(HELP_ID_PREFIX_OVERVIEW+"overviewNode"); //NOI18N
            } else if(name.equals(MULTIVIEW_NOTIFICATION)) {
                //return new HelpCtx(HELP_ID_PREFIX_REFERENCES+"references"); //NOI18N
            }
            return null;
        }

        public java.awt.Image getIcon() {
            return org.openide.util.Utilities.loadImage("org/netbeans/modules/j2ee/ddloaders/web/resources/DDDataIcon.gif"); //NOI18N
        }

        public String preferredID() {
            return DD_MULTIVIEW_PREFIX+name;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(WorklistDataObject.class,"TTL_"+name);
        }
        
         
    }
    
    public WLMModel getModel() {
            if(model == null) {
                ModelSource modelSource = Utilities.getModelSource(this.getPrimaryFile(), true);
                if(modelSource != null) {
                    model = WLMModelFactory.getDefault().getModel(modelSource);
                }
            }
            return model;
    }
    
    public TaskSelectionModel getTaskSelectionModel() {
        return this.taskSelectionModel;
    }
    
    public WorklistEditorSupport getWSDLEditorSupport() {
        return editorSupport;
    }
    
    public boolean isDocumentParseable() {
        return getModel().getState() == WLMModel.State.VALID;
    }
}
