/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.script.project.wizard.element;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;

import javax.swing.JButton;
import javax.swing.JPanel;

import org.openide.DialogDescriptor;
import org.netbeans.api.project.Project;

import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.view.ElementOrType;
import org.netbeans.modules.xml.wsdl.ui.view.ElementOrTypeChooserPanel;

/**
 * @author Raghunadh
 * 
 */
final class DialogType<T> {

  DialogType(
    Project project,
    WSDLModel model,
    PanelOperation<T> panel,
    boolean isInput)
  {
    myProject = project;
    myModel = model;
    myPanel = panel;
    myIsInput = isInput;
  }

  private JPanel createPanel() {
    JPanel panel = new JPanel(new GridBagLayout());
    GridBagConstraints c = new GridBagConstraints();
    c.anchor = GridBagConstraints.NORTHWEST;
    c.gridx = 0;

    // chooser
    c.weightx = 1.0;
    c.weighty = 1.0;
    c.fill = GridBagConstraints.BOTH;
    panel.add(createChooserPanel(), c);

    // [browse]
    c.fill = GridBagConstraints.NONE;
    c.insets = new Insets(8, 0, 0, 0);

    return panel;
  }

  private JPanel createChooserPanel() {
    myChooser = new ElementOrTypeChooserPanel(
      myProject, new HashMap<String, String>(), myModel);

    PropertyChangeListener listener = new PropertyChangeListener() {
      public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == myChooser && event.getPropertyName().
          equals(ElementOrTypeChooserPanel.PROP_ACTION_APPLY))
        {
          myDescriptor.setValid(((Boolean) event.getNewValue()).booleanValue());
        }
      }
    };
    myChooser.addPropertyChangeListener(listener);

    return myChooser;
  }

  private void select() {
    myChooser.apply();
    ElementOrType elementOrType = myChooser.getSelectedComponent();
    myPanel.setElementOrType(elementOrType, myIsInput);
  }

  private String getName(ElementOrType elementOrType) {
    GlobalElement element = elementOrType.getElement();

    if (element != null) {
      return element.getName();
    }
    GlobalType type = elementOrType.getType();

    if (type != null) {
      return type.getName();
    }
    return null;
  }

  private Project myProject;
  private WSDLModel myModel;
  private boolean myIsInput;
  private PanelOperation<T> myPanel;
  private DialogDescriptor myDescriptor;
  private ElementOrTypeChooserPanel myChooser;
}
