/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.script.core.scriptmap;

import java.util.Map;
import java.util.WeakHashMap;
import org.openide.filesystems.FileObject;
import org.w3c.dom.Document;

/**
 * Accessor for the ScriptMapModel
 * @author Raghunadh Teegavarapu
 * @version 1.0
 */
public class ScriptMapAccessor {
    
    private ScriptMapAccessor() {
    }
    
    /**
     * If ScriptMapFile is null then return null
     * If ScriptMapFile couldn't be parsed or has another 
     * structure then required for the Scriptmap.xml file by specification then return null
     *
     * now ScriptMap model should be rebuilded every time as ScriptMap file has been changed
     * @param ScriptMapFile Scriptmap.xml file contains neccessary Script transforamtion use cases
     * @return ScriptMapModel correspondent to the Scriptmap file
     */
    public static ScriptMapModel getScriptMapModel(FileObject scriptMapFile) {
        if (!isValidScriptMapFile(scriptMapFile)) {
            return null;
        }
        ScriptMapModel model = new ScriptMapModel(scriptMapFile);
        model.initScriptMapModel();
        if (!model.isInitModel()) {
            model = null;
        }
        
        return model;
    }
    
    public static boolean isValidScriptMapFile(FileObject scriptMapFile) {
        return scriptMapFile != null 
                && ScriptMapConst.XML.equals(scriptMapFile.getExt()) 
                && ScriptMapConst.SCRIPTMAP.equals(scriptMapFile.getName());
    }
    
    
}
