package org.netbeans.modules.wsdlextensions.ldap;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JPanel;
import org.netbeans.api.project.Project;

import org.netbeans.modules.wsdlextensions.ldap.ldif.GenerateWSDL;
import org.netbeans.modules.wsdlextensions.ldap.ldif.GenerateXSD;
import org.netbeans.modules.wsdlextensions.ldap.ldif.LdifObjectClass;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;

public final class ServerBrowserVisualPanelStep3 extends JPanel {
    private Map mObjectClassMap;
    private LdifObjectClass mCurrentSearchObject;
    private LdifObjectClass mCurrentResultObject;
    
    /** Creates new form ServerBrowserVisualPanel3 */
    public ServerBrowserVisualPanelStep3() {
        initComponents();
    }
    
    public String getName() {
        return "Set Operation Properties";
    }
    
    public void read(WizardDescriptor wd) {
        mObjectClassMap = (Map) wd.getProperty("LDAP_OBJCLASS_LIST");
        this.jComboBoxObjects.removeAllItems();
        this.jComboBoxObjects1.removeAllItems();
        if (mObjectClassMap.size() > 0) {
            Iterator keys = mObjectClassMap.keySet().iterator();
            while (keys.hasNext()) {
                Object item = keys.next();
                this.jComboBoxObjects.addItem(item);
                this.jComboBoxObjects1.addItem(item);
            }
            this.jComboBoxObjects.setSelectedIndex(0);
            this.jComboBoxObjects1.setSelectedIndex(0);
        }
    }
    
    public void store(WizardDescriptor wd) {
        try {
            Project project = (Project) wd.getProperty("project");
            File dir = new File(FileUtil.toFile(project.getProjectDirectory()).getAbsolutePath() + File.separator + "src" + File.separator + "ldapwsdls");
            dir.mkdirs();
            if (mObjectClassMap != null && mObjectClassMap.size() > 0) {
                Iterator it = mObjectClassMap.values().iterator();
                while (it.hasNext()) {
                    LdifObjectClass obj = (LdifObjectClass) it.next();
                    GenerateXSD genXsd = new GenerateXSD(dir, obj, "Search");
                    GenerateWSDL genWsdl = new GenerateWSDL(dir, obj, "Search");
                    genXsd.generate();
                    genWsdl.generate();
                }
            }
            project.getProjectDirectory().refresh();
        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        jTabbedPane = new javax.swing.JTabbedPane();
        jPanel1 = new javax.swing.JPanel();
        jPanel5 = new javax.swing.JPanel();
        jComboBoxObjects = new javax.swing.JComboBox();
        jScrollPane1 = new javax.swing.JScrollPane();
        jListAttributes = new javax.swing.JList();
        jScrollPane2 = new javax.swing.JScrollPane();
        jListSelected = new javax.swing.JList();
        jButtonSelect = new javax.swing.JButton();
        jButtonUnSelect = new javax.swing.JButton();
        jPanel6 = new javax.swing.JPanel();
        jScrollPane3 = new javax.swing.JScrollPane();
        jListSelected1 = new javax.swing.JList();
        jButtonSelect1 = new javax.swing.JButton();
        jButtonUnSelect1 = new javax.swing.JButton();
        jScrollPane4 = new javax.swing.JScrollPane();
        jListAttributes1 = new javax.swing.JList();
        jComboBoxObjects1 = new javax.swing.JComboBox();
        jPanel2 = new javax.swing.JPanel();
        jPanel3 = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();

        jTabbedPane.setName(""); // NOI18N

        jPanel5.setBorder(javax.swing.BorderFactory.createTitledBorder("Search Filter"));

        jComboBoxObjects.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxObjectsActionPerformed(evt);
            }
        });

        jListAttributes.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jListAttributesValueChanged(evt);
            }
        });
        jScrollPane1.setViewportView(jListAttributes);

        jScrollPane2.setViewportView(jListSelected);

        org.openide.awt.Mnemonics.setLocalizedText(jButtonSelect, ">");
        jButtonSelect.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jButtonSelect.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSelectActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(jButtonUnSelect, "<");
        jButtonUnSelect.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jButtonUnSelect.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jButtonUnSelectMouseClicked(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel5Layout = new org.jdesktop.layout.GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(
            jPanel5Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel5Layout.createSequentialGroup()
                .addContainerGap()
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 147, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel5Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jButtonSelect)
                    .add(jButtonUnSelect))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel5Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jComboBoxObjects, 0, 154, Short.MAX_VALUE)
                    .add(jScrollPane2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 154, Short.MAX_VALUE))
                .addContainerGap())
        );
        jPanel5Layout.setVerticalGroup(
            jPanel5Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel5Layout.createSequentialGroup()
                .add(jPanel5Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel5Layout.createSequentialGroup()
                        .add(jComboBoxObjects, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 17, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(jPanel5Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jPanel5Layout.createSequentialGroup()
                                .add(29, 29, 29)
                                .add(jButtonSelect)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(jButtonUnSelect)
                                .add(12, 12, 12))
                            .add(jPanel5Layout.createSequentialGroup()
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(jScrollPane2, 0, 0, Short.MAX_VALUE))))
                    .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 102, Short.MAX_VALUE))
                .addContainerGap())
        );

        jPanel6.setBorder(javax.swing.BorderFactory.createTitledBorder("Result Set"));

        jScrollPane3.setViewportView(jListSelected1);

        org.openide.awt.Mnemonics.setLocalizedText(jButtonSelect1, ">");
        jButtonSelect1.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jButtonSelect1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSelect1ActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(jButtonUnSelect1, "<");
        jButtonUnSelect1.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jButtonUnSelect1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonUnSelect1ActionPerformed(evt);
            }
        });

        jListAttributes1.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jListAttributes1ValueChanged(evt);
            }
        });
        jScrollPane4.setViewportView(jListAttributes1);

        jComboBoxObjects1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxObjects1ActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel6Layout = new org.jdesktop.layout.GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(
            jPanel6Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel6Layout.createSequentialGroup()
                .addContainerGap()
                .add(jScrollPane4, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 147, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel6Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel6Layout.createSequentialGroup()
                        .add(jPanel6Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(jButtonSelect1)
                            .add(jButtonUnSelect1))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jScrollPane3, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 154, Short.MAX_VALUE))
                    .add(jPanel6Layout.createSequentialGroup()
                        .add(19, 19, 19)
                        .add(jComboBoxObjects1, 0, 154, Short.MAX_VALUE)))
                .addContainerGap())
        );
        jPanel6Layout.setVerticalGroup(
            jPanel6Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel6Layout.createSequentialGroup()
                .add(jPanel6Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jScrollPane4, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 101, Short.MAX_VALUE)
                    .add(jPanel6Layout.createSequentialGroup()
                        .add(jComboBoxObjects1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 17, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(jPanel6Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jPanel6Layout.createSequentialGroup()
                                .add(34, 34, 34)
                                .add(jButtonSelect1)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(jButtonUnSelect1))
                            .add(jPanel6Layout.createSequentialGroup()
                                .add(6, 6, 6)
                                .add(jScrollPane3, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 78, Short.MAX_VALUE)))))
                .addContainerGap())
        );

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel6, 0, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel5, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap(13, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel5, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel6, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );

        jTabbedPane.addTab("Search", jPanel1);

        org.jdesktop.layout.GroupLayout jPanel2Layout = new org.jdesktop.layout.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 371, Short.MAX_VALUE)
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 305, Short.MAX_VALUE)
        );

        jTabbedPane.addTab("Add", jPanel2);

        org.jdesktop.layout.GroupLayout jPanel3Layout = new org.jdesktop.layout.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 371, Short.MAX_VALUE)
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 305, Short.MAX_VALUE)
        );

        jTabbedPane.addTab("Update", jPanel3);

        org.jdesktop.layout.GroupLayout jPanel4Layout = new org.jdesktop.layout.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 371, Short.MAX_VALUE)
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 305, Short.MAX_VALUE)
        );

        jTabbedPane.addTab("Remove", jPanel4);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jTabbedPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 376, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jTabbedPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 330, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
        );
    }// </editor-fold>//GEN-END:initComponents
    
private void jButtonUnSelect1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonUnSelect1ActionPerformed
    // TODO add your handling code here:
    Object[] unselected = this.jListSelected1.getSelectedValues();//GEN-LAST:event_jButtonUnSelect1ActionPerformed
    List unselectedList = new ArrayList();
    for (int i = 0; i < unselected.length; i++) {
        unselectedList.add(unselected[i]);
    }
    List destList = new ArrayList();
    for (int i = 0; i < jListAttributes1.getModel().getSize(); i++) {
        destList.add(jListAttributes1.getModel().getElementAt(i));
    }
    List srcList = new ArrayList();
    for (int i = 0; i < jListSelected1.getModel().getSize(); i++) {
        srcList.add(jListSelected1.getModel().getElementAt(i));
    }
    
    srcList.removeAll(unselectedList);
    destList.addAll(unselectedList);
    
    mCurrentResultObject.setResultSet(srcList);
    jListAttributes1.removeAll();
    jListAttributes1.setListData(new Vector(destList));
    jListSelected1.removeAll();
    jListSelected1.setListData(new Vector(srcList));
    
}

private void jButtonSelect1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSelect1ActionPerformed
    // TODO add your handling code here:
    Object[] selected = this.jListAttributes1.getSelectedValues();//GEN-LAST:event_jButtonSelect1ActionPerformed
    List selectedList = new ArrayList();
    for (int i = 0; i < selected.length; i++) {
        selectedList.add(selected[i]);
    }
    List destList = mCurrentResultObject.getResultSet();
    List srcList = new ArrayList();
    for (int i = 0; i < jListAttributes1.getModel().getSize(); i++) {
        srcList.add(jListAttributes1.getModel().getElementAt(i));
    }
    
    srcList.removeAll(selectedList);
    if (destList == null) {
        destList = new ArrayList();
    }
    destList.addAll(selectedList);
    mCurrentResultObject.setResultSet(destList);
    jListAttributes1.removeAll();
    jListAttributes1.setListData(new Vector(srcList));
    jListSelected1.removeAll();
    jListSelected1.setListData(new Vector(destList));
}

private void jButtonSelectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSelectActionPerformed
    // TODO add your handling code here:
    Object[] selected = this.jListAttributes.getSelectedValues();//GEN-LAST:event_jButtonSelectActionPerformed
    List selectedList = new ArrayList();
    for (int i = 0; i < selected.length; i++) {
        selectedList.add(selected[i]);
    }
    List destList = mCurrentSearchObject.getSelected();
    List srcList = new ArrayList();
    for (int i = 0; i < jListAttributes.getModel().getSize(); i++) {
        srcList.add(jListAttributes.getModel().getElementAt(i));
    }
    
    srcList.removeAll(selectedList);
    if (destList == null) {
        destList = new ArrayList();
    }
    destList.addAll(selectedList);
    mCurrentSearchObject.setSelected(destList);
    jListAttributes.removeAll();
    jListAttributes.setListData(new Vector(srcList));
    jListSelected.removeAll();
    jListSelected.setListData(new Vector(destList));
    
}

private void jButtonUnSelectMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButtonUnSelectMouseClicked
    // TODO add your handling code here:
    Object[] unselected = this.jListSelected.getSelectedValues();
    List unselectedList = new ArrayList();
    for (int i = 0; i < unselected.length; i++) {
        unselectedList.add(unselected[i]);
    }
    List destList = new ArrayList();
    for (int i = 0; i < jListAttributes.getModel().getSize(); i++) {
        destList.add(jListAttributes.getModel().getElementAt(i));
    }
    List srcList = new ArrayList();
    for (int i = 0; i < jListSelected.getModel().getSize(); i++) {
        srcList.add(jListSelected.getModel().getElementAt(i));
    }
    
    srcList.removeAll(unselectedList);
    destList.addAll(unselectedList);
    
    mCurrentSearchObject.setSelected(srcList);
    jListAttributes.removeAll();
    jListAttributes.setListData(new Vector(destList));
    jListSelected.removeAll();
    jListSelected.setListData(new Vector(srcList));
    
}//GEN-LAST:event_jButtonUnSelectMouseClicked

private void jComboBoxObjects1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxObjects1ActionPerformed
    // TODO add your handling code here:
    String objName = (String) jComboBoxObjects1.getSelectedItem();//GEN-LAST:event_jComboBoxObjects1ActionPerformed
    if (objName != null && objName.length() > 0) {
        LdifObjectClass obj = (LdifObjectClass) mObjectClassMap.get(objName);
        mCurrentResultObject = obj;
        List mays = obj.getMay();
        List musts = obj.getMust();
        List selected = obj.getResultSet();
        Vector list = new Vector();
        if (musts != null) {
            for (int i = 0; i < musts.size(); i++) {
                list.add("* " + (String) musts.get(i));
            }
        }
        if (mays != null) {
            list.addAll(mays);
        }
        if (selected != null) {
            list.removeAll(selected);
        }
        this.jListAttributes1.setListData(list);
        if (selected != null) {
            this.jListSelected1.setListData(new Vector(selected));
        }
    }
}

private void jComboBoxObjectsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxObjectsActionPerformed
    // TODO add your handling code here:
    String objName = (String) jComboBoxObjects.getSelectedItem();
    if (objName != null && objName.length() > 0) {
        LdifObjectClass obj = (LdifObjectClass) mObjectClassMap.get(objName);
        if (obj != null) {
            mCurrentSearchObject = obj;
            List mays = obj.getMay();
            List musts = obj.getMust();
            List selected = obj.getSelected();
            Vector list = new Vector();
            if (musts != null) {
                for (int i = 0; i < musts.size(); i++) {
                    list.add("* " + (String) musts.get(i));
                }
            }
            if (mays != null) {
                list.addAll(mays);
            }
            if (selected != null) {
                list.removeAll(selected);
            }
            jListAttributes.setListData(list);
            
            jListSelected.removeAll();
            if (selected != null) {
                jListSelected.setListData(new Vector(selected));
            }
        }
    }
}//GEN-LAST:event_jComboBoxObjectsActionPerformed

private void jListAttributes1ValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_jListAttributes1ValueChanged
    // TODO add your handling code here:
}//GEN-LAST:event_jListAttributes1ValueChanged

private void jListAttributesValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_jListAttributesValueChanged
    // TODO add your handling code here:
}//GEN-LAST:event_jListAttributesValueChanged


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonSelect;
    private javax.swing.JButton jButtonSelect1;
    private javax.swing.JButton jButtonUnSelect;
    private javax.swing.JButton jButtonUnSelect1;
    private javax.swing.JComboBox jComboBoxObjects;
    private javax.swing.JComboBox jComboBoxObjects1;
    private javax.swing.JList jListAttributes;
    private javax.swing.JList jListAttributes1;
    private javax.swing.JList jListSelected;
    private javax.swing.JList jListSelected1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JScrollPane jScrollPane4;
    private javax.swing.JTabbedPane jTabbedPane;
    // End of variables declaration//GEN-END:variables
    
}

