/*
 * The contents of this file are subject to the terms of the Common
 * Development and Distribution License (the License). You may not use this
 * file except in compliance with the License.  You can obtain a copy of the
 * License at http://www.netbeans.org/cddl.html

 * When distributing Covered Code, include this CDDL Header Notice in each
 * file and include the License. If applicable, add the following below the
 * CDDL Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"

 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 *
 */

package org.netbeans.modules.aspect.editor.model;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/**
 * This class represents the configuration file model.
 * @author karthikeyan s
 */
public class PropertiesModel {
    
    private Element root;
    
    private Config config;
    
    private Ruleset ruleset;
    
    /** Creates a new instance of PropertiesModel */
    public PropertiesModel(Element rootNode) {
        root = rootNode;
        config = new Config();
        parse();
    }   
    
    public PropertiesModel() {
        config = new Config();
        ruleset = new Ruleset(new ArrayList<Rule>(), "myRuleSet");
    }
    
    private void parse() {        
        
        // get config objects
        NodeList configs = root.getElementsByTagName(AspectConstants.CONFIG_TAG);
        for(int i = 0; i < configs.getLength(); i++) {
            Element conf = (Element)configs.item(i);
            if(!conf.getAttribute(AspectConstants.PROPERTY_ATTR_NAME).equals("")) {
                config.setProperties(conf.getAttribute(AspectConstants.PROPERTY_ATTR_NAME),
                        conf.getAttribute(AspectConstants.PROPERTY_ATTR_VALUE));
            }
        }
        
        // get Ruleset objects
        List<Rule> rulesList = new ArrayList<Rule>();
        NodeList rules = root.getElementsByTagName(AspectConstants.RULE_TAG);
        for(int i = 0; i < rules.getLength(); i++) {
            Element rule = (Element)rules.item(i);
            rulesList.add(new Rule(rule));
        }
        ruleset = new Ruleset(rulesList, "MyRuleset");
    }
    
    public void setRuleset(Ruleset rset) {
        ruleset = rset;
    }
    
    public void setConfig(Config configObj) {
        config = configObj;
    }
    
    public void addRule(Rule rule) {
        ruleset.addRule(rule);
    }
    
    public void removeRule(Rule rule) {
        ruleset.removeRule(rule);
    }
    
    public void addProperty(String name, String value) {
        config.setProperties(name, value);
    }
    
    public void removeProperty(String name) {
        config.removeProperty(name);
    }
    
    public Ruleset getRuleset() {
        return ruleset;
    }
    
    public Config getConfig() {
        return config;
    }
    
    public String toXMLString() {
        StringBuffer xmlString = new StringBuffer();
        xmlString.append(config.toXMLString() + "\n");
        xmlString.append(ruleset.toXmlString());        
        return xmlString.toString();
    }
}