/*
 * The contents of this file are subject to the terms of the Common
 * Development and Distribution License (the License). You may not use this
 * file except in compliance with the License.  You can obtain a copy of the
 * License at http://www.netbeans.org/cddl.html

 * When distributing Covered Code, include this CDDL Header Notice in each
 * file and include the License. If applicable, add the following below the
 * CDDL Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"

 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 *
 */

package org.netbeans.modules.aspect.editor.graph;

import org.netbeans.modules.aspect.editor.graph.*;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.widget.Widget;

import org.netbeans.modules.aspect.editor.graph.panels.EditAdvicePropertiesPanel;
import org.netbeans.modules.aspect.editor.model.Advice;
import java.awt.Dialog;
import org.netbeans.modules.aspect.editor.jaxbmodel.AdviceType;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
/**
 *
 * @author karthikeyan s
 */
public class AdvicePopupProvider implements PopupMenuProvider {
    
    private AspectEditorPane owner;
    /**
     * Creates a new instance of AdvicePopupProvider
     */
    public AdvicePopupProvider(AspectEditorPane pane) {
        owner = pane;
    }
    
    public JPopupMenu getPopupMenu(final Widget widget, Point point) {
        JPopupMenu popupMenu = new JPopupMenu("NodePopup");
        JMenuItem remove = new JMenuItem("Remove Advice");
        remove.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                owner.removeAdvice(widget.getParentWidget());
            }
        });
        popupMenu.add(remove);
        JMenuItem edit = new JMenuItem("Edit Properties");
        edit.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                //Advice advice = (Advice)owner.getModelForWidget(widget.getParentWidget()); JAXB
                AdviceType advice = (AdviceType)owner.getModelForWidget(widget.getParentWidget());
                EditAdvicePropertiesPanel panel = new EditAdvicePropertiesPanel(advice);
                DialogDescriptor dd = new DialogDescriptor(panel, "Edit Advice Properties");
                Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
                dlg.setVisible(true);
                if (NotifyDescriptor.OK_OPTION.equals(dd.getValue())) {
                    owner.updateAdvice(panel.getAdvice());
                }                
            }
        });
        popupMenu.add(edit);
        return popupMenu;
    }    
}