/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */


package org.netbeans.modules.iep.editor.model;
import java.io.File;
import java.io.OutputStream;
import java.io.FileOutputStream;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.io.IOException;
import java.util.Map;
import org.openide.loaders.DataObject;


import org.netbeans.modules.iep.editor.tcg.exception.ModelSaveException;
import org.netbeans.modules.iep.editor.tcg.exception.ModelDeployException;
import org.netbeans.modules.iep.editor.tcg.exception.ParseXmlException;
import org.netbeans.modules.iep.editor.tcg.model.TcgComponent;
import org.netbeans.modules.iep.editor.tcg.model.TcgComponentDelegate;
import org.netbeans.modules.iep.editor.tcg.model.TcgProperty;
import org.netbeans.modules.iep.editor.tcg.model.TcgModelManager;
import org.netbeans.modules.iep.editor.tcg.util.GenUtil;
import java.util.Date;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;



/**
 * Interface that extends Component
 *
 * @author Bing Lu
 *
 * @since July 8, 2004
 */
class ModelImpl 
    extends TcgComponentDelegate
    implements Model 
{
    /**
     *  Logger.
     */
    private static final java.util.logging.Logger mLog = java.util.logging.Logger.getLogger(ModelImpl.class.getName());
    
    protected ModelImpl() {
    }
    
    protected ModelImpl(DataObject doc) throws ParseXmlException {
        String fullName = "";
        TcgComponent root = null;
        try {
            FileObject fo = doc.getPrimaryFile();
            mLog.info("FileObject: " + fo);
            if (fo == null) {
                return;
            }
            fullName = fo.getPath();
            root = TcgModelManager.getComponent(fullName, fo.getInputStream());
            TcgProperty docProp = root.getProperty(DOC_KEY);
            if (docProp != null) {
                docProp.setValue(doc);
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new ParseXmlException(
                "PARSE_XML_FAILED", 
                "org.netbeans.modules.iep.editor.tcg.model.Bundle",
                new Object[]{"db:model:" + fullName }, e);
        }
        initialize(root);
    }
    
    protected ModelImpl(File doc) throws ParseXmlException {
        TcgComponent root = null;
        String fullName = "";
        try {
            fullName = doc.getPath();
            root = TcgModelManager.getComponent(fullName, new FileInputStream(doc));
            TcgProperty docProp = root.getProperty(DOC_KEY);
            if (docProp != null) {
                docProp.setValue(doc);
            }
            initialize(root);
        } catch (Exception e) {
            e.printStackTrace();
            throw new ParseXmlException("TcgModelManager.PARSE_XML_FAILED", 
                                        "org.netbeans.modules.iep.editor.tcg.model.Bundle",
                                        new Object[]{"db:model:" + fullName }, e);
        }
    }
    
    public TcgComponent getComponent() {
        return mComponent;
    }
    
    public void save() throws ModelSaveException {
        String name = getFullName();
        String content = toXml();
        Object doc = getDoc();
        if (doc == null) {
            return;
        }
        if (doc instanceof DataObject) {
            try {
                DataObject dObj = (DataObject)doc;
                FileObject fo = dObj.getPrimaryFile();
                mLog.info("FileObject: " + fo);
                if (fo == null) {
                    return;
                }
                File file = FileUtil.toFile(fo);
                OutputStream os = new FileOutputStream(file);
                os.write(content.getBytes("UTF-8"));
            } catch (Exception ex) {
                ex.printStackTrace();

                throw new ModelSaveException("ModelImpl.FAIL_SAVE_MODEL", 
                                             "org.netbeans.modules.iep.editor.model.Bundle",
                                             new Object[]{name}, ex);
            }        
           
            return;
        }
        if (doc instanceof File) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream((File)doc);
                fos.write(content.getBytes("UTF-8"));
            } catch (Exception e) {
                e.printStackTrace();
                throw new ModelSaveException("ModelImpl.FAIL_SAVE_MODEL", 
                                             "org.netbeans.modules.iep.editor.model.Bundle",
                                             new Object[]{name}, e);
            } finally {
                if (fos != null) {
                    try {
                        fos.close();
                    } catch (java.io.IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }


    public void destroy() {
        try {
            setDoc(null);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setDoc(Object doc) {
        try {
            mComponent.getProperty(DOC_KEY).setValue(doc);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
        
    public Object getDoc() {
        try {
            return mComponent.getProperty(DOC_KEY).getValue();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
    
    public String getFullName() {
        try {
            Object doc = getDoc();
            if (doc instanceof DataObject) {
                return ((DataObject)doc).getPrimaryFile().getNameExt();
            }
            if (doc instanceof File) {
                return ((File)doc).getName();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }
    
    public String getFullPath() {
        try {
            Object doc = getDoc();
            if (doc instanceof DataObject) {
                return FileUtil.toFile(((DataObject)doc).getPrimaryFile()).getAbsolutePath();
            }
            if (doc instanceof File) {
                return ((File)doc).getAbsolutePath();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }
    
    public Date lastModified() {
        Object doc = getDoc();
        if (doc == null) {
            return null;
        }
        if (doc instanceof DataObject) {
            return ((DataObject)doc).getPrimaryFile().lastModified();
        }
        if (doc instanceof File) {
            return new Date(((File)doc).lastModified());
        }
        return null;
    }

}


