/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.etl.utils;

/**
 * Super class for all application exceptions. All SQL specific Exceptions will Extends
 * this Exception This Exception class will contain More methods and functionalities in
 * future.
 * 
 * @version :$Revision: 1.3 $
 * @author Sudhi Seshachala
 */
public class ETLException extends Exception {

    /**
     * Should not be called in program, just for loading purpose
     */
    public ETLException() {
    }

    /**
     * Creates a new instance of BaseException
     * 
     * @param message Message for this exception
     */
    public ETLException(String message) {
        super(message);
    }

    /**
     * Creates a new instance of BaseException
     * 
     * @param logCategory Form where this exception is thrown
     * @param message Message for this exception
     */
    public ETLException(String logCategory, String message) {
        super(logCategory + "-" + message);
    }

    /**
     * @param message message identifying this exception.
     * @param cause cause identifying this exception.
     */
    public ETLException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructor for BaseException
     * 
     * @param cause of this exception.
     */
    public ETLException(Throwable cause) {
        super(cause);
    }

    public String getMessage() {
        StringBuilder buf = new StringBuilder();
        String msg = super.getMessage();
        buf.append(msg);

        Throwable t = this;
        //we are getting only the first exception which is wrapped,
        //should we get messages from all the exceptions in the chain?
        while (t.getCause() != null) {
            t = t.getCause();
            // Prevent infinite loop if cause of t references itself.
            if (t.getCause() == t) {
                break;
            }
        }

        if (t != this) {
            buf.append(" - Root Cause: ").append(t.getMessage());
        }

        return buf.toString();
    }
}
