/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.sun.manager.jbi.management;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;

import org.netbeans.modules.sun.manager.jbi.util.BeanInfoHelper;

/**
 * BeanInfo class for JBIFrameworkService.
 *
 * @author jqian
 */
public class JBIFrameworkServiceBeanInfo extends SimpleBeanInfo {

    public PropertyDescriptor[] getPropertyDescriptors() {
        try {
//            PropertyDescriptor logLevelPD =
//                getPropertyDescriptor("LBL_LOG_LEVEL",  // NOI18N
//                        "getDefaultLogPropertyValue",   // NOI18N
//                        "setDefaultLogPropertyValue",   // NOI18N
//                        "DSC_LOG_LEVEL");               // NOI18N
            
            PropertyDescriptor classNamePD =
                getPropertyDescriptor("LBL_CLASS_NAME", // NOI18N
                        "getClassName", null,           // NOI18N
                        "DSC_CLASS_NAME");              // NOI18N
            
            PropertyDescriptor classpathPD =
                getPropertyDescriptor("LBL_CLASSPATH",  // NOI18N
                        "getClasspath", null,           // NOI18N
                        "DSC_CLASSPATH");               // NOI18N
            
            PropertyDescriptor descriptionPD =
                getPropertyDescriptor("LBL_DESCRIPTION",// NOI18N
                        "getDescription", null,         // NOI18N
                        "DSC_DESCRIPTION");             // NOI18N
            
            PropertyDescriptor loadOrderPD =
                getPropertyDescriptor("LBL_LOAD_ORDER", // NOI18N
                        "getLoadOrder", null,           // NOI18N
                        "DSC_LOAD_ORDER");              // NOI18N
            
            PropertyDescriptor namePD =
                getPropertyDescriptor("LBL_NAME",       // NOI18N
                        "getName", null,                // NOI18N
                        "DSC_NAME");                    // NOI18N
            
            PropertyDescriptor enabledPD =
                getPropertyDescriptor("LBL_ENABLED",    // NOI18N
                        "isEnabled", null,              // NOI18N
                        "DSC_ENABLED");                 // NOI18N
            
            PropertyDescriptor failureFatalPD =
                getPropertyDescriptor("LBL_FAILURE_FATAL",// NOI18N
                        "isFailureFatal", null,         // NOI18N
                        "DSC_FAILURE_FATAL");           // NOI18N
            
            PropertyDescriptor jbiFrameworkEnabledPD =
                getPropertyDescriptor("LBL_JBI_FRAMEWORK_ENABLED",// NOI18N
                        "isJbiFrameworkEnabled", null,  // NOI18N
                        "DSC_JBI_FRAMEWORK_ENABLED");   // NOI18N
            
//            logLevelPD.setBound(true);
            
            PropertyDescriptor propertyDescriptors[] = {
                    //logLevelPD, 
                    classNamePD, classpathPD, descriptionPD,
                    loadOrderPD, namePD, enabledPD, 
                    failureFatalPD, jbiFrameworkEnabledPD};
            
            return propertyDescriptors;
            
        } catch (IntrospectionException e) {
            throw new Error(e.toString());
        }
    }       
    
    private PropertyDescriptor getPropertyDescriptor(String propNameLabel,
            String getter, String setter, 
            String shortDescriptionLabel) throws IntrospectionException {
        
        return BeanInfoHelper.getPropertyDescriptor(
                JBIFrameworkService.class, 
                propNameLabel, getter, setter, shortDescriptionLabel);
    }
    
}
