/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.bpel.xpath.view.search;

import javax.swing.Icon;
import javax.swing.JTree;
import org.netbeans.modules.bpel.xpath.model.nodes.TreeNode;
import org.netbeans.modules.bpel.xpath.view.output.ResultWindow;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.ui.category.AbstractCategory;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

/**
 *
 * @author jsandusky
 */
public abstract class MapperCategory extends AbstractCategory {
    
    /** Our lookup. */
    private Lookup mLookup;

    
    public MapperCategory() {
        Object[] searchers = new Object[] {
            new MapperSearchProvider(this),
        };
        mLookup = new ProxyLookup(new Lookup[] {
            ResultWindow.getInstance().getLookup(),
            Lookups.fixed(searchers)
        });
    }
    
    public abstract JTree getSourceTree();
    
    public abstract JTree getDestionationTree();
    
    public boolean canFindInSourceTree() {
        return false;
    }
    
    public boolean canFindInDestinationTree() {
        return false;
    }
    
    public Lookup getLookup() {
        return mLookup;
    }

    public void componentHidden() {
    }

    public void componentShown() {
    }

    public String getDescription() {
        return null;
    }

    public Icon getIcon() {
        return null;
    }

    public String getTitle() {
        return null;
    }

    public void showComponent(Component comp) {
        MapperCategoryPane categoryPane = 
                ResultWindow.getInstance().
                getDesignContextChangeListener().
                getDesignContextChanger().
                getCategoryPane();
        showResultsInTree(comp, categoryPane.getSourceFindTree());
        showResultsInTree(comp, categoryPane.getDestinationFindTree());
    }
    
    public void showSourceComponent(Component comp) {
        MapperCategoryPane categoryPane = 
                ResultWindow.getInstance().
                getDesignContextChangeListener().
                getDesignContextChanger().
                getCategoryPane();
        showResultsInTree(comp, categoryPane.getSourceFindTree());
    }

    public void showDestinationComponent(Component comp) {
        MapperCategoryPane categoryPane = 
                ResultWindow.getInstance().
                getDesignContextChangeListener().
                getDesignContextChanger().
                getCategoryPane();
        showResultsInTree(comp, categoryPane.getDestinationFindTree());
    }
    
    private void showResultsInTree(Component comp, JTree tree) {
        if (tree != null) {
            NodeSearchDisplayer displayer = new NodeSearchDisplayer(tree, comp);
            TreeNode root = (TreeNode) tree.getModel().getRoot();
            root.accept(displayer);
        }
    }
}
