/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.output;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.modules.soa.ui.nodes.InstanceRef;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;

/**
 *
 * @author jsandusky
 */
public class DesignContextChangeListener 
implements PropertyChangeListener {

    private BpelEntity mCurrentEntity;
    private DesignContextChanger mDesignContextChanger;


    /** Creates a new instance of DesignContextChangeListener */
    public DesignContextChangeListener() {
        mDesignContextChanger = new DesignContextChanger();
    }
    
    
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        
        // TopComponent change.
        if (propertyName.equals(TopComponent.getRegistry().PROP_ACTIVATED)) {
            
            if (evt.getNewValue() instanceof ResultWindow) {
                // Ignore selection of the mapper window itself.
                return;
            }
            
            BpelEntity bpelEntity = getActivatedEntity();
            if (mCurrentEntity != null) {
                if (bpelEntity != null) {
                    if (mCurrentEntity.getBpelModel() != bpelEntity.getBpelModel()) {
                        // Reset the view if we changed bpel models.
                        mCurrentEntity = null;
                        mDesignContextChanger.designContextChanged(null);
                        return;
                    }
                } else {
                    mCurrentEntity = null;
                    mDesignContextChanger.designContextChanged(null);
                    return;
                }
            }
            
            // if we still have a bpel element selected we still show mapper
            if (handleActivatedBpelNode(bpelEntity)) {
                return;
            }
        }
        
        // Node change.
        else if (propertyName.equals(TopComponent.Registry.PROP_ACTIVATED_NODES)) {
            handleActivatedBpelNode(getActivatedEntity()); 
        }
    }
    
    private boolean handleActivatedBpelNode(BpelEntity bpelEntity) {
        boolean result = false;
        if (bpelEntity == null) {
            bpelEntity = mCurrentEntity;
        }
        if (bpelEntity != null) {
            mCurrentEntity = bpelEntity;
            mDesignContextChanger.designContextChanged(bpelEntity);
            result = true;
        } else {
            mCurrentEntity = null;
            mDesignContextChanger.designContextChanged(null);
        }
        return result;
    }

    private static BpelEntity getActivatedEntity() {
        BpelEntity bpelEntity = null;
        Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
        if (nodes == null || nodes.length != 1) {
            return null;
        }
        if (nodes[0] instanceof InstanceRef) {
            Object entity = ((InstanceRef) nodes[0]).getReference();
            if (entity instanceof BpelEntity) {
                bpelEntity = (BpelEntity) entity;
            }
        }
        return bpelEntity;
    }
    
    public void setSynchronizationListenerEnable(boolean isEnabled) {
        mDesignContextChanger.setSynchronizationListenerEnable(isEnabled);
    }
    
    public DesignContextChanger getDesignContextChanger() {
        return mDesignContextChanger;
    }
}
