/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.swing.JComponent;
import javax.swing.JTree;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.xpath.model.node.visitor.NodeTreePathBuilderVisitor;
import org.netbeans.modules.bpel.xpath.model.nodes.Node;
import org.netbeans.modules.bpel.xpath.model.nodes.RootPlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.TreeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XPathLocationStepNode;
import org.netbeans.modules.bpel.xpath.model.nodes.impl.AbstractTreeNode;
import org.netbeans.modules.bpel.xpath.view.AbstractExpressionView;
import org.netbeans.modules.bpel.xpath.view.PredicateMapperRule;
import org.netbeans.modules.bpel.xpath.view.expression.AbstractMapperView;
import org.netbeans.modules.bpel.xpath.view.expression.impl.BPELPredicateExpressionView;
import org.netbeans.modules.bpel.xpath.view.expression.impl.MapperView;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeView;
import org.netbeans.modules.xml.xpath.XPathPredicateExpression;
import org.openide.util.NbBundle;

/**
 *
 * @author radval
 *
 */
public class PredicateXPathExpressionView extends AbstractExpressionView {
    
    private static final Logger LOGGER = Logger.getLogger(PredicateXPathExpressionView.class.getName());
    
    private AbstractMapperView mMapperExpressionView;
    private XPathLocationStepNode mStepNode;
    private JTree mMainTree;
    
    
    public PredicateXPathExpressionView(
            XPathLocationStepNode stepNode, 
            BpelEntity contextElement, 
            BpelModel document,
            JTree tree) {
        super(document.getProcess());
        mStepNode = stepNode;
        mMainTree = tree;
        mMapperExpressionView = new BPELPredicateExpressionView(contextElement, document);
        
        PredicateMapperRule mapperRule = createMapperRule(mMapperExpressionView.getMapper());
        mMapperExpressionView.getMapper().getBasicMapper().setMapperRule(mapperRule);
    }
    
    /** @see AbstractExpressionView#getMappers()
     */
    public List<MapperView> getMappers() {
        List<MapperView> rl = new ArrayList<MapperView>();
        rl.add(mMapperExpressionView.getMapper());
        return rl;
    }
    
    public MapperView getActiveMapper() {
        return mMapperExpressionView.getMapper();
    }
    
    private void addPreExistingPredicates(TreeNode mainParent, TreeNode predParent) {
        List mainChildren = new ArrayList(mainParent.getChildren());
        int i = 0;
        for (Iterator iter=mainChildren.iterator(); iter.hasNext(); i++) {
            TreeNode mainChild = (TreeNode) iter.next();
            predParent.getChildren(); // load children before call the getChild
            TreeNode predChild = predParent.getChild(i);
            boolean doClone = false;
            // Clone only location step nodes (nodes with predicates)
            if (mainChild instanceof XPathLocationStepNode) {
                if (predChild != null) {
                    doClone = !mainChild.equals(predChild);
                } else {
                    doClone = true;
                }
            }
            if (doClone) {
                if (mStepNode != null && mainChild == mStepNode) {
                    // Do not add the predicate node we are currently editing, 
                    // because it doesn't make sense for the user to use
                    // the predicate in its own expression.
                    i--; // adjust add index
                    continue;
                }
                try {
                    // Node was not found in the predicate tree, duplicate
                    // the main tree node and remove it's mapping information.
                    TreeNode duplicateChild = mainChild.duplicate();
                    // Children has to be reloaded
                    ((AbstractTreeNode)duplicateChild).renewChildren();
                    //
                    predParent.addChild(i, duplicateChild);
                    predChild = predParent.getChild(i);
                    // Clear out mapper connections, because we are
                    // working in a different tree.
                    predChild.setMapperNode(null);
                } catch (CloneNotSupportedException e) {
                    LOGGER.log(Level.SEVERE,
                            NbBundle.getMessage(PredicateXPathExpressionView.class,
                                "STR_UNABLE_TO_CLONE_TREE_NODE_X",  // NOI18N
                                mainChild.getName()));
                }
            }
            addPreExistingPredicates(mainChild, predChild);
        }
    }
    
    public JComponent getComponent() {
        
        // In the predicates tree, we want to show pre-existing predicates,
        // so we must grab them from the main tree and copy them over to
        // our new predicate tree.
        JTree predicateSourceTree = getMapperView().getBasicMapper().
                getMapperViewManager().getSourceView().getTree();
        
        addPreExistingPredicates(
                (TreeNode) mMainTree.getModel().getRoot(),
                (TreeNode) predicateSourceTree.getModel().getRoot());
        
        if (this.mStepNode != null) {
            XPathPredicateExpression[] predicateArr = 
                    mStepNode.getLocationStep().getPredicates();
            //
            PredicateExpressionRenderer renderer = 
                    new PredicateExpressionRenderer(
                    getMapperView(), getBPELDocument().getProcess());
            //
            for (XPathPredicateExpression predicate : predicateArr) {
                renderer.draw(predicate);
            }
        }
        
        return mMapperExpressionView;
    }
    
    public PredicateMapperRule createMapperRule(MapperView bpelMapper) {
        PredicateXPathExpressionBuilder builder = new PredicateXPathExpressionBuilder(bpelMapper.getBasicMapper(), getBPELDocument().getProcess());
        PredicateXPathExpressionUpdater updater = new PredicateXPathExpressionUpdater(bpelMapper.getBasicMapper(), getBPELDocument().getProcess());
        return new PredicateMapperRule(bpelMapper, builder, updater);
    }
    
    public MapperView getMapperView() {
        return mMapperExpressionView.getMapper();
    }
    
    public boolean canFindInSourceTree() {
        return true;
    }
    
    public boolean canFindInDestinationTree() {
        return false;
    }
    
    
    class PredicateExpressionRenderer extends ExpressionRenderer {
        
        public PredicateExpressionRenderer(MapperView mapper, BpelEntity holdingEntity) {
            super(mapper, holdingEntity);
        }
        
        protected Object getLinkObject() {
            return PredicateXPathExpressionView.this.mStepNode;
        }
        
        protected IMapperTreeNode getTargetTreeNode() {
            IMapperTreeView destView = getMapper().getMapperViewManager().getDestView();
            Node targetTreeNode = null;
            RootPlaceHolderNode root = (RootPlaceHolderNode) destView.getTree().getModel().getRoot();
            targetTreeNode = root;
            List children = root.getChildren();
            Iterator it = children.iterator();
            if (it.hasNext()) {
                targetTreeNode = (Node) it.next();
            }
            
            NodeTreePathBuilderVisitor ntpBuilder = new NodeTreePathBuilderVisitor();
            targetTreeNode.accept(ntpBuilder);
            return  destView.getMapperTreeNode(ntpBuilder.getTreePath());
        }
    }
}
