/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.expression.impl;

import java.awt.BorderLayout;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.xpath.model.nodes.TreeNode;
import org.netbeans.modules.bpel.xpath.view.expression.literal.BpelLiteralHandler;
import org.netbeans.modules.bpel.xpath.view.expression.literal.BpelMapperPopupSupport;
import org.netbeans.modules.bpel.xpath.view.model.tree.BusinessProcessTreeModel;
import org.netbeans.modules.soa.mapper.common.basicmapper.BasicMapperFactory;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicController;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapper;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapperModel;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicViewManager;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicViewModel;
import org.netbeans.modules.soa.mapper.common.basicmapper.exception.MapperException;
import org.netbeans.modules.soa.mapper.common.basicmapper.palette.IPaletteView;
import org.netbeans.modules.soa.mapper.common.basicmapper.palette.IPaletteViewItem;
import org.netbeans.modules.soa.mapper.common.basicmapper.dnd.IDnDCustomizer;
import org.openide.util.NbBundle;

/**
 * 
 * @author radval
 *
 */
public class MapperView extends JPanel {
    
    /**
     * mTreeModel is the default treemodel which can be used by
     * mappers who dont have to show the bpel data
     *
     */
    private static DefaultTreeModel mTreeModel;
    
    protected final IBasicMapper mInstance;
    protected Class myClassIdentifier = null;
    boolean mCurrentStateIsAssign = false;
    private PredicatesManager mPredicatesManager;
    private BpelLiteralHandler mEditableLiteralHandler;
    private BpelModel mDocument;
    
    
    /**
     * Creates a new <code>BpelMapper</code> instance.
     *
     * @param pView the view that holds this mapper
     * @param associatedClass class with which this mapper is associated
     */
    public MapperView(BpelModel document) {
        try {
            this.mInstance = BasicMapperFactory.createBasicMapper();
        } catch (MapperException e) {
            throw new IllegalStateException(
                    NbBundle.getMessage(MapperView.class,
                        "STR_CANNOT_WORK_WITHOUT_BASIC_MAPPER"), // NOI18N 
                        e);
        }

        this.setLayout(new BorderLayout());
        this.add(this.mInstance.getVisualMapper(), BorderLayout.CENTER);
        
        this.mDocument = document;
        
        // set up the field node popup listener
        BpelMapperPopupSupport fieldNodeSupport = 
            new BpelMapperPopupSupport(
                    this, 
                    getMapperViewManager().getCanvasView().getCanvasComponent());
        getBasicMapper().getMapperViewManager().getCanvasView().getCanvas().addCanvasMouseListener(
                fieldNodeSupport);
        
        mEditableLiteralHandler = new BpelLiteralHandler(this);
        mInstance.setLiteralUpdaterFactory(mEditableLiteralHandler);

        // set the correct bundle on the palette view, otherwise our tooltips don't show
        IPaletteView paletteView = this.mInstance.getPalette();
        ResourceBundle bundle =
                ResourceBundle.getBundle("org.netbeans.modules.bpel.xpath.view.palette.Bundle");    // NOI18N
        paletteView.setBundle(bundle, getClass());
        
        this.mPredicatesManager = new PredicatesManager(this);
        
        IDnDCustomizer dndCustomizer = getDnDCustomizer();
        IBasicController controller = getBasicMapper().getMapperController();
        controller.getDestViewController().setDnDCustomizer(dndCustomizer);
        controller.getSourceViewController().setDnDCustomizer(dndCustomizer);
        
        addPeripheryPaletteComponents();
    }
    
    private void addPeripheryPaletteComponents() {
        IPaletteView paletteView = this.mInstance.getPalette();
        IPaletteViewItem autoLayoutItem = paletteView.getFactory().createAutoLayoutItem();
        paletteView.addItem(autoLayoutItem);
        IPaletteViewItem expandAllItem = paletteView.getFactory().createExpandAllNodesItem();
        paletteView.addItem(expandAllItem);
        IPaletteViewItem collapseAllItem = paletteView.getFactory().createCollapseAllNodesItem();
        paletteView.addItem(collapseAllItem);
        IPaletteViewItem deleteItem = paletteView.getFactory().createDeleteSelectedNodesItem();
        paletteView.addItem(deleteItem);
        
//        EditorModeSwitcher modeSwitcher = new EditorModeSwitcher();
//        this.mInstance.getPalette().setPeripheryComponent(
//                modeSwitcher.getComponent(),
//                BorderLayout.EAST);
    }
    
    public PredicatesManager getPredicatesManager() {
    	return this.mPredicatesManager;
    }
    
    /**
     * @return mapper instance
     */
    public IBasicMapper getBasicMapper() {
        return this.mInstance;
    }

    public BpelModel getBPELDocument() {
    	return this.mDocument;
    }
    
    /**
     * @return view manager
     */
    public IBasicViewManager getMapperViewManager() {
        return this.mInstance.getMapperViewManager();
    }

    /**
     * @return mapper model
     */
    public IBasicMapperModel getMapperModel() {
        return this.mInstance.getMapperModel();
    }

    /**
     * @return view model
     */
    public IBasicViewModel createDefaultViewModel() {
        return this.mInstance.createDefaultViewModel();
    }

    /**
     * @return palette view
     */
    public IPaletteView getPalette() {
        return this.mInstance.getPalette();
    }

    /**
     * @param pModel basic mapper model
     */
    public void setMapperModel(IBasicMapperModel pModel) {
        this.mInstance.setMapperModel(pModel);    
    }

    /**
     * @return basic mapper model
     */
    public IBasicMapperModel createDefaultMapperModel() {
        return this.mInstance.createDefaultMapperModel();
    }
    
    public BpelLiteralHandler getLiteralUpdaterFactory() {
        return mEditableLiteralHandler;
    }
    
    public void initializePredicates(BusinessProcessTreeModel treeModel) {
        if (treeModel != null) {
            treeModel.setPredicatesManager(this.mPredicatesManager);
        }
    }
   
    /**
     * getMapperIdentifier returns the class type which got registered 
     * with this mapper instance
     *
     * @return a <code>Class</code> value
     */
    public Class getMapperIdentifier() {
        return myClassIdentifier;
    }

    /**
     * static method to get the default tree model
     * returns the default treemodel which can be used by
     * mappers who dont have to show the bpel data
     *
     * @return a <code>DefaultTreeModel</code> value
     */
    public static DefaultTreeModel getDefaultTreeModel() {
        if (mTreeModel == null) {
     
            DefaultMutableTreeNode root = new
                DefaultMutableTreeNode();
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode
                ("", false);
            root.add(childNode);
            
            mTreeModel = new DefaultTreeModel(root);
        }
        return mTreeModel;
    }

    private IDnDCustomizer getDnDCustomizer() {
        return new IDnDCustomizer() {
            public boolean isMappable(TreePath path) {
                if (path != null) {
                    TreeNode treeNode = (TreeNode) path.getLastPathComponent();
                    return treeNode.isMappable();
                }
                return true;
            }
        };
    }
}
