/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view;

import javax.xml.namespace.QName;

import org.netbeans.modules.xml.xpath.AbstractXPathModelHelper;
import org.netbeans.modules.xml.xpath.XPathException;
import org.netbeans.modules.xml.xpath.XPathExpression;
import org.netbeans.modules.xml.xpath.XPathExpressionPath;
import org.netbeans.modules.xml.xpath.XPathModel;
import org.netbeans.modules.xml.xpath.XPathStringLiteral;
import org.netbeans.modules.xml.xpath.XPathVariableReference;


/**
 * @author radval
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class VariableExpressionCommand {

	private String mFullExpression;
	
	private XPathExpression mXPathExpression;
	
	private String mContainerName;
	
	private String mPartName;
	
	private String mSubQuery;
	
	public VariableExpressionCommand(String fullExpression) throws XPathException {
		this.mFullExpression = fullExpression;
		
		if(this.mFullExpression != null) {
        	XPathModel model = AbstractXPathModelHelper.getInstance().newXPathModel();
            try {
            	mXPathExpression = model.parseExpression(this.mFullExpression);
            } catch (XPathException ex) {
                ex.printStackTrace();
                throw ex;
            }
            
		}
	}
	
	public XPathExpression getXPathExpression() {
		return this.mXPathExpression;
	}
	
	public String getContainerName() {
		return this.mContainerName;
	}
	
	public String getPartName() {
		return this.mPartName;
	}
	
	public String getSubQuery() {
		return this.mSubQuery;
	}
	
	public void execute() {
	    if (this.mXPathExpression != null) {
        	boolean isDollarVariableSyntaxUsed = false;
        	
        	if(this.mXPathExpression instanceof XPathExpressionPath) {
        		XPathExpressionPath xPathExpressionPath = (XPathExpressionPath) this.mXPathExpression;
        		XPathExpression rootExpression = xPathExpressionPath.getRootExpression();
        		if(rootExpression instanceof XPathVariableReference) {
        			XPathVariableReference variable = (XPathVariableReference) rootExpression;
    			
    				isDollarVariableSyntaxUsed = true;
    				String varName = variable.getVariableName().toString();
    				int dotIndex = varName.indexOf("."); 
    				if( dotIndex != -1) {
    					this.mContainerName = varName.substring(0, dotIndex);
    					this.mPartName = varName.substring(dotIndex + 1, varName.length());
    				} else {
    					this.mContainerName = varName;
    				}
    				
    				this.mSubQuery = xPathExpressionPath.getExpressionStringExcludingRootExpression();
        			
        		}
        		
        	} else if (this.mXPathExpression instanceof XPathVariableReference) {
        		
        		XPathVariableReference variable = (XPathVariableReference) this.mXPathExpression;
        		QName variableQNameString = variable.getVariableName();
        		if(variableQNameString != null) {
	        		String variableString = variableQNameString.getLocalPart();
	        		int dotIndex = variableString.indexOf(".");
	        		if(dotIndex != -1) {
	        			this.mContainerName = variableString.substring(0, dotIndex);
	        			this.mPartName = variableString.substring(dotIndex +1 , variableString.length());
	        		}
        		}
        	}
        }
	}

}
