/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.model.nodes;

import java.awt.Color;
import java.util.List;

import javax.xml.namespace.QName;

/**
 *
 * @author radval
 *
 */
public interface TreeNode extends Node {
	
    /**
     * add a child node
     * @param child
     */
    void addChild(TreeNode child);

    /**
     * add a child node
     * @param child
     */
    void addChild(int index, TreeNode child);

    void removeChild(TreeNode child);

	/**
     * Gets the children of this node.
     * @return the children nodes, a list of Node
     */
    List getChildren();

    
    boolean isLeaf();
    
    /**
     * Gets the parent node for this node.
     *
     * @return the parent node, or null if none
     */
    TreeNode getParent();

    
    void setParent(TreeNode parent);
    
    
    TreeNode getChild(String name);
    
    QName getXSDType();
    
    TreeNode getChild(int index);
    
    TreeNode duplicate() throws CloneNotSupportedException;
    
    /**
     * Gets the list of connected model nodes to this tree node.
     * @return null if no nodes are connected
     */
    List getConnectedNodes();
    
    /**
     * Gets the list of connected model input nodes to this tree node.
     * @return null if no input nodes are connected
     */
    List getConnectedInputNodes();
    
    /**
     * Gets the list of connected model output nodes to this tree node.
     * @return null if no output nodes are connected
     */
    List getConnectedOutputNodes();
    
    /**
     * Whether this tree node is mappable.
     * A tree node that is not mappable cannot be linked to or from.
     */
    boolean isMappable();
    
    /**
     * The current highlight color, i.e. from a search.
     */
    public Color getHighlightColor();
}
