/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.model.node.visitor;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.netbeans.modules.bpel.xpath.model.nodes.Node;
import org.netbeans.modules.bpel.xpath.model.nodes.PartNode;
import org.netbeans.modules.bpel.xpath.model.nodes.TreeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.VariableNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XPathLiteralNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XPathOperatorNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XSDAttributeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XSDElementNode;
import org.netbeans.modules.bpel.xpath.model.nodes.impl.XPathOperatorNodeImpl;
import org.netbeans.modules.bpel.xpath.view.expression.impl.MapperUtil;
import org.netbeans.modules.bpel.xpath.view.expression.impl.MapperView;

import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapper;
import org.netbeans.modules.soa.mapper.common.IMapperLink;
import org.netbeans.modules.soa.mapper.common.IMapperNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.literal.ILiteralUpdater;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IField;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IFieldNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IMethoid;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IMethoidNode;

/**
 *
 * @author radval
 *
 */
public class NodeLinkCreatorVisitor extends AbstractNodeVisitor {
    
    private IBasicMapper mMapper;
    private MapperView mMapperView;
    
    
    public NodeLinkCreatorVisitor(MapperView mapperView, IBasicMapper mapper) {
        this.mMapperView = mapperView;
        this.mMapper = mapper;
    }
    
    public void visit(PartNode node) {
        visitTreeNode(node);
    }
    
    public void visit(VariableNode node) {
        visitTreeNode(node);
    }
    
    public void visit(XSDAttributeNode node) {
        visitTreeNode(node);
    }
    
    public void visit(XSDElementNode node) {
        visitTreeNode(node);
    }
    
    public void visit(XPathOperatorNode node) {
        Set<Node> inputs = new HashSet<Node>(node.getInputs());
        Iterator it = inputs.iterator();
        while (it.hasNext()) {
            Node inputNode = (Node) it.next();
            if (node instanceof XPathOperatorNode) {
                IMapperNode[] targetNodes = ((XPathOperatorNode) node)
                        .getInputFieldNodes(inputNode);
                IMapperNode sourceNode = inputNode.getOutputFieldNode(node);
                for (IMapperNode targetNode : targetNodes) {
                    addLink(sourceNode, targetNode);
                }
            } else {
                IMapperNode targetNode = node.getInputFieldNode(inputNode);
                IMapperNode sourceNode = inputNode.getOutputFieldNode(node);
                addLink(sourceNode, targetNode);
                inputNode.accept(this);
            }
            inputNode.accept(this);
        }
    }
    
    private void visitTreeNode(TreeNode node) {
    }
    
    private void addLink(IMapperNode source, IMapperNode target) {
        if(source != null && target != null) {
            if (!collapseLiteralNodes(source, target)) {
                IMapperLink link = this.mMapper.createLink(source, target);
                if(link != null) {
                    MapperUtil.createLinkWithoutMapperEvents(link, this.mMapper);
                }
            }
        }
    }
    
    private boolean collapseLiteralNodes(IMapperNode source, IMapperNode target) {
        if (source instanceof IFieldNode && target instanceof IFieldNode) {
            IFieldNode sourceFieldNode = (IFieldNode) source;
            IFieldNode targetFieldNode = (IFieldNode) target;
            IMethoidNode sourceMethoidNode = (IMethoidNode) sourceFieldNode.getGroupNode();
            IMethoid sourceMethoid = (IMethoid) sourceMethoidNode.getMethoidObject();
            if (sourceMethoid.isLiteral()) {
                transferLiteralValue(sourceFieldNode, targetFieldNode);
                // ensure we let the methoid grow if need be
                findNextAvailableInputNode((IMethoidNode) targetFieldNode.getGroupNode());
                return true;
            }
        }
        return false;
    }
    
    /**
     * Return the next disconnected input node of the specified group node, or
     * null if all the input children node is connected.
     *
     * @param node  the group node to be checked
     * @return      the next disconnected input node of the specified group
     *      node, or null if all the input children node is connected.
     */
    private IMapperNode findNextAvailableInputNode(IMethoidNode methoidNode) {
        List inputNodes = methoidNode.getInputFieldNodes();
        IFieldNode fieldNode = null;
        boolean emptySpotFound = false;
        for (Iterator iter=inputNodes.iterator(); iter.hasNext();) {
            fieldNode = (IFieldNode) iter.next();
            if (
                    fieldNode.getLinkCount() == 0 &&
                    !fieldNode.hasInPlaceLiteral()) {
                emptySpotFound = true;
                break;
            }
        }
        IMethoid methoid = (IMethoid) methoidNode.getMethoidObject();
        if (!emptySpotFound && methoid.isAccumulative()) {
            return methoidNode.getNextNewNode();
        }
        return fieldNode;
    }
    
    private void transferLiteralValue(
            IFieldNode sourceFieldNode,
            IFieldNode targetFieldNode) {
        XPathLiteralNode literal = 
                (XPathLiteralNode) MapperUtil.getMapperNodeObject(sourceFieldNode);
        targetFieldNode.setNodeObject(literal);
        IField sourceField = (IField) sourceFieldNode.getFieldObject();
        ILiteralUpdater sourceUpdater = sourceField.getLiteralUpdater();
        if (sourceUpdater != null) {
            String sourceType = sourceFieldNode.getTypeName();
            targetFieldNode.setLiteralName(
                    sourceFieldNode.getLiteralName(), 
                    mMapperView.getLiteralUpdaterFactory().createLiteralUpdater(sourceType));
        }
    }
}
