/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.bpel.properties.editors;

import org.netbeans.modules.bpel.model.api.BaseScope;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Process;
import static org.netbeans.modules.bpel.properties.PropertyType.NAME;
import org.netbeans.modules.bpel.model.api.CorrelationSet;
import org.netbeans.modules.bpel.model.api.CorrelationSetContainer;
import org.netbeans.modules.soa.ui.form.CustomNodeEditor;
import org.netbeans.modules.soa.ui.form.CustomNodeEditor.EditingMode;
import org.netbeans.modules.soa.ui.form.EditorLifeCycleAdapter;
import org.netbeans.modules.bpel.properties.editors.controls.filter.VisibilityScope;
import org.netbeans.modules.soa.ui.form.valid.DefaultValidator;
import org.netbeans.modules.bpel.editors.api.ui.valid.ErrorMessagesBundle;
import org.netbeans.modules.soa.ui.form.valid.Validator;
import org.openide.util.NbBundle;

/**
 * This panel is the main part of the Correlation Set Custom Editor.
 * It contains the properties of the Correlation Set and the table with
 * Correlation Properties which are associated with the Correlation Set.
 *
 * @author  nk160297
 */
public class CorrelationSetMainPanel extends EditorLifeCycleAdapter
        implements Validator.Provider {
    
    static final long serialVersionUID = 1L;
    
    private CustomNodeEditor<CorrelationSet> myEditor;
    private DefaultValidator myValidator;
    
    /** Creates new form EdirVariablePanel */
    public CorrelationSetMainPanel(CustomNodeEditor<CorrelationSet> anEditor) {
        myEditor = anEditor;
        createContent();
    }
    
    private void bindControls2PropertyNames() {
        fldCorrelationSetName.putClientProperty(
                CustomNodeEditor.PROPERTY_BINDER, NAME);
    }
    
    public void createContent() {
        initComponents();
        bindControls2PropertyNames();
    }
    
    public boolean applyNewValues() {
        // Return false because of the panel has child CSetPropertyTablePanel
        return false;
    }
    
    public boolean initControls() {
        // Return false because of the panel has child CSetPropertyTablePanel
        return false;
    }
    
    public boolean subscribeListeners() {
        // Return false because of the panel has child CSetPropertyTablePanel
        return false;
    }
    
    public boolean unsubscribeListeners() {
        // Return false because of the panel has child CSetPropertyTablePanel
        return false;
    }
    
    public boolean afterClose() {
        // Return false because of the panel has child CSetPropertyTablePanel
        return false;
    }
    
    public DefaultValidator getValidator() {
        if (myValidator == null) {
            myValidator = new DefaultValidator(myEditor, ErrorMessagesBundle.class) {
                
                public boolean doFastValidation() {
                    String csName = fldCorrelationSetName.getText();
                    if (csName == null || csName.length() == 0) {
                        addReasonKey("ERR_NAME_EMPTY"); //NOI18N
                    }
                    //
                    return isReasonsListEmpty();
                }
                
                public boolean doDetailedValidation() {
                    super.doDetailedValidation();
                    //
                    // Check that the variable name is unique
                    CorrelationSetContainer csc = null;
                    if (myEditor.getEditingMode() ==
                            EditingMode.CREATE_NEW_INSTANCE) {
                        VisibilityScope visScope = (VisibilityScope)myEditor.
                                getLookup().lookup(VisibilityScope.class);
                        if (visScope != null) {
                            BaseScope scope = visScope.getClosestScope();
                            csc = scope.getCorrelationSetContainer();
                        } else {
                            // If the visibility scope isn't specified 
                            // then consider the process as a owner of 
                            // the correlation set container
                            BpelModel model = (BpelModel)myEditor.getLookup().
                                    lookup(BpelModel.class);
                            if (model != null) {
                                Process process = model.getProcess();
                                if (process != null) {
                                    csc = process.getCorrelationSetContainer();
                                }
                            }
                        }
//                    } else {
// A VetoException will be thorown if the name isn't unique.
//                    }
                        //
                        if (csc != null) {
                            String csName = fldCorrelationSetName.getText();
                            CorrelationSet[] corrSetArr = csc.getCorrelationSets();
                            for (CorrelationSet corrSet : corrSetArr) {
                                if (csName.equals(corrSet.getName())){
                                    addReasonKey("ERR_NOT_UNIQUE_CORRELATION_SET_NAME"); //NOI18N
                                }
                            }
                        }
                    }
                    //
                    return isReasonsListEmpty();
                }
                
            };
        }
        return myValidator;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        lblCorrelationSetName = new javax.swing.JLabel();
        fldCorrelationSetName = new javax.swing.JTextField();
        pnlPropertiesTable = new CSetPropertyTablePanel(myEditor);

        setPreferredSize(new java.awt.Dimension(400, 200));
        getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(FormBundle.class,"ACSN_DLG_AddCorrelationSet"));
        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FormBundle.class,"ACSD_DLG_AddCorrelationSet"));
        lblCorrelationSetName.setLabelFor(fldCorrelationSetName);
        lblCorrelationSetName.setText(org.openide.util.NbBundle.getMessage(FormBundle.class, "LBL_CorrelationSetName"));
        lblCorrelationSetName.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(FormBundle.class, "LBL_CorrelationSetName"));
        lblCorrelationSetName.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FormBundle.class,"ACSD_CorrelationSetName"));

        pnlPropertiesTable.setBorder(javax.swing.BorderFactory.createTitledBorder(NbBundle.getMessage(FormBundle.class, "LBL_CorrelationSetBorderTitle")));

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, pnlPropertiesTable, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 376, Short.MAX_VALUE)
                    .add(layout.createSequentialGroup()
                        .add(lblCorrelationSetName)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(fldCorrelationSetName, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 324, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lblCorrelationSetName)
                    .add(fldCorrelationSetName, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(pnlPropertiesTable, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 157, Short.MAX_VALUE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField fldCorrelationSetName;
    private javax.swing.JLabel lblCorrelationSetName;
    private javax.swing.JPanel pnlPropertiesTable;
    // End of variables declaration//GEN-END:variables
}
