/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.design;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.netbeans.modules.bpel.design.decoration.components.LinkToolButton;
import org.netbeans.modules.bpel.design.geometry.FPoint;
import org.netbeans.modules.bpel.design.selection.DnDTool;
import org.netbeans.modules.bpel.design.selection.FlowlinkTool;
import org.netbeans.modules.bpel.model.api.BPELElementsBuilder;

import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.design.selection.GhostSelection;
import org.netbeans.modules.bpel.design.selection.PlaceHolderManager;
import org.netbeans.modules.bpel.model.api.For;
import org.netbeans.modules.bpel.model.api.ForEach;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.Pick;
import org.netbeans.modules.bpel.model.api.Receive;
import org.netbeans.modules.bpel.model.api.Sequence;
import org.netbeans.modules.bpel.model.api.Wait;
import org.netbeans.modules.bpel.model.api.events.VetoException;
import org.netbeans.modules.bpel.model.api.support.TBoolean;
import org.netbeans.modules.bpel.properties.ImportRegistrationHelper;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.bpel.nodes.actions.AddOnAlarmAction;
import org.netbeans.modules.websvc.core.WebServiceReference;
import org.openide.ErrorManager;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/**
 *
 * @author Alexey
 */


public class DnDHandler implements DragSourceListener , DragGestureListener, DropTargetListener  {
    
    
    private DesignView designView;
    private DragSource dragSource;
    private DropTarget dropTarget;
    
    private MessageFlowDataFlavor flowDataFlavor = new MessageFlowDataFlavor();
    private BpelDataFlavor bpelDataFlavor = new BpelDataFlavor();
    
    
    public DnDHandler(DesignView designView) {
        dropTarget = new DropTarget(designView, DnDConstants.ACTION_MOVE, (DropTargetListener)this, true);
        dragSource = DragSource.getDefaultDragSource();// new DragSource();
        dragSource.createDefaultDragGestureRecognizer(designView, DnDConstants.ACTION_MOVE, this);
        this.designView = designView;
    }
    
    
    public DesignView getDesignView() {
        return designView;
    }
    
    
    public void dragEnter(DragSourceDragEvent dsde) {
//      System.out.println("DragSource.dragEnter");
    }
    
    
    public void dragOver(DragSourceDragEvent dsde) {
        
        dsde.getDragSourceContext().setCursor(dragSource.DefaultMoveDrop);
    }

    
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }
    
    
    public void dragExit(DragSourceEvent dse) {
        dse.getDragSourceContext().setCursor(dragSource.DefaultMoveNoDrop);
    }

    
    public void dragDropEnd(DragSourceDropEvent dsde) {
        getGhostSelection().clear();
        getPlaceHolderManager().clear();
        getFlowLinkTool().clear();
        
//      System.out.println("DragSource.dragDropEnd");
        if (dsde.getDropAction() == DnDConstants.ACTION_MOVE) {
//            BpelEntity be = getBpelEntity(dsde.getDragSourceContext().getTransferable());
//            BpelContainer parent = (BpelContainer)be.getParent();
//            parent.remove(be);
        }
    }
    
    public void dragGestureRecognized(DragGestureEvent dge) {
//      System.out.println("DragSource.dragGestureRecognized");
        
        Object src = dge.getTriggerEvent().getSource();
        
        if (src instanceof LinkToolButton) {
            dge.startDrag(DragSource.DefaultLinkDrop,
                    new BufferedImage(1, 1, BufferedImage.TYPE_INT_ARGB),
                    new Point(0, 0),
                    new MessageFlowTransferable((LinkToolButton) src), this);
        } else {
            FPoint location = designView.convertScreenToDiagram(dge.getDragOrigin());
            Pattern clicked = designView.findPattern(dge.getDragOrigin());
            Pattern selected  = designView.getSelectionModel().getSelectedPattern();
            
            if (clicked == null) {
                return;
            }
            
            if (!clicked.isDraggable()) {
                return;
            }
            
            if (clicked == selected || clicked.isNestedIn(selected)){
                //start a move tool
                if (!getDesignView().getModel().isReadOnly()) {
                    getGhostSelection().init(selected, location);
                }
                
                
                
                dge.startDrag(DragSource.DefaultMoveDrop, 
                        new BufferedImage(1, 1, BufferedImage.TYPE_INT_ARGB),
                        new Point(0, 0),
                        new BpelTransferable(selected), this);
            }
        }
    }
    
    public void dragEnter(DropTargetDragEvent dtde) {
//      System.out.println("DropTarget.DragEnter, flavor[0] = " + dtde.getTransferable().getTransferDataFlavors()[0].getDefaultRepresentationClass());
        
        Transferable tr = dtde.getTransferable();
        
        
        if (tr.isDataFlavorSupported(flowDataFlavor)){
            FPoint p;
            try {
                LinkToolButton btn = (LinkToolButton) tr.getTransferData(flowDataFlavor);
                getFlowLinkTool().init(btn);

                if (designView.getModel().isReadOnly()) {
                    getGhostSelection().init(NbBundle.getMessage(getClass(), 
                            "LBL_ReadOnly"), designView //NOI18N
                            .convertScreenToDiagram(dtde.getLocation()));
                    dtde.rejectDrag();
                    return;
                }
                
                if (!designView.getModel().getFilters().showPartnerlinks()) {
                    getGhostSelection().init(NbBundle.getMessage(getClass(), 
                            "LBL_CanNotCreateMessageFlow"), designView //NOI18N
                            .convertScreenToDiagram(dtde.getLocation()));
                    dtde.rejectDrag();
                }
            } catch (UnsupportedFlavorException ex) {
                ex.printStackTrace();
            } catch (IOException ex) {
                ex.printStackTrace();
            }
        } else {
            BpelEntity entity = getBpelEntity(tr);
            
            if(entity == null){
                dtde.rejectDrag();
                return;
            }

            if (entity.getModel() != getDesignView().getBPELModel()) {
                dtde.rejectDrag();
                return;
            }
            
            if (designView.getModel().isReadOnly()) {
                getGhostSelection().init(NbBundle.getMessage(getClass(), 
                        "LBL_ReadOnly"), designView //NOI18N
                        .convertScreenToDiagram(dtde.getLocation()));
                dtde.rejectDrag();
                return;
            }
            
            FPoint location = designView.convertScreenToDiagram(dtde.getLocation());

            if (!designView.getModel().getFilters().showImplicitSequences() 
                && (entity instanceof Sequence))
            {
                getGhostSelection().init(NbBundle.getMessage(getClass(), 
                        "LBL_CanNotAddSequence"), location); // NOI18N
                dtde.rejectDrag();
            } else if (!designView.getModel().getFilters().showPartnerlinks() 
                && (entity instanceof PartnerLink)) 
            {
                getGhostSelection().init(NbBundle.getMessage(getClass(), 
                        "LBL_CanNotAddPartnerLink"), location); // NOI18N
                dtde.rejectDrag();
            } else {
                Pattern pattern = designView.getModel().getPattern(entity);

                if (pattern == null){
                    pattern = designView.getModel().createPattern(entity);
                    designView.getLayoutManager().layout(pattern, 0, 0);
                    location  = new FPoint(0,0);
                }

                if (getGhostSelection().isEmpty()) {
                    getGhostSelection().initCentered(pattern, location);
                }

                getPlaceHolderManager().init(pattern);

                dtde.acceptDrag(DnDConstants.ACTION_MOVE);
            }
        }
    }
    
    public void dragOver(DropTargetDragEvent dtde) {
//      System.out.println("DropTarget.DragOver");
        Transferable tr = dtde.getTransferable();
        FPoint mp = designView.convertScreenToDiagram(dtde.getLocation());
        
        boolean isValid = false;
        DnDTool tool = null;
        if (tr.isDataFlavorSupported(flowDataFlavor)) {
            tool = getFlowLinkTool();
        } else {
            if (!getGhostSelection().isEmpty()){
                tool = getPlaceHolderManager();
                getGhostSelection().move(mp);
                getGhostSelection().setEnabled(tool.isValidLocation());
                
            }
        }
        
        if (tool != null){
            tool.move(mp);
        }
        
        if (tool != null && tool.isValidLocation()) {
            dtde.acceptDrag(DnDConstants.ACTION_MOVE);
        } else {
            dtde.rejectDrag();
        }
    }
    
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }
    
    public void dragExit(DropTargetEvent dte) {
//      System.out.println("DropTarget.DragExit");
        getGhostSelection().clear();
        getPlaceHolderManager().clear();
        getFlowLinkTool().clear();
    }
    
    public void drop(final DropTargetDropEvent dtde) {
//      System.out.println("DropTarget.drop");
        
        //BpelEntity be = getBpelEntity(dtde.getTransferable());
        
        getDesignView().getTopComponent().requestActive();
        getDesignView().requestFocusInWindow();
        
        getGhostSelection().clear();
        
        final FPoint location = designView.convertScreenToDiagram(dtde.getLocation());
        
        Callable<Object> callable = null;
        if(dtde.isDataFlavorSupported(flowDataFlavor)){
            callable = new Callable<Object>(){
                
                public Object call() {
                    getFlowLinkTool().drop(location);
                    
                    return null;
                }
            };
        } else {
            callable = new Callable<Object>(){
                
                public Object call() {
                    getPlaceHolderManager().drop(location);
                    return null;
                }
            };
            
        }

        try {
            if (callable != null){
                designView.getBPELModel().invoke(callable, this);
            }
        } catch (Exception ex){
            ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, ex);
        }
        
        
        
    }
    
    
    private BpelEntity getBpelEntity(Transferable t){
        BpelEntity entity = null;
        try {
            
            for (DataFlavor flavor: t.getTransferDataFlavors()){
                Class repClass = flavor.getRepresentationClass();
                Object data = t.getTransferData(flavor);
                if (BpelNode.class.isAssignableFrom(repClass)){
                    //DnD from Diagram or Nav
                    Object ref = ((BpelNode) data).getReference();
                    if (ref instanceof BpelEntity){
                        entity = (BpelEntity)ref;
                    }
                    
                } else if (Node.class.isAssignableFrom(repClass)){
                    //DnD from palette or ProjectTree
                    entity = getPaletteItem((Node)data);
                } else if (WebServiceReference.class.isAssignableFrom(repClass)) {
                    entity = designView.getBPELModel().getBuilder().createPartnerLink();
                    entity.setCookie(DnDHandler.class, data);
                } else if (DataObject.class.isAssignableFrom(repClass)) {
                    DataObject dataObj = (DataObject) data;
                    String ext = dataObj.getPrimaryFile().getExt();
                    if (ext.compareToIgnoreCase("wsdl") == 0) { // NOI18N
                        //for WSDl first just try to create PL based on PLTS found in that WSDL
                        entity = designView.getBPELModel().getBuilder().createPartnerLink();
                        entity.setCookie(DnDHandler.class, dataObj.getPrimaryFile());
                    } else if (ext.compareToIgnoreCase("xsd") == 0) { // NOI18N
                        //For schemas just add imprt
                        entity = new ImportRegistrationHelper(designView.getBPELModel())
                        .createImport(dataObj.getPrimaryFile());
                    }
                }
                if (entity != null) {
                    break;
                }
            }
            
        } catch (UnsupportedFlavorException ufe) {
            
        } catch (IOException ioe) {
            
        }
        return entity;
    }
    
    
    class MessageFlowDataFlavor extends DataFlavor{
        private static final long serialVersionUID = 1;
        
        public MessageFlowDataFlavor(){
            super(FlowlinkTool.class, "Message flow link"); // NOI18N
        }
    }
    class MessageFlowTransferable implements Transferable{
        
        private LinkToolButton button;
        
        public MessageFlowTransferable(LinkToolButton button){
            this.button = button;
        }
        
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{flowDataFlavor};
        }
        
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return (flavor.getRepresentationClass() == FlowlinkTool.class);
        }
        
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!isDataFlavorSupported(flavor))
                throw new UnsupportedFlavorException(flavor);
            
            return button;
        }
        
    }
    
    
    class BpelDataFlavor extends DataFlavor{
        private static final long serialVersionUID = 1;
        
        public BpelDataFlavor(){
            super(BpelNode.class, "Bpel element"); // NOI18N
        }
    }
    
    
    class BpelTransferable implements Transferable{
        
        private BpelNode draggedNode;
        public BpelTransferable(BpelNode draggedNode){
            this.draggedNode = draggedNode;
        }
        public BpelTransferable(Pattern pattern){
            BpelEntity omRef = pattern.getOMReference();
            assert omRef != null;
            
            this.draggedNode = (BpelNode)designView.getNodeForPattern(pattern);
            
        }
        
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{bpelDataFlavor};
        }
        
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return (flavor.getRepresentationClass() == BpelNode.class);
        }
        
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!isDataFlavorSupported(flavor))
                throw new UnsupportedFlavorException(flavor);
            
            return draggedNode;
        }
        
    }
    private GhostSelection getGhostSelection(){
        return designView.getGhost();
    }
    private PlaceHolderManager getPlaceHolderManager(){
        return designView.getPlaceHolderManager();
    }
    
    private BpelEntity getPaletteItem(Node data){
        // assuming to be item from palette
        String item = data.getName();
        int k = item.indexOf("_"); // NOI18N
        
        if (k != -1) {
            item = item.substring(0, k);
        }
        BPELElementsBuilder builder = designView.getBPELModel().getBuilder();
        
        if (item.equals("reply")) { // NOI18N
            return builder.createReply();
        } else if (item.equals("invoke")) { // NOI18N
            return builder.createInvoke();
        } else if (item.equals("receive")) { // NOI18N
            
            Receive rcv = builder.createReceive();
            //indicator that object is being DnD from pallete. 
            //Diagram may use this value to set CreateInstance attribute
            rcv.setCookie(DnDHandler.class, DnDHandler.class); 
            return rcv;
        } else if (item.equals("pick")) { // NOI18N
            Pick p = builder.createPick();
            p.addOnMessage(builder.createOnMessage());
            return p;
        } else if (item.equals("assign")) { // NOI18N
            return builder.createAssign();
        } else if (item.equals("sequence")) { // NOI18N
            return builder.createSequence();
        } else if (item.equals("flow")) { // NOI18N
            return builder.createFlow();
        } else if (item.equals("while")) { // NOI18N
            return builder.createWhile();
        } else if (item.equals("repeatuntil")) { // NOI18N
            return builder.createRepeatUntil();
        } else if (item.equals("foreach")) { // NOI18N
            ForEach fe = builder.createForEach();
            fe.setParallel(TBoolean.NO);
            return fe;
        } else if (item.equals("scope")) { // NOI18N
            return builder.createScope();
        } else if (item.equals("if")) { // NOI18N
            return builder.createIf();
        } else if (item.equals("wait")) { // NOI18N
            Wait w = builder.createWait();
            For f = builder.createFor();
            try {
                f.setContent(AddOnAlarmAction.DEFAULT_FOR_VALUE); //NOI18N
            } catch(VetoException ex){
                ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, ex);
            }
            w.setTimeEvent(f);
            return w;
        } else if (item.equals("exit")) { // NOI18N
            return builder.createExit();
        } else if (item.equals("throw")) { // NOI18N
            return builder.createThrow();
        } else if (item.equals("compensate")) { // NOI18N
            return builder.createCompensate();
        } else if (item.equals("empty")) { // NOI18N
            return builder.createEmpty();
        } else if (item.equals("partner")) { // NOI18N
            return builder.createPartnerLink();
        } else if (item.equals("exit")) { // NOI18N
            return builder.createExit();
        } else {
            //System.out.println("Warning: can't recognize dragged item: " + item); // NOI18N
        }
        return null;
    }
    
    public FlowlinkTool getFlowLinkTool() {
        return designView.getFlowLinkTool();
    }
}
