/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.debugger.ui.variable;

import java.util.Vector;
import org.netbeans.modules.bpel.debugger.api.variables.NamedValueHost;
import org.netbeans.modules.bpel.debugger.api.variables.SimpleValue;
import org.netbeans.modules.bpel.debugger.api.variables.SimpleVariable;
import org.netbeans.modules.bpel.debugger.api.variables.Value;
import org.netbeans.modules.bpel.debugger.api.variables.WsdlMessageValue;
import org.netbeans.modules.bpel.debugger.api.variables.WsdlMessageVariable;
import org.netbeans.modules.bpel.debugger.api.variables.XmlElementValue;
import org.netbeans.modules.bpel.debugger.api.variables.XmlElementVariable;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 *
 * @author Alexander Zgursky
 */
public class HelperViewModel implements NodeModel, TableModel, Constants {
    
    private static final String ICONS_ROOT =
            "org/netbeans/modules/bpel/debugger/ui/resources/image/variables/";
    
    private static final String DEFAULT_NODE_ICON =
            ICONS_ROOT + "DEFAULT_NODE";
    
    private static final String ELEMENT_NODE_ICON =
            ICONS_ROOT + "ELEMENT_NODE";
            
    private static final String ATTRIBUTE_NODE_ICON =
            ICONS_ROOT + "ATTRIBUTE_NODE";
    
    private static final String TEXT_NODE_ICON =
            ICONS_ROOT + "TEXT_NODE";
    
    private static final String CDATA_NODE_ICON =
            ICONS_ROOT + "CDATA_NODE";
    
    
    private Vector myListeners = new Vector();
    
    /** Creates a new instance of ValueViewModel */
    public HelperViewModel() {
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object instanceof Node) {
            return ((Node)object).getNodeName();
        } else if (object instanceof Value) {
            //Value is not supposed to get here, but...
            return NbBundle.getMessage(
                HelperViewModel.class, "CTL_Anonymous_Value_Node"); // NOI18N
        } else {
            throw new UnknownTypeException(object);
        }
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
//        if (object instanceof Node) {
//            return XmlElementValue.Helper.xpath((Node)object);
//        } else {
            return getDisplayName(object);
//        }
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if (object instanceof Node) {
            Node node = (Node)object;
            switch (node.getNodeType()) {
                case Node.ELEMENT_NODE : return ELEMENT_NODE_ICON;
                case Node.ATTRIBUTE_NODE : return ATTRIBUTE_NODE_ICON;
                case Node.TEXT_NODE : return TEXT_NODE_ICON;
                case Node.CDATA_SECTION_NODE : return CDATA_NODE_ICON;
                default : return DEFAULT_NODE_ICON;
            }
        } else if (object instanceof Value) {
            //Value is not supposed to get here, but...
            return DEFAULT_NODE_ICON;
        } else {
            throw new UnknownTypeException(object);
        }
    }

    public void addModelListener(ModelListener l) {
        myListeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        myListeners.remove(l);
    }

    public Object getValueAt(Object object, String column) throws UnknownTypeException {
        if (object instanceof Node) {
            if (column.equals(LOCALS_VALUE_COLUMN_ID)) {
                return valueField((Node)object);
            }
        } else if (object instanceof Value) {
            if (column.equals(LOCALS_VALUE_COLUMN_ID)) {
                return valueField((Value)object);
            }
        }
        
        throw new UnknownTypeException(object);
    }

    public void setValueAt(Object object, String column, Object value) throws UnknownTypeException {
        if (object instanceof Node) {
            if (column.equals(LOCALS_VALUE_COLUMN_ID)) {
                Node node = (Node)object;
                if (node.getNodeType() == Node.ATTRIBUTE_NODE) {
                    setNodeValue(node, (String)value);
                } else if (node.getNodeType() == Node.ELEMENT_NODE) {
                    setNodeValue(node.getChildNodes().item(0), (String)value);
                }
            }
            return;
        } else if (object instanceof Value) {
            if (column.equals(LOCALS_VALUE_COLUMN_ID)) {
                if (object instanceof SimpleValue) {
                    setSimpleValue((SimpleValue)object, (String)value);
                }
            }
            return;
        }
        
        throw new UnknownTypeException(object);
    }
    
    public boolean isReadOnly(Object object, String column) throws UnknownTypeException {
        if (object instanceof Node) {
            Node node = (Node)object;
            if (column.equals(LOCALS_VALUE_COLUMN_ID)) {
                if (node.getNodeType() == Node.ATTRIBUTE_NODE) {
                    if (!(node.getNodeName().equals("xmlns") ||
                          node.getNodeName().equals("targetNamespace") ||
                          node.getNodeName().startsWith("xmlns:")))
                    {
                        return false;
                    }
                } else if (node.getNodeType() == Node.ELEMENT_NODE) {
                    NodeList children = node.getChildNodes();
                    if (    children.getLength() == 1 &&
                            children.item(0).getNodeType() == Node.TEXT_NODE)
                    {
                        return false;
                    }
                }
            }
            return true;
        } else if (object instanceof Value) {
            if (column.equals(LOCALS_VALUE_COLUMN_ID)) {
                if (object instanceof SimpleValue) {
                    return false;
                }
            }
            return true;
        }
        
        throw new UnknownTypeException(object);
    }
    
    private Object valueField(Node node) {
        if (node.getNodeType() == Node.ELEMENT_NODE) {
            NodeList children = node.getChildNodes();
            if (    children.getLength() == 1 &&
                    children.item(0).getNodeType() == Node.TEXT_NODE)
            {
                return children.item(0).getNodeValue();
            } else {
                return node;
            }
        } else {
            return node.getNodeValue() != null ? node.getNodeValue() : "";
        }
    }

    private Object valueField(Value value) throws UnknownTypeException {
        if (value instanceof SimpleValue) {
            return ((SimpleValue)value).getValueAsString();
        } else if (value instanceof XmlElementValue) {
            return getValueAt(
                    ((XmlElementValue)value).getElement(),
                    LOCALS_VALUE_COLUMN_ID);
        } else if (value instanceof WsdlMessageValue) {
            WsdlMessageValue message = (WsdlMessageValue)value;
            int partsCnt = message.getParts().length;
            return NbBundle.getMessage(
                HelperViewModel.class, "CTL_Message_Value_Node", partsCnt); // NOI18N
        } else {
            return "";
        }
    }
    
    private void setNodeValue(Node node, String text) {
        XmlElementValue xmlValue = XmlElementValue.Helper.find(node);
        NamedValueHost valueHost = xmlValue.getValueHost();
        if (valueHost instanceof XmlElementVariable) {
            ((XmlElementVariable)valueHost).setNodeValue(node, text);
            fireTableValueChanged(node, LOCALS_VALUE_COLUMN_ID);
            return;
        } else if (valueHost instanceof WsdlMessageValue.Part) {
            WsdlMessageValue.Part part = (WsdlMessageValue.Part)valueHost;
            NamedValueHost messageValueHost = part.getMessage().getValueHost();
            if (messageValueHost instanceof WsdlMessageVariable) {
                ((WsdlMessageVariable)messageValueHost).setPartNodeValue(part, node, text);
                fireTableValueChanged(node, LOCALS_VALUE_COLUMN_ID);
                return;
            }
        }
    }
   
    private void setSimpleValue(SimpleValue value, String text) {
        NamedValueHost valueHost = value.getValueHost();
        if (valueHost instanceof SimpleVariable) {
            ((SimpleVariable)valueHost).setValue(text);
            fireTableValueChanged(valueHost, LOCALS_VALUE_COLUMN_ID);
            return;
        } else if (valueHost instanceof WsdlMessageValue.Part) {
            WsdlMessageValue.Part part = (WsdlMessageValue.Part)valueHost;
            NamedValueHost messageValueHost = part.getMessage().getValueHost();
            if (messageValueHost instanceof WsdlMessageVariable) {
                ((WsdlMessageVariable)messageValueHost).setPartSimpleValue(part, text);
                fireTableValueChanged(valueHost, LOCALS_VALUE_COLUMN_ID);
                return;
            }
        }
    }
    
    //TODO:this is neither an effecient nor right way to notify about variable
    //change. Need to fire event on the BpelDebugger level and subscribe tree
    //model to listen for "variable changed" events. With this approach 
    //WatchesTreeModel can subscribe as well
    void fireTableValueChanged(Object node, String propertyName) {
        Vector v = (Vector) myListeners.clone();
        int i, k = v.size();
        for (i = 0; i < k; i++)
            ((ModelListener) v.get(i)).modelChanged(new ModelEvent.TreeChanged(this));
    }
    
}
