/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.debugger.ui.variable;

import java.beans.PropertyEditor;
import org.openide.util.NbBundle;
import org.netbeans.api.debugger.Properties;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.debugger.ui.Constants;

/**
 * @author Vladimir Yaroslavskiy
 * @version 2005.11.30
 */
public final class BpelVariableColumn {

    private BpelVariableColumn () {}

    private static class AbstractColumn extends ColumnModel {

        public AbstractColumn(
            String id,
            String name,
            String tooltip,
            Class type)
        {
            myId = id;
            myName = name;
            myTooltip = tooltip;
            myType = type;
            myProperties = Properties.getDefault().
                getProperties("debugger").getProperties("views"); // NOI18N
        }
        
        public String getID() {
            return myId;
        }

        public String getDisplayName() {
            return getMessage(myName);
        }

        public String getShortDescription() {
            return getMessage(myTooltip);
        }
        
        public String getMessage(String value) {
            if (value == null) {
              return null;
            }
            return NbBundle.getMessage (BpelVariableColumn.class, value);
        }

        public Class getType() {
            return myType;
        }
        
        public int getCurrentOrderNumber () {
            return myProperties.getInt (getId(ORDER_NUMBER), -1);
        }

        public void setCurrentOrderNumber (int orderNumber) {
            myProperties.setInt (getId(ORDER_NUMBER), orderNumber);
        }

        public int getColumnWidth () {
            return myProperties.getInt (getId(COLUMN_WIDTH), WIDTH);
        }

        public void setColumnWidth (int columnWidth) {
            myProperties.setInt (getId(COLUMN_WIDTH), columnWidth);
        }

        public void setVisible (boolean visible) {
            myProperties.setBoolean (getId(VISIBLE), visible);
        }

        public boolean isVisible () {
            return myProperties.getBoolean (getId(VISIBLE), true);
        }

        public void setSorted (boolean sorted) {
            myProperties.setBoolean (getId(SORTED), sorted);
        }

        public boolean isSorted () {
            return myProperties.getBoolean (getId(SORTED), false);
        }

        public void setSortedDescending (boolean sortedDescending) {
            myProperties.setBoolean (getId(DESCENDING), sortedDescending);
        }
    
        public boolean isSortedDescending () {
            return myProperties.getBoolean (getId(DESCENDING), false);
        }

        private String getId(String value) {
            return getID() + "." + value; // NOI18N
        }

        private String myId;
        private String myName;
        private String myTooltip;
        private Class myType;
        private Properties myProperties;
        private static final int WIDTH = 150;
        private static final String SORTED = "sorted"; // NOI18N
        private static final String DESCENDING = "sortedDescending"; // NOI18N
        private static final String VISIBLE = "visible"; // NOI18N
        private static final String COLUMN_WIDTH = "columnWidth"; // NOI18N
        private static final String ORDER_NUMBER = "currentOrderNumber"; // NOI18N
    }
    
    /**{@inheritDoc}*/
    public static ColumnModel createVariableNameColumn() {
        return new AbstractColumn(
            "DefaultLocalsColumn", // NOI18N
            "CTL_Variable_Column_Name", // NOI18N
            "CTL_Variable_Column_Name_Tooltip", // NOI18N
            null);
    }

    /**{@inheritDoc}*/
    public static ColumnModel createVariableValueColumn() {
        return new AbstractColumn(
            Constants.LOCALS_VALUE_COLUMN_ID,
            "CTL_Variable_Column_Value", // NOI18N
            "CTL_Variable_Column_Value_Tooltip", // NOI18N
            Object.class)
        {
            public PropertyEditor getPropertyEditor() {
                return new BpelVariablePropertyEditor();
            }
        };

    }
    
//    public static ColumnModel createVariableTypeColumn() {
//        return new AbstractColumn(
//            Constants.LOCALS_TYPE_COLUMN_ID,
//            "CTL_Variable_Column_Type", // NOI18N
//            "CTL_Variable_Column_Type_Tooltip", // NOI18N
//            String.class);
//    }
//    
//    public static ColumnModel createVariableToStringColumn() {
//        return new AbstractColumn(
//            Constants.LOCALS_TO_STRING_COLUMN_ID,
//            "CTL_Variable_Column_To_String", // NOI18N
//            "CTL_Variable_Column_To_String_Tooltip", // NOI18N
//            String.class);
//    }
    
}
