/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.debugger.spi.plugin.event;

import org.netbeans.modules.bpel.debugger.spi.plugin.request.EventRequest;

/**
 * An occurrence in a target BPEL Engine that is of interest to a debugger.
 * Event is the common superinterface for all events (examples include
 * {@link org.netbeans.modules.bpel.debugger.spi.plugin.event.BreakpointReachedEvent},
 * {@link org.netbeans.modules.bpel.debugger.spi.plugin.event.ProcessInstanceCreatedEvent}).
 * When an event occurs, an instance of Event as a component of an
 * {@link org.netbeans.modules.bpel.debugger.spi.plugin.event.EventSet}
 * is enqueued in the
 * {@link org.netbeans.modules.bpel.debugger.spi.plugin.BpelEngine}'s
 * {@link org.netbeans.modules.bpel.debugger.spi.plugin.event.EventQueue}.
 * 
 * @author Alexander Zgursky
 */
public interface Event {
    /**
     * Returns the event request that requested this event.
     *
     * @return the event request that requested this event. Some events (e.g.
     *  {@link org.netbeans.modules.bpel.debugger.spi.plugin.event.BpelEngineDisconnectedEvent})
     *  may not have a coresponding request and thus will return <code>null</code>.
     */
    EventRequest getEventRequest();
}
