/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.model.impl;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.Documentation;
import org.netbeans.modules.bpel.model.api.ExtensibleElements;
import org.netbeans.modules.bpel.model.api.events.VetoException;
import org.netbeans.modules.bpel.model.xam.BpelElements;
import org.netbeans.modules.bpel.model.xam.BpelTypesEnum;
import org.netbeans.modules.xml.xam.dom.Attribute;
import org.w3c.dom.Element;

/**
 * @author ads
 */
public abstract class ExtensibleElementsImpl extends BpelContainerImpl implements ExtensibleElements {

    ExtensibleElementsImpl( BpelModelImpl model, Element e ) {
        super(model, e);
    }

    ExtensibleElementsImpl( BpelBuilderImpl builder, String tagName ) {
        super(builder, tagName);
    }

    public String getDocumentation() {
      Documentation [] documentations = getDocumentations();

      if (documentations == null || documentations.length == 0) {
        return null;
      }
      Documentation documentation = documentations[0];
      
      if (documentation == null) {
        return null;
      }
      String content = documentation.getContent();

      if (content == null) {
        return null;
      }
      content = content.trim();

      if (content.length() == 0) {
        return null;
      }
      return content;
    }

    public void setDocumentation(String content) throws VetoException {
      Documentation documentation = getBpelModel().getBuilder().createDocumentation();
      documentation.setContent(content);

      if (sizeOfDocumentations() > 0) {
        if (content == null || content.trim().length() == 0) {
          removeDocumentation(0);
        }
        else {
          setDocumentation(documentation, 0);
        }
      }
      else {
        insertDocumentation(documentation, 0);
      }
    }

    public void addDocumentation(Documentation documentation) {
        addChildAfter(documentation, Documentation.class, BpelTypesEnum.DOCUMENTATION);
    }

    public Documentation getDocumentation( int i ) {
        return getChild( Documentation.class , i );
    }

    public Documentation[] getDocumentations() {
        readLock();
        try {
            List<Documentation> list = getChildren( Documentation.class );
            return list.toArray( new Documentation[list.size()] );
        }
        finally {
            readUnlock();
        }
    }

    public void insertDocumentation( Documentation documentation, int i ) {
        insertAtIndexAfter( documentation , Documentation.class , i , 
                BpelTypesEnum.DOCUMENTATION );
    }

    public void removeDocumentation( int i ) {
        removeChild( Documentation.class , i );
    }

    public void setDocumentation( Documentation documentation, int i ) {
        setChildAtIndex( documentation , Documentation.class , i );
    }

    public void setDocumentations( Documentation[] documentations ) {
        setArrayAfter( documentations , Documentation.class , 
                BpelTypesEnum.DOCUMENTATION);
    }

    public int sizeOfDocumentations() {
        readLock();
        try {
            return getChildren( Documentation.class ).size();
        }
        finally {
            readUnlock();
        }
    }
    
    /* (non-Javadoc)
     * @see org.netbeans.modules.soa.model.bpel20.impl.BpelContainerImpl#create(org.w3c.dom.Element)
     */
    @Override
    protected BpelEntity create( Element element )
    {
        if ( BpelElements.DOCUMENTATION.getName().equals( element.getLocalName()) ){
            return new DocumentationImpl( getModel() , element );
        }
        return null;
    }
    
    /* (non-Javadoc)
     * @see org.netbeans.modules.soa.model.bpel20.impl.BpelEntityImpl#getDomainAttributes()
     */
    protected Attribute[] getDomainAttributes() {
        // TODO : common framework for accesing to extension attributes ? 
        if ( myAttributes.get() == null ){
            Attribute[] ret = new Attribute[0];
            myAttributes.compareAndSet(null, ret);
        }
        return myAttributes.get();
    }
    
    private static AtomicReference<Attribute[]> myAttributes = 
        new AtomicReference<Attribute[]>();
}
