/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.model.impl;

import java.util.Iterator;

import org.netbeans.modules.bpel.model.api.BpelContainer;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.Process;

/**
 * @author ads
 */
public class ContainerIterator<E extends BpelContainer> implements Iterator<E> {

    public ContainerIterator( BpelEntity entity, Class<E> clazz ) {
        ((BpelEntityImpl) entity).checkDeleted();
        isInTree = ((BpelEntityImpl) entity).isInTree();
        myObject = entity;
        next = null;
        myClass = clazz;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.util.Iterator#hasNext()
     */
    public boolean hasNext() {
        if (!isInTree) {
            return false;
        }

        if (myObject == null) {
            return false;
        }
        
        /*
         * When myObject itself is needed container 
         * then we need to return true.
         * This code should be called only at first time - when myObject is start activity.
         * Otherwise if next is null then myObject should be set to null in method "next()".
         */
        if (myClass.isInstance(myObject)) {
            if (next == null) {
                /*if (myObject instanceof Process) {
                    return false;
                }*/
                next = myClass.cast(myObject);
                return true;
            }
        }
        if (next != null) {
            return true;
        }

        return goToNext();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.util.Iterator#next()
     */
    public E next() {
        if (!isInTree) {
            return null;
        }

        if (myObject == null) {
            return null;
        }

        // This will be called only when start entity has itself needed container class.
        if (next == null) {
            goToNext();
            if (myClass.isInstance(myObject)) {
                BpelEntity ret = myObject;
                /* if myObject is itself needed container class and next is null,
                 * then we empty myObject for avoiding putting "myObject" into next in "hasNext()" method. 
                 */
                if ( next == null ){
                    myObject = null;
                }
                return myClass.cast(ret);
            }
        }

        myObject = (BpelEntity) next;
        // in the case when we reach root of tree we should empty myObject.
        if (myObject instanceof Process) {
            myObject = null;
            return myClass.cast(next);
        }

        if (myObject != null) {
            goToNext();
            BpelEntity ret = myObject;
            /* if myObject is itself needed container class and next is null,
             * then we empty myObject for avoiding putting "myObject" into next in "hasNext()" method. 
             */
            if ( next == null ){
                myObject = null;
            }
            return myClass.cast(ret);
        }
        else {
            return null;
        }
    }

    private boolean goToNext() {
        ((BpelEntityImpl) myObject).readLock();
        try {
            BpelEntityImpl temp = (BpelEntityImpl) myObject;
            while (!((next = (BpelContainer)temp.getParent()) == null)) {
                if (myClass.isInstance(next)) {
                    return true;
                }
                temp = (BpelEntityImpl) next;
            }
            return false;
        }
        finally {
            ((BpelEntityImpl) myObject).readUnlock();
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.util.Iterator#remove()
     */
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private BpelEntity myObject;

    private BpelContainer next;

    private Class<E> myClass;

    private boolean isInTree;
}
