/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.model.api;

import org.netbeans.modules.bpel.model.api.support.TBoolean;

public interface BaseScope extends ActivityHolder, JoinFailureSuppressor ,
    VariableDeclarationScope
{

    /**
     * exitOnStandardFault attribute name.
     */
    String EXIT_ON_STANDART_FAULT = "exitOnStandardFault"; // NOI18N

    /**
     * Gets the value of the variables property.
     *
     * @return possible object is {@link VariableContainer }
     */
    VariableContainer getVariableContainer();

    /**
     * Sets the value of the variables property.
     * 
     * @param value
     *            allowed object is {@link VariableContainer }
     */
    void setVariableContainer( VariableContainer value );

    /**
     * Gets the value of the correlationSets property.
     * 
     * @return possible object is {@link CorrelationSetContainer }
     */
    CorrelationSetContainer getCorrelationSetContainer();

    /**
     * Sets the value of the correlationSets property.
     * 
     * @param value
     *            allowed object is {@link CorrelationSetContainer }
     */
    void setCorrelationSetContainer( CorrelationSetContainer value );

    /**
     * Gets the value of the faultHandlers property.
     * 
     * @return possible object is {@link FaultHandlers }
     */
    FaultHandlers getFaultHandlers();

    /**
     * Sets the value of the faultHandlers property.
     * 
     * @param value
     *            allowed object is {@link FaultHandlers }
     */
    void setFaultHandlers( FaultHandlers value );

    /**
     * Gets the value of the eventHandlers property.
     * 
     * @return possible object is {@link EventHandlers }
     */
    EventHandlers getEventHandlers();

    /**
     * Sets the value of the eventHandlers property.
     * 
     * @param value
     *            allowed object is {@link EventHandlers }
     */
    void setEventHandlers( EventHandlers value );

    /**
     * Removes VariableContainer element from this entity.
     */
    void removeVariableContainer();

    /**
     * Removes FaultHandlers element from this entity.
     */
    void removeFaultHandlers();

    /**
     * Removes EventHandlers element from this entity.
     */
    void removeEventHandlers();

    /**
     * Removes CorrelationSetContainer element from this entity.
     */
    void removeCorrelationSetContainer();

    /**
     * Setter for attribute exitOnStandardFault.
     * 
     * @param value
     *            TBoolean value for attribute.
     */
    void setExitOnStandardFault( TBoolean value );

    /**
     * Getter for attribute exitOnStandardFault.
     * 
     * @return "exitOnStandardFault" attribute value.
     */
    TBoolean getExitOnStandardFault();

    /**
     * Removes attribute exitOnStandardFault.
     */
    void removeExitOnStandardFault();

    /**
     * Gets the value of the partnerLinks property.
     * 
     * @return possible object is {@link PartnerLinkContainer }
     */
    PartnerLinkContainer getPartnerLinkContainer();

    /**
     * Sets the value of the partnerLinks property.
     * 
     * @param value
     *            allowed object is {@link PartnerLinkContainer }
     */
    void setPartnerLinkContainer( PartnerLinkContainer value );

    /**
     * Removes partnerLinks.
     */
    void removePartnerLinkContainer();
    
    /**
     * Set the new MessageExchangeContainer child.
     * @param container New MessageExchangeContainer child.
     */
    void setMessageExchangeContainer( MessageExchangeContainer container );
    
    /**
     * @return MessageExchangeContainer child.
     */
    MessageExchangeContainer getMessageExchangeContainer();
    
    /**
     * Removes MessageExchangeContainer child.
     */
    void removeMessageExchangeContainer();

}
