/*
* Copyright 2005 Sun Microsystems, Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* - Redistributions of source code must retain the above copyright
*   notice, this list of conditions and the following disclaimer.
*
* - Redistribution in binary form must reproduce the above copyright
*   notice, this list of conditions and the following disclaimer in
*   the documentation and/or other materials provided with the
*   distribution.
*
* Neither the name of Sun Microsystems, Inc. or the names of
* contributors may be used to endorse or promote products derived
* from this software without specific prior written permission.
*
* This software is provided "AS IS," without a warranty of any
* kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
* WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
* EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
* SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN
* OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR
* FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
* PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
* LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE,
* EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*
* You acknowledge that Software is not designed, licensed or intended
* for use in the design, construction, operation or maintenance of
* any nuclear facility.
*/

package com.sun.j2ee.blueprints.opc.crm.ejb;

import java.util.*;
import javax.ejb.*;
import javax.naming.*;
import javax.jms.*;
import java.io.*;
import org.w3c.dom.*;
import org.xml.sax.*;
import javax.xml.parsers.*;
import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.stream.StreamResult;

import com.sun.j2ee.blueprints.opc.mailer.*;

/**
 * MailCompletedOrderMDB receives a JMS message containing an Order
 * xml message for orders that are COMPLETELY shipped. It builds a mail
 * message that it then sends to the mailer service so that
 * the customer gets email
 */
public class CrmBean implements MessageDrivenBean, MessageListener {
    
  private Context context;
  private MessageDrivenContext mdc;

  public CrmBean() {
  }

  public void ejbCreate() {
  }

  /**
   * Receive a JMS Message containing the Order that is completed,
   * generate Mail xml messages for the customer
   * The Mail xml mesages contain html presentation
   */
  public void onMessage(Message recvMsg) {
    TextMessage recdTM = null;
    String recdText = null;
    String result = null;

    try {
      recdTM = (TextMessage)recvMsg;
      recdText = recdTM.getText();
      result = doWork(recdText);
    } catch  (JMSException je) {
      throw new EJBException(je);
    }
  }

  public void setMessageDrivenContext(MessageDrivenContext mdc) {
    this.mdc = mdc;
  }

  public void ejbRemove() {
  }

    /**
      * Process the message and do the right thing.
      */
    private String doWork(String message) throws JMSException {

        Document doc = getDocument(message);
        String recipient = getTagValue(doc.getDocumentElement(), "Address");
        String xmlMessage = getTagValue(doc.getDocumentElement(), "Content");
        String title = getTagValue(doc.getDocumentElement(), "Subject");
        if (recipient == null) return "failed";
        try {
            MailHelper mh = new MailHelper();
            mh.createAndSendMail(recipient, title, xmlMessage,  Locale.getDefault());
          } catch (MailerException mx) {
            System.err.println("CrmBean: caught=" + mx);
            mx.printStackTrace();
          } catch (Exception ex) {
            System.err.println("CrmBean: caught=" + ex);
            ex.printStackTrace();
        }
        return "success";
      }
      
    private Document getDocument(String xmlText) {
        Document doc = null;
        try {
            DocumentBuilderFactory docBuilderFactory = null;
            DocumentBuilder db = null;
            try {
                docBuilderFactory = DocumentBuilderFactory.newInstance();
                if (docBuilderFactory != null) 
                    db = docBuilderFactory.newDocumentBuilder();
            } catch ( javax.xml.parsers.ParserConfigurationException pce) {
                System.err.println(pce);
            }
          InputSource is =  new InputSource(new StringReader(xmlText));
            doc = db.parse(is);
        } catch (Exception e) {
            System.err.println("CrmBean::getDocument error loading XML Document " + e);
        }
        return doc;
    }
    
    private String getTagValue(Element root, String tagName) {
        String returnString = "";
        NodeList list = root.getElementsByTagName(tagName);
        for (int loop = 0; loop < list.getLength(); loop++) {
            Node node = list.item(loop);
            if (node != null) {
                Node child = node.getFirstChild();
                if ((child != null) && child.getNodeValue() != null) return child.getNodeValue();
            }
        }
        return returnString;
    }
}

