/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.LibraryClassFile;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.visitor.ClassFileVisitor;

public class MultiClassFileVisitor
implements ClassFileVisitor {
    private static final int ARRAY_SIZE_INCREMENT = 5;
    private ClassFileVisitor[] classFileVisitors;
    private int classFileVisitorCount;

    public MultiClassFileVisitor() {
    }

    public MultiClassFileVisitor(ClassFileVisitor[] classFileVisitorArray) {
        this.classFileVisitors = classFileVisitorArray;
        this.classFileVisitorCount = classFileVisitorArray.length;
    }

    public void addClassFileVisitor(ClassFileVisitor classFileVisitor) {
        this.ensureArraySize();
        this.classFileVisitors[this.classFileVisitorCount++] = classFileVisitor;
    }

    private void ensureArraySize() {
        if (this.classFileVisitors == null) {
            this.classFileVisitors = new ClassFileVisitor[5];
        } else if (this.classFileVisitors.length == this.classFileVisitorCount) {
            ClassFileVisitor[] classFileVisitorArray = new ClassFileVisitor[this.classFileVisitorCount + 5];
            System.arraycopy(this.classFileVisitors, 0, classFileVisitorArray, 0, this.classFileVisitorCount);
            this.classFileVisitors = classFileVisitorArray;
        }
    }

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        for (int i = 0; i < this.classFileVisitorCount; ++i) {
            this.classFileVisitors[i].visitProgramClassFile(programClassFile);
        }
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
        for (int i = 0; i < this.classFileVisitorCount; ++i) {
            this.classFileVisitors[i].visitLibraryClassFile(libraryClassFile);
        }
    }
}

