/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.ClassFile;
import proguard.classfile.FieldInfo;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.MemberInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.visitor.MemberInfoAccessFilter;
import proguard.classfile.visitor.MemberInfoClassFileAccessFilter;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.classfile.visitor.NamedFieldVisitor;
import proguard.classfile.visitor.NamedMethodVisitor;

public class MemberFinder
implements MemberInfoVisitor {
    private static final MemberFoundException MEMBER_FOUND = new MemberFoundException();
    private ClassFile classFile;
    private MemberInfo memberInfo;

    public FieldInfo findField(ClassFile classFile, ClassFile classFile2, String string, String string2) {
        return (FieldInfo)this.findMember(classFile, classFile2, string, string2, true);
    }

    public MethodInfo findMethod(ClassFile classFile, ClassFile classFile2, String string, String string2) {
        return (MethodInfo)this.findMember(classFile, classFile2, string, string2, false);
    }

    public MemberInfo findMember(ClassFile classFile, ClassFile classFile2, String string, String string2, boolean bl) {
        try {
            this.classFile = null;
            this.memberInfo = null;
            classFile2.hierarchyAccept(true, true, true, false, bl ? new NamedFieldVisitor(string, string2, new MemberInfoClassFileAccessFilter(classFile, this)) : new NamedMethodVisitor(string, string2, new MemberInfoClassFileAccessFilter(classFile, this)));
        }
        catch (MemberFoundException memberFoundException) {
            // empty catch block
        }
        return this.memberInfo;
    }

    public ClassFile correspondingClassFile() {
        return this.classFile;
    }

    public boolean isOverriden(ClassFile classFile, MethodInfo methodInfo) {
        String string = methodInfo.getName(classFile);
        String string2 = methodInfo.getDescriptor(classFile);
        try {
            this.classFile = null;
            this.memberInfo = null;
            classFile.hierarchyAccept(false, false, false, true, new NamedMethodVisitor(string, string2, new MemberInfoAccessFilter(0, 2, this)));
        }
        catch (MemberFoundException memberFoundException) {
            return true;
        }
        return false;
    }

    public boolean isShadowed(ClassFile classFile, FieldInfo fieldInfo) {
        String string = fieldInfo.getName(classFile);
        String string2 = fieldInfo.getDescriptor(classFile);
        try {
            this.classFile = null;
            this.memberInfo = null;
            classFile.hierarchyAccept(false, false, false, true, new NamedFieldVisitor(string, string2, new MemberInfoAccessFilter(0, 2, this)));
        }
        catch (MemberFoundException memberFoundException) {
            return true;
        }
        return false;
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        this.visitMemberInfo(programClassFile, programFieldInfo);
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        this.visitMemberInfo(programClassFile, programMethodInfo);
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
        this.visitMemberInfo(libraryClassFile, libraryFieldInfo);
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
        this.visitMemberInfo(libraryClassFile, libraryMethodInfo);
    }

    private void visitMemberInfo(ClassFile classFile, MemberInfo memberInfo) {
        this.classFile = classFile;
        this.memberInfo = memberInfo;
        throw MEMBER_FOUND;
    }

    private static class MemberFoundException
    extends IllegalArgumentException {
        private MemberFoundException() {
        }
    }
}

