/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.instruction;

import proguard.classfile.ClassFile;
import proguard.classfile.MethodInfo;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionVisitor;

public class TableSwitchInstruction
extends Instruction {
    public int defaultOffset;
    public int lowCase;
    public int highCase;
    public int jumpOffsetCount;
    public int[] jumpOffsets;

    public TableSwitchInstruction copy(TableSwitchInstruction tableSwitchInstruction) {
        this.opcode = tableSwitchInstruction.opcode;
        this.defaultOffset = tableSwitchInstruction.defaultOffset;
        this.lowCase = tableSwitchInstruction.lowCase;
        this.highCase = tableSwitchInstruction.highCase;
        this.jumpOffsetCount = tableSwitchInstruction.jumpOffsetCount;
        this.jumpOffsets = tableSwitchInstruction.jumpOffsets;
        return this;
    }

    public Instruction shrink() {
        return this;
    }

    protected void readInfo(byte[] byArray, int n) {
        n += -n & 3;
        this.defaultOffset = TableSwitchInstruction.readInt(byArray, n);
        this.lowCase = TableSwitchInstruction.readInt(byArray, n += 4);
        this.highCase = TableSwitchInstruction.readInt(byArray, n += 4);
        n += 4;
        this.jumpOffsetCount = this.highCase - this.lowCase + 1;
        if (this.jumpOffsets == null || this.jumpOffsets.length < this.jumpOffsetCount) {
            this.jumpOffsets = new int[this.jumpOffsetCount];
        }
        for (int i = 0; i < this.jumpOffsetCount; ++i) {
            this.jumpOffsets[i] = TableSwitchInstruction.readInt(byArray, n);
            n += 4;
        }
    }

    protected void writeInfo(byte[] byArray, int n) {
        while ((n & 3) != 0) {
            TableSwitchInstruction.writeByte(byArray, n++, 0);
        }
        TableSwitchInstruction.writeInt(byArray, n, this.defaultOffset);
        TableSwitchInstruction.writeInt(byArray, n += 4, this.lowCase);
        TableSwitchInstruction.writeInt(byArray, n += 4, this.highCase);
        n += 4;
        int n2 = this.highCase - this.lowCase + 1;
        for (int i = 0; i < n2; ++i) {
            TableSwitchInstruction.writeInt(byArray, n, this.jumpOffsets[i]);
            n += 4;
        }
    }

    public int length(int n) {
        return 1 + (-(n + 1) & 3) + 12 + (this.highCase - this.lowCase + 1) * 4;
    }

    public void accept(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, InstructionVisitor instructionVisitor) {
        instructionVisitor.visitTableSwitchInstruction(classFile, methodInfo, codeAttrInfo, n, this);
    }

    public String toString(int n) {
        return "[" + n + "] " + this.getName() + " (low=" + this.lowCase + ", high=" + this.highCase + ")";
    }

    public String toString() {
        return this.getName() + " (low=" + this.lowCase + ", high=" + this.highCase + ")";
    }
}

