/*
 * Decompiled with CFR 0.152.
 */
package ricoh.ant;

import java.util.logging.Level;
import org.apache.tools.ant.Task;

public abstract class LoggingTask
extends Task {
    private boolean verbose;
    private int alertLevel;
    private boolean debugOn;
    public static final String DEBUG_PROP_FLAG = "ricoh.ant.debugOn";

    public final void init() {
        this.alertLevel = Level.INFO.intValue();
        if (this.getProject().getProperty(DEBUG_PROP_FLAG) != null) {
            this.debugOn = true;
            this.setVerbose(true);
        }
        this.initialize();
    }

    public abstract void initialize();

    public final void log(String msg, int msgLevel) {
        if (this.alertLevel == Level.OFF.intValue() || msg == null) {
            return;
        }
        if (msgLevel >= this.alertLevel || this.verbose || this.debugOn) {
            super.log(msg, msgLevel);
        }
    }

    public void log(String msg) {
        this.log(msg, Level.INFO.intValue());
    }

    public void log(String msg, Level msgLevel) {
        this.log(msg, msgLevel.intValue());
    }

    protected void configAlertLevel(Level alertLevel) {
        this.alertLevel = alertLevel.intValue();
    }

    public void setAlertLevel(String level) {
        if (level.toLowerCase().equals("severe")) {
            this.configAlertLevel(Level.SEVERE);
        }
        if (level.toLowerCase().equals("warning")) {
            this.configAlertLevel(Level.WARNING);
        }
        if (level.toLowerCase().equals("info")) {
            this.configAlertLevel(Level.INFO);
        }
        if (level.toLowerCase().equals("config")) {
            this.configAlertLevel(Level.CONFIG);
        }
        if (level.toLowerCase().equals("fine")) {
            this.configAlertLevel(Level.FINE);
        }
        if (level.toLowerCase().equals("finer")) {
            this.configAlertLevel(Level.FINER);
        }
        if (level.toLowerCase().equals("finest")) {
            this.configAlertLevel(Level.FINEST);
        }
        if (level.toLowerCase().equals("off")) {
            this.configAlertLevel(Level.OFF);
        }
    }

    public void setVerbose(boolean isVerbose) {
        this.verbose = isVerbose;
    }

    public abstract void execute();
}

