/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type.collection;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.AegisBindingProvider;
import org.codehaus.xfire.aegis.MessageReader;
import org.codehaus.xfire.aegis.MessageWriter;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.util.NamespaceHelper;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;

public class MapType
extends Type {
    private Type keyType;
    private Type valueType;
    private QName keyName;
    private QName valueName;
    private QName entryName;

    public MapType(QName schemaType, Type keyType, Type valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.setSchemaType(schemaType);
        this.setKeyName(new QName(schemaType.getNamespaceURI(), "key"));
        this.setValueName(new QName(schemaType.getNamespaceURI(), "value"));
        this.setEntryName(new QName(schemaType.getNamespaceURI(), "entry"));
    }

    public Object readObject(MessageReader reader, MessageContext context) throws XFireFault {
        Map map = this.instantiateMap();
        try {
            Type keyType = this.getKeyType();
            Type valueType = this.getValueType();
            Object key = null;
            Object value = null;
            while (reader.hasMoreElementReaders()) {
                MessageReader entryReader = reader.getNextElementReader();
                if (entryReader.getName().equals(this.getEntryName())) {
                    while (entryReader.hasMoreElementReaders()) {
                        MessageReader evReader = entryReader.getNextElementReader();
                        if (evReader.getName().equals(this.getKeyName())) {
                            key = keyType.readObject(evReader, context);
                            continue;
                        }
                        if (evReader.getName().equals(this.getValueName())) {
                            value = valueType.readObject(evReader, context);
                            continue;
                        }
                        this.readToEnd(evReader);
                    }
                    map.put(key, value);
                    continue;
                }
                this.readToEnd(entryReader);
            }
            return map;
        }
        catch (IllegalArgumentException e) {
            throw new XFireRuntimeException("Illegal argument.", (Throwable)e);
        }
    }

    private void readToEnd(MessageReader childReader) {
        while (childReader.hasMoreElementReaders()) {
            this.readToEnd(childReader.getNextElementReader());
        }
    }

    protected Map instantiateMap() {
        Map map = null;
        if (this.getTypeClass().equals(Map.class)) {
            map = new HashMap();
        } else if (this.getTypeClass().equals(Hashtable.class)) {
            map = new Hashtable();
        } else if (this.getTypeClass().isInterface()) {
            map = new HashMap();
        } else {
            try {
                map = (Map)this.getTypeClass().newInstance();
            }
            catch (Exception e) {
                throw new XFireRuntimeException("Could not create map implementation: " + this.getTypeClass().getName(), (Throwable)e);
            }
        }
        return map;
    }

    public void writeObject(Object object, MessageWriter writer, MessageContext context) throws XFireFault {
        if (object == null) {
            return;
        }
        try {
            Map map = (Map)object;
            Type keyType = this.getKeyType();
            Type valueType = this.getValueType();
            Iterator itr = map.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                this.writeEntry(writer, context, keyType, valueType, entry);
            }
        }
        catch (IllegalArgumentException e) {
            throw new XFireRuntimeException("Illegal argument.", (Throwable)e);
        }
    }

    private void writeEntry(MessageWriter writer, MessageContext context, Type keyType, Type valueType, Map.Entry entry) throws XFireFault {
        keyType = AegisBindingProvider.getWriteType(context, entry.getKey(), keyType);
        valueType = AegisBindingProvider.getWriteType(context, entry.getValue(), valueType);
        MessageWriter entryWriter = writer.getElementWriter(this.getEntryName());
        MessageWriter keyWriter = entryWriter.getElementWriter(this.getKeyName());
        keyType.writeObject(entry.getKey(), keyWriter, context);
        keyWriter.close();
        MessageWriter valueWriter = entryWriter.getElementWriter(this.getValueName());
        valueType.writeObject(entry.getValue(), valueWriter, context);
        valueWriter.close();
        entryWriter.close();
    }

    public void writeSchema(Element root) {
        Element complex = new Element("complexType", "xsd", "http://www.w3.org/2001/XMLSchema");
        complex.setAttribute(new Attribute("name", this.getSchemaType().getLocalPart()));
        root.addContent((Content)complex);
        Element seq = new Element("sequence", "xsd", "http://www.w3.org/2001/XMLSchema");
        complex.addContent((Content)seq);
        Type keyType = this.getKeyType();
        Type valueType = this.getValueType();
        Element element = new Element("element", "xsd", "http://www.w3.org/2001/XMLSchema");
        seq.addContent((Content)element);
        element.setAttribute(new Attribute("name", this.getEntryName().getLocalPart()));
        element.setAttribute(new Attribute("minOccurs", "0"));
        element.setAttribute(new Attribute("maxOccurs", "unbounded"));
        Element evComplex = new Element("complexType", "xsd", "http://www.w3.org/2001/XMLSchema");
        element.addContent((Content)evComplex);
        Element evseq = new Element("sequence", "xsd", "http://www.w3.org/2001/XMLSchema");
        evComplex.addContent((Content)evseq);
        this.createElement(root, evseq, this.getKeyName(), keyType);
        this.createElement(root, evseq, this.getValueName(), valueType);
    }

    private void createElement(Element root, Element seq, QName name, Type type) {
        Element element = new Element("element", "xsd", "http://www.w3.org/2001/XMLSchema");
        seq.addContent((Content)element);
        String prefix = NamespaceHelper.getUniquePrefix((Element)((Element)root.getParent()), (String)type.getSchemaType().getNamespaceURI());
        String typeName = prefix + ":" + type.getSchemaType().getLocalPart();
        element.setAttribute(new Attribute("name", name.getLocalPart()));
        element.setAttribute(new Attribute("type", typeName));
        element.setAttribute(new Attribute("minOccurs", "0"));
        element.setAttribute(new Attribute("maxOccurs", "1"));
    }

    public Set getDependencies() {
        HashSet<Type> deps = new HashSet<Type>();
        deps.add(this.getKeyType());
        deps.add(this.getValueType());
        return deps;
    }

    public Type getKeyType() {
        return this.keyType;
    }

    public Type getValueType() {
        return this.valueType;
    }

    public boolean isComplex() {
        return true;
    }

    public QName getKeyName() {
        return this.keyName;
    }

    public void setKeyName(QName keyName) {
        this.keyName = keyName;
    }

    public QName getValueName() {
        return this.valueName;
    }

    public void setValueName(QName valueName) {
        this.valueName = valueName;
    }

    public QName getEntryName() {
        return this.entryName;
    }

    public void setEntryName(QName entryName) {
        this.entryName = entryName;
    }
}

