/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.usm;

import com.sun.jdmk.defaults.DefaultPaths;
import com.sun.jdmk.internal.BackupFileHandler;
import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpLcd;
import com.sun.management.internal.snmp.SnmpPersistRowFile;
import com.sun.management.internal.snmp.SnmpPersistRowFileConsumer;
import com.sun.management.internal.snmp.SnmpSubSystem;
import com.sun.management.internal.snmp.SnmpTools;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpEngineId;
import com.sun.management.snmp.usm.LcdEngine;
import com.sun.management.snmp.usm.SecurityConfException;
import com.sun.management.snmp.usm.SnmpUsmAlgorithmManager;
import com.sun.management.snmp.usm.SnmpUsmAuthAlgorithm;
import com.sun.management.snmp.usm.SnmpUsmAuthAlgorithmException;
import com.sun.management.snmp.usm.SnmpUsmAuthPair;
import com.sun.management.snmp.usm.SnmpUsmEngineIdException;
import com.sun.management.snmp.usm.SnmpUsmException;
import com.sun.management.snmp.usm.SnmpUsmLcd;
import com.sun.management.snmp.usm.SnmpUsmMibTable;
import com.sun.management.snmp.usm.SnmpUsmPrivAlgorithm;
import com.sun.management.snmp.usm.SnmpUsmPrivAlgorithmException;
import com.sun.management.snmp.usm.SnmpUsmPrivPair;
import com.sun.management.snmp.usm.SnmpUsmSecureUser;
import com.sun.management.snmp.usm.SnmpUsmSecureUserImpl;
import com.sun.management.snmp.usm.SnmpUsmUserNameException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SnmpUsmPasswordLcd
implements SnmpUsmLcd {
    static final int USER_ENGINEID = 0;
    static final int USER_NAME = 1;
    static final int USER_SECURITY_NAME = 2;
    static final int USER_AUTH_PROTOCOL = 3;
    static final int USER_AUTH_PASSWORD = 4;
    static final int USER_PRIV_PROTOCOL = 5;
    static final int USER_PRIV_PASSWORD = 6;
    static final int USER_STORAGE_TYPE = 7;
    static final int USER_TEMPLATE = 8;
    UsmConsumer consumer;
    SnmpPersistRowFile file;
    boolean strictParsing;
    Hashtable engines;
    SnmpUsmAlgorithmManager algos;
    LcdEngine localEngine;
    SnmpEngine engine;
    SnmpUsmMibTable table;
    boolean sync;
    boolean syncDone;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpUsmPasswordLcd");
    String dbgTag;

    public SnmpUsmPasswordLcd(SnmpEngine snmpEngine, SnmpSubSystem snmpSubSystem, SnmpLcd snmpLcd, String string) throws IllegalArgumentException {
        block6: {
            this.consumer = null;
            this.file = null;
            this.strictParsing = true;
            this.engines = new Hashtable();
            this.algos = null;
            this.localEngine = null;
            this.engine = null;
            this.table = null;
            this.sync = false;
            this.syncDone = false;
            this.dbgTag = "SnmpUsmPasswordLcd";
            this.engine = snmpEngine;
            snmpLcd.addModelLcd(snmpSubSystem, 3, this);
            this.consumer = new UsmConsumer(this);
            String string2 = this.handleSecurityFileLocation(string);
            if (string2 != null) {
                try {
                    this.file = new SnmpPersistRowFile(string2, "userEntry", ",", this.consumer);
                    if (this.strictParsing) {
                        this.file.enableException(true);
                    }
                    break block6;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (logger.finestOn()) {
                        logger.finest("SnmpUsmPasswordLcd", "Exception :" + illegalArgumentException);
                    }
                    break block6;
                }
            }
            if (logger.finestOn()) {
                logger.finest("SnmpUsmPasswordLcd", "No configuration file provided.");
            }
        }
        this.localEngine = new LcdEngine(snmpEngine.getEngineId());
        this.engines.put(snmpEngine.getEngineId().toString(), this.localEngine);
    }

    public void enableStrictParsing(boolean bl) {
        this.strictParsing = bl;
    }

    public void setUserAuthKeyChange(SnmpUsmSecureUser snmpUsmSecureUser, byte[] byArray) {
        SnmpUsmSecureUserImpl snmpUsmSecureUserImpl = (SnmpUsmSecureUserImpl)snmpUsmSecureUser;
        snmpUsmSecureUserImpl.setAuthKeyChange(byArray);
    }

    public void setUserPrivKeyChange(SnmpUsmSecureUser snmpUsmSecureUser, byte[] byArray) {
        SnmpUsmSecureUserImpl snmpUsmSecureUserImpl = (SnmpUsmSecureUserImpl)snmpUsmSecureUser;
        snmpUsmSecureUserImpl.setPrivKeyChange(byArray);
    }

    public void addUser(SnmpUsmSecureUser snmpUsmSecureUser, boolean bl) {
        this.insertUser(snmpUsmSecureUser.getEngineId(), snmpUsmSecureUser, bl);
    }

    public SnmpUsmSecureUser createNewUser(byte[] byArray, String string) {
        SnmpUsmSecureUserImpl snmpUsmSecureUserImpl = new SnmpUsmSecureUserImpl(this, SnmpEngineId.createEngineId(byArray), string);
        return snmpUsmSecureUserImpl;
    }

    public int getStorageType() {
        if (this.file != null) {
            return 3;
        }
        return 2;
    }

    public void setMibTable(SnmpUsmMibTable snmpUsmMibTable) {
        this.table = snmpUsmMibTable;
    }

    public synchronized void addEngine(SnmpEngineId snmpEngineId) {
    }

    public void setAlgorithmManager(SnmpUsmAlgorithmManager snmpUsmAlgorithmManager) {
        this.algos = snmpUsmAlgorithmManager;
    }

    public SnmpUsmSecureUser getUser(SnmpEngineId snmpEngineId, String string) throws SnmpUsmEngineIdException, SnmpUsmUserNameException {
        return this.findUser(snmpEngineId, string);
    }

    public synchronized void syncDataSource() throws IllegalArgumentException {
        if (this.syncDone) {
            return;
        }
        this.sync = true;
        if (this.getStorageType() == 3) {
            this.readFile();
        }
        this.sync = false;
        this.syncDone = true;
    }

    public SnmpUsmAlgorithmManager getAlgorithmManager() {
        return this.algos;
    }

    public synchronized SnmpUsmPrivPair getUserPrivPair(SnmpEngineId snmpEngineId, String string) throws SnmpUsmPrivAlgorithmException, SnmpUsmEngineIdException, SnmpUsmUserNameException {
        SnmpUsmSecureUserImpl snmpUsmSecureUserImpl = null;
        snmpUsmSecureUserImpl = (SnmpUsmSecureUserImpl)this.findUser(snmpEngineId, string);
        SnmpUsmPrivAlgorithm snmpUsmPrivAlgorithm = snmpUsmSecureUserImpl.getPrivPair().algo;
        if (snmpUsmPrivAlgorithm == null) {
            throw new SnmpUsmPrivAlgorithmException("User: " + snmpUsmSecureUserImpl.getName() + " No Priv algorithm");
        }
        return snmpUsmSecureUserImpl.getPrivPair();
    }

    public synchronized SnmpUsmAuthPair getUserAuthPair(SnmpEngineId snmpEngineId, String string) throws SnmpUsmAuthAlgorithmException, SnmpUsmEngineIdException, SnmpUsmUserNameException {
        SnmpUsmSecureUserImpl snmpUsmSecureUserImpl = null;
        snmpUsmSecureUserImpl = (SnmpUsmSecureUserImpl)this.findUser(snmpEngineId, string);
        SnmpUsmAuthAlgorithm snmpUsmAuthAlgorithm = snmpUsmSecureUserImpl.getAuthPair().algo;
        if (snmpUsmAuthAlgorithm == null) {
            throw new SnmpUsmAuthAlgorithmException("User: " + snmpUsmSecureUserImpl.getName() + " No Auth algorithm");
        }
        return snmpUsmSecureUserImpl.getAuthPair();
    }

    public synchronized void addUser(SnmpEngineId snmpEngineId, String string, String string2, String string3, String string4, String string5, String string6, int n, boolean bl) throws SnmpUsmException {
        try {
            this.translateAndInsert(snmpEngineId, snmpEngineId.getReadableId() == null ? snmpEngineId.toString() : snmpEngineId.getReadableId(), string, string2, string3, string4, string5, string6, n, bl);
        }
        catch (SecurityConfException securityConfException) {
            throw new SnmpUsmException("Security configuration: " + securityConfException);
        }
    }

    public synchronized Enumeration getAllUsers() {
        Vector<SnmpUsmSecureUser> vector = new Vector<SnmpUsmSecureUser>();
        Enumeration enumeration = this.engines.elements();
        while (enumeration.hasMoreElements()) {
            LcdEngine lcdEngine = (LcdEngine)enumeration.nextElement();
            Enumeration enumeration2 = lcdEngine.users.elements();
            while (enumeration2.hasMoreElements()) {
                SnmpUsmSecureUser snmpUsmSecureUser = (SnmpUsmSecureUser)enumeration2.nextElement();
                vector.add(snmpUsmSecureUser);
            }
        }
        return vector.elements();
    }

    private String handleSecurityFileLocation(String string) throws IllegalArgumentException {
        String string2 = null;
        File file = null;
        if (string == null) {
            string2 = System.getProperty("jdmk.security.file");
            if (string2 == null) {
                if (logger.finestOn()) {
                    logger.finest("handleSecurityFileLocation", "Security file not found. Use default one.");
                }
                if (!(file = new File(string2 = DefaultPaths.getEtcDir("conf" + File.separator + "jdmk.security"))).exists()) {
                    file = null;
                    if (logger.finerOn()) {
                        logger.finer("handleSecurityFileLocation", "The default file [" + string2 + "] doesn't exist.");
                    }
                    return null;
                }
                return string2;
            }
            file = new File(string2);
            if (!file.exists()) {
                if (logger.finerOn()) {
                    logger.finer("handleSecurityFileLocation", "The specified file [" + file + "] doesn't exist, " + "no configuration loaded");
                }
                throw new IllegalArgumentException("The specified file [" + file + "] doesn't exist, no configuration loaded");
            }
            return string2;
        }
        file = new File(string);
        if (!file.exists()) {
            if (logger.finerOn()) {
                logger.finer("handleSecurityFileLocation", "The specified file [" + file + "] doesn't exist, no configuration loaded");
            }
            throw new IllegalArgumentException("The specified file [" + file + "] doesn't exist, no configuration loaded");
        }
        return string;
    }

    private void sendNewUserEvent(SnmpUsmSecureUser snmpUsmSecureUser, boolean bl) {
        if (!bl) {
            return;
        }
        if (this.table != null) {
            this.table.userAdded(snmpUsmSecureUser);
        }
    }

    private void sendUpdateUserEvent(SnmpUsmSecureUser snmpUsmSecureUser, boolean bl) {
        if (!bl) {
            return;
        }
        if (this.table != null) {
            this.table.userUpdated(snmpUsmSecureUser);
        }
    }

    private void sendRemoveUserEvent(SnmpUsmSecureUser snmpUsmSecureUser, boolean bl) {
        if (!bl) {
            return;
        }
        if (this.table != null) {
            this.table.userRemoved(snmpUsmSecureUser);
        }
    }

    public synchronized void removeUser(SnmpEngineId snmpEngineId, String string, boolean bl) {
        LcdEngine lcdEngine = (LcdEngine)this.engines.get(snmpEngineId.toString());
        if (lcdEngine == null) {
            return;
        }
        SnmpUsmSecureUser snmpUsmSecureUser = lcdEngine.removeSecureUser(string);
        if (snmpUsmSecureUser != null) {
            if (this.getStorageType() == 3) {
                this.flushFile();
            }
            this.sendRemoveUserEvent(snmpUsmSecureUser, bl);
        }
    }

    private synchronized void insertUser(SnmpEngineId snmpEngineId, SnmpUsmSecureUser snmpUsmSecureUser, boolean bl) {
        SnmpUsmSecureUser snmpUsmSecureUser2;
        LcdEngine lcdEngine = (LcdEngine)this.engines.get(snmpEngineId.toString());
        if (lcdEngine == null) {
            if (logger.finestOn()) {
                logger.finest("insertUser", " New engine Id");
            }
            lcdEngine = new LcdEngine(snmpEngineId);
            this.engines.put(snmpEngineId.toString(), lcdEngine);
        }
        if (logger.finestOn()) {
            logger.finest("insertUser", " engine id : " + lcdEngine.engineId);
        }
        if (logger.finestOn()) {
            logger.finest("insertUser", " Inserting a new User [" + snmpUsmSecureUser.getName() + "]" + ", engineId [" + snmpEngineId + "], notif flag : " + bl);
        }
        if ((snmpUsmSecureUser2 = lcdEngine.addSecureUser(snmpUsmSecureUser)) != null) {
            if (logger.finestOn()) {
                logger.finest("insertUser", " It is an update");
            }
            this.sendUpdateUserEvent(snmpUsmSecureUser, bl);
        } else {
            if (logger.finestOn()) {
                logger.finest("insertUser", " It is a new user");
            }
            this.sendNewUserEvent(snmpUsmSecureUser, bl);
        }
        if (!this.sync && this.getStorageType() == 3) {
            this.flushFile();
        }
    }

    private synchronized SnmpUsmSecureUser findUser(SnmpEngineId snmpEngineId, String string) throws SnmpUsmEngineIdException, SnmpUsmUserNameException {
        if (logger.finerOn()) {
            logger.finer("findUser", "Engine Id : " + snmpEngineId + "/" + snmpEngineId.hashCode() + "     user Name : " + string);
        }
        LcdEngine lcdEngine = (LcdEngine)this.engines.get(snmpEngineId.toString());
        SnmpUsmSecureUser snmpUsmSecureUser = null;
        if (string == null) {
            if (logger.finestOn()) {
                logger.finest("findUser", "Username : [" + string + "] NULL.");
            }
            throw new SnmpUsmUserNameException("User " + string + " unknown.");
        }
        if (lcdEngine == null) {
            if (logger.finestOn()) {
                logger.finest("findUser", "Engine Id [" + snmpEngineId.toString() + "] unknown.");
            }
            throw new SnmpUsmEngineIdException("Unknown engine Id : " + snmpEngineId.toString());
        }
        if (logger.finerOn()) {
            logger.finer("findUser", "EXISTS. Engine Id : " + lcdEngine.engineId.toString());
        }
        if ((snmpUsmSecureUser = lcdEngine.getSecureUser(string)) == null) {
            if (logger.finestOn()) {
                logger.finest("findUser", "Username : [" + string + "] unknown.");
            }
            throw new SnmpUsmUserNameException("User " + string + " unknown.");
        }
        if (logger.finerOn()) {
            logger.finer("findUser", "Known engine Id [" + lcdEngine.engineId.toString() + " ] and user Name [" + snmpUsmSecureUser.getName() + "]");
        }
        return snmpUsmSecureUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    synchronized void flushFile() {
        block16: {
            File file;
            FileWriter fileWriter;
            block15: {
                fileWriter = null;
                file = BackupFileHandler.createBackupFile(this.file.getFile(), null);
                if (file == null) {
                    if (logger.finestOn()) {
                        logger.finest("flushFile", "Backup file not created, changes are not flushed");
                    }
                    return;
                }
                if (logger.finestOn()) {
                    logger.finest("flushFile", "Flushing file, backup file : " + file);
                }
                fileWriter = this.file.createWriter();
                SnmpEngineId snmpEngineId = this.engine.getEngineId();
                this.file.write(fileWriter, "localEngineID", (snmpEngineId.getReadableId() == null ? snmpEngineId.toString() : snmpEngineId.getReadableId()) + "\n");
                this.file.write(fileWriter, "localEngineBoots", this.engine.getEngineBoots() + 1 + "\n\n");
                Enumeration enumeration = this.engines.elements();
                while (enumeration.hasMoreElements()) {
                    LcdEngine lcdEngine = (LcdEngine)enumeration.nextElement();
                    lcdEngine.storeUsers(this.engine.getEngineId(), fileWriter, this.file);
                }
                Object var7_7 = null;
                if (fileWriter == null) break block15;
                try {
                    this.file.releaseWriter(fileWriter);
                }
                catch (Exception exception) {
                    if (!logger.finestOn()) break block15;
                    logger.finest("flushFile", "Exception : " + exception);
                }
            }
            BackupFileHandler.deleteBackupFile(file);
            {
                break block16;
                catch (Exception exception) {
                    block17: {
                        if (logger.finestOn()) {
                            logger.finest("flushFile", "Exception : " + exception);
                        }
                        Object var7_8 = null;
                        if (fileWriter != null) {
                            try {
                                this.file.releaseWriter(fileWriter);
                            }
                            catch (Exception exception2) {
                                if (!logger.finestOn()) break block17;
                                logger.finest("flushFile", "Exception : " + exception2);
                            }
                        }
                    }
                    BackupFileHandler.deleteBackupFile(file);
                }
            }
            catch (Throwable throwable) {
                block18: {
                    Object var7_9 = null;
                    if (fileWriter != null) {
                        try {
                            this.file.releaseWriter(fileWriter);
                        }
                        catch (Exception exception) {
                            if (!logger.finestOn()) break block18;
                            logger.finest("flushFile", "Exception : " + exception);
                        }
                    }
                }
                BackupFileHandler.deleteBackupFile(file);
                throw throwable;
            }
        }
    }

    private synchronized void readFile() {
        block4: {
            try {
                this.file.read();
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (logger.finestOn()) {
                    logger.finest("readFile", "No configuration file. Will not read or persist data");
                }
            }
            catch (IOException iOException) {
                if (!logger.finestOn()) break block4;
                logger.finest("readFile", "IO error :" + iOException);
            }
        }
    }

    private String strContext(int n) {
        switch (n) {
            case 1: {
                return "user name";
            }
            case 0: {
                return "user engine id";
            }
            case 3: {
                return "user auth protocol";
            }
            case 2: {
                return "user security name";
            }
            case 4: {
                return "user auth password";
            }
            case 6: {
                return "user priv key";
            }
            case 5: {
                return "user priv protocol";
            }
            case 7: {
                return "user storage type";
            }
        }
        return "unknown parameter";
    }

    private synchronized void translateAndInsert(SnmpEngineId snmpEngineId, String string, String string2, String string3, String string4, String string5, String string6, String string7, int n, boolean bl) throws SecurityConfException {
        byte[] byArray = null;
        byte[] byArray2 = null;
        SnmpUsmAuthAlgorithm snmpUsmAuthAlgorithm = null;
        SnmpUsmPrivAlgorithm snmpUsmPrivAlgorithm = null;
        if (string2 == null) {
            throw new IllegalArgumentException("Missing user.");
        }
        if (string4 != null && !string4.equals("usmNoAuthProtocol") && (snmpUsmAuthAlgorithm = (SnmpUsmAuthAlgorithm)this.algos.getAlgorithm(string4)) == null) {
            String string8 = "Unknown authentication algorithm : [" + string4 + "]";
            throw new IllegalArgumentException(string8);
        }
        if (string5 != null && string5.startsWith("0x")) {
            try {
                byArray = SnmpTools.ascii2binary(string5);
            }
            catch (Throwable throwable) {
                throw new IllegalArgumentException("Unexpected exception: " + throwable);
            }
        }
        if (string6 != null && !string6.equals("usmNoPrivProtocol") && (snmpUsmPrivAlgorithm = (SnmpUsmPrivAlgorithm)this.algos.getAlgorithm(string6)) == null) {
            String string9 = "Unknown privacy algorithm : [" + string6 + "]";
            throw new IllegalArgumentException(string9);
        }
        if (string7 != null && string7.startsWith("0x")) {
            try {
                byArray2 = SnmpTools.ascii2binary(string7);
            }
            catch (Throwable throwable) {
                throw new IllegalArgumentException("Unexpected exception: " + throwable);
            }
        }
        if (string5 != null && byArray == null && snmpUsmAuthAlgorithm != null) {
            byArray = snmpUsmAuthAlgorithm.password_to_key(string5);
        }
        if (byArray != null && snmpUsmAuthAlgorithm != null && !string5.startsWith("0x")) {
            byArray = snmpUsmAuthAlgorithm.localizeAuthKey(byArray, snmpEngineId);
        }
        if (string7 != null && byArray2 == null && snmpUsmPrivAlgorithm != null) {
            if (snmpUsmAuthAlgorithm == null) {
                throw new IllegalArgumentException("Translating priv password to priv key but auth algo is null");
            }
            byArray2 = snmpUsmAuthAlgorithm.password_to_key(string7);
        }
        if (byArray2 != null && snmpUsmPrivAlgorithm != null && !string7.startsWith("0x")) {
            if (snmpUsmAuthAlgorithm == null) {
                throw new IllegalArgumentException("Localizing priv key but auth algo is null");
            }
            byArray2 = snmpUsmAuthAlgorithm.localizePrivKey(byArray2, snmpEngineId, snmpUsmPrivAlgorithm.getKeySize());
        }
        SnmpUsmSecureUserImpl snmpUsmSecureUserImpl = new SnmpUsmSecureUserImpl(this, snmpEngineId, string, string2, string3, snmpUsmAuthAlgorithm, string4, byArray, string5, snmpUsmPrivAlgorithm, string6, byArray2, string7, n, bl);
        this.insertUser(snmpEngineId, snmpUsmSecureUserImpl, true);
    }

    private synchronized SnmpEngineId translateEngineId(String string) throws SecurityConfException {
        SnmpEngineId snmpEngineId = null;
        int n = string.indexOf("0x");
        if (n == -1 && !string.equals("localEngineID")) {
            try {
                snmpEngineId = SnmpEngineId.createEngineId(string);
            }
            catch (UnknownHostException unknownHostException) {
                throw new IllegalArgumentException("Unknown host : " + unknownHostException.getMessage());
            }
            if (logger.finerOn()) {
                logger.finer("translateEngineId", "Caculate engine Id from : " + string + "\tResulting Id : " + snmpEngineId);
            }
        } else if (!string.equals("localEngineID") && !string.equals(this.engine.getEngineId().toString())) {
            try {
                snmpEngineId = SnmpEngineId.createEngineId(string);
            }
            catch (UnknownHostException unknownHostException) {
                throw new IllegalArgumentException("Unknown host : " + unknownHostException.getMessage());
            }
        } else {
            snmpEngineId = this.engine.getEngineId();
        }
        return snmpEngineId;
    }

    void endRow(DataUser dataUser, String string, int n) throws Exception {
        int n2;
        block7: {
            n2 = 0;
            if (dataUser.storageType != null) {
                try {
                    n2 = Integer.parseInt(dataUser.storageType);
                    if (n2 != 3) {
                        throw new IllegalArgumentException("Illegal storage type : " + n2);
                    }
                    break block7;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Unexpected exception: " + numberFormatException);
                }
            }
            n2 = 3;
        }
        SnmpEngineId snmpEngineId = this.translateEngineId(dataUser.strEngineId);
        try {
            this.findUser(snmpEngineId, dataUser.name);
            throw new IllegalArgumentException("Already defined user");
        }
        catch (SnmpUsmException snmpUsmException) {
            boolean bl = false;
            if (dataUser.template != null && dataUser.template.equals("true")) {
                bl = true;
            }
            this.translateAndInsert(snmpEngineId, dataUser.strEngineId, dataUser.name, dataUser.securityName, dataUser.authProtocol, dataUser.authPassword, dataUser.privProtocol, dataUser.privPassword, n2, bl);
            return;
        }
    }

    class UsmConsumer
    implements SnmpPersistRowFileConsumer {
        DataUser user;
        SnmpUsmPasswordLcd usmlcd;

        UsmConsumer(SnmpUsmPasswordLcd snmpUsmPasswordLcd2) {
            this.user = new DataUser();
            this.usmlcd = null;
            this.usmlcd = snmpUsmPasswordLcd2;
        }

        public Object rowBegin(String string, int n) {
            this.user.reset();
            return this.user;
        }

        public void rowEnd(Object object, String string, int n) throws Exception {
            DataUser dataUser = (DataUser)object;
            this.usmlcd.endRow(dataUser, string, n);
        }

        public void treatToken(String string, int n, String string2, int n2, Object object, boolean bl) throws Exception {
            DataUser dataUser = (DataUser)object;
            switch (n2) {
                case 0: {
                    if (bl || string2 == null) {
                        throw new IllegalArgumentException("Missing engine Id.");
                    }
                    if (logger.finerOn()) {
                        logger.finer("treatToken", "context = " + SnmpUsmPasswordLcd.this.strContext(n2) + " value : " + string2);
                    }
                    dataUser.strEngineId = string2;
                    break;
                }
                case 1: {
                    if (bl || string2 == null) {
                        throw new IllegalArgumentException("Missing user.");
                    }
                    if (logger.finerOn()) {
                        logger.finer("treatToken", "context = " + SnmpUsmPasswordLcd.this.strContext(n2) + " value : " + string2);
                    }
                    dataUser.name = string2;
                    break;
                }
                case 2: {
                    if (bl) {
                        return;
                    }
                    dataUser.securityName = string2;
                    break;
                }
                case 3: {
                    if (bl) {
                        return;
                    }
                    dataUser.authProtocol = string2;
                    break;
                }
                case 4: {
                    if (bl) {
                        return;
                    }
                    dataUser.authPassword = string2;
                    break;
                }
                case 5: {
                    if (bl) {
                        return;
                    }
                    dataUser.privProtocol = string2;
                    break;
                }
                case 6: {
                    if (bl) {
                        return;
                    }
                    dataUser.privPassword = string2;
                    break;
                }
                case 7: {
                    if (bl) {
                        return;
                    }
                    dataUser.storageType = string2;
                    break;
                }
                case 8: {
                    if (bl) {
                        return;
                    }
                    dataUser.template = string2;
                    break;
                }
                default: {
                    if (logger.finestOn()) {
                        logger.finest("TreatToken", "Unknown context.");
                    }
                    throw new IllegalArgumentException("Unknown parameter");
                }
            }
        }
    }

    class DataUser {
        String strEngineId = null;
        String name = null;
        String authPassword = null;
        String privPassword = null;
        String securityName = null;
        String authProtocol = null;
        String privProtocol = null;
        String storageType = null;
        String template = null;

        DataUser() {
        }

        void reset() {
            this.strEngineId = null;
            this.name = null;
            this.authPassword = null;
            this.privPassword = null;
            this.securityName = null;
            this.authProtocol = null;
            this.privProtocol = null;
            this.storageType = null;
            this.template = null;
        }
    }
}

