/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.agent;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpEngineId;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpPduPacket;
import com.sun.management.snmp.SnmpScopedPduPacket;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.agent.SnmpMibRequest;
import com.sun.management.snmp.agent.SnmpProxy;
import com.sun.management.snmp.manager.SnmpParams;
import com.sun.management.snmp.manager.SnmpPeer;
import com.sun.management.snmp.manager.SnmpV3Parameters;

public abstract class SnmpV3Proxy
extends SnmpProxy {
    String dbgTag = "SnmpV3Proxy";
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.proxy", "SnmpV3Proxy");

    public SnmpV3Proxy(SnmpEngine snmpEngine, SnmpPeer snmpPeer, String string, String string2) throws SnmpStatusException {
        super(snmpEngine, snmpPeer, string, string2);
    }

    public abstract SnmpEngineId getEngineId();

    protected abstract SnmpParams createParameters(SnmpPdu var1) throws SnmpStatusException;

    protected SnmpParams translateParameters(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        SnmpPdu snmpPdu;
        if (logger.finestOn()) {
            logger.finest("translateParameters", " Mib request :" + snmpMibRequest);
        }
        if ((snmpPdu = snmpMibRequest.getPdu()) == null) {
            return this.createParameters(null);
        }
        SnmpV3Parameters snmpV3Parameters = (SnmpV3Parameters)this.createParameters(snmpPdu);
        byte[] byArray = null;
        int n = 0;
        byte[] byArray2 = this.getEngineId().getBytes();
        snmpV3Parameters.setContextEngineId(byArray2);
        if (logger.finestOn()) {
            logger.finest("translateParameters", " Snmp version :" + snmpPdu.version);
        }
        switch (snmpPdu.version) {
            case 0: 
            case 1: {
                int n2;
                SnmpPduPacket snmpPduPacket = (SnmpPduPacket)snmpPdu;
                String string = new String(snmpPduPacket.community);
                if (logger.finestOn()) {
                    logger.finest("translateParameters", " Community :" + string);
                }
                if ((n2 = string.indexOf(64)) != -1) {
                    byArray = string.substring(n2 + 1).getBytes();
                }
                n = 0;
                break;
            }
            case 3: {
                SnmpScopedPduPacket snmpScopedPduPacket = (SnmpScopedPduPacket)snmpPdu;
                byArray = snmpScopedPduPacket.contextName;
                n = snmpScopedPduPacket.msgFlags;
                snmpV3Parameters.setMsgMaxSize(snmpScopedPduPacket.msgMaxSize);
                if (!logger.finestOn()) break;
                logger.finest("translateParameters", " msgMaxSize :" + snmpScopedPduPacket.msgMaxSize);
            }
        }
        if (logger.finestOn()) {
            logger.finest("translateParameters", " contextName :" + byArray);
            logger.finest("translateParameters", " msgFlags :" + n);
        }
        snmpV3Parameters.setSecurityLevel(n);
        snmpV3Parameters.setContextName(byArray);
        if (logger.finestOn()) {
            logger.finest("translateParameters", "Returned parameters : " + snmpV3Parameters);
        }
        return snmpV3Parameters;
    }
}

